// --------------------------------------------------------------------
// CGzXfl.hxx
// Whatis:	gz members
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	07-MAR-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CGz.hxx instead.
// --------------------------------------------------------------------
#ifndef	CGzXfl_hxx
#define	CGzXfl_hxx

#include	"IZipStream.hxx"

// --------------------------------------------------------------------
// Declaration of the CGzXfl class
// --------------------------------------------------------------------
class	CGzXfl {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CGzXfl	();
	~CGzXfl	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CGzXfl				( const CGzXfl & );
    CGzXfl & operator =	( const CGzXfl & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	// Read the zip
	// ----------------------------------------------------------------
	void		Read		( IZipStream & aReader );

	// ----------------------------------------------------------------
	// Save the zip
	// ----------------------------------------------------------------
	void		Write		( IZipStream & aReader );

	// ----------------------------------------------------------------
	void		Cleanup	( void );


	// ----------------------------------------------------------------
	public:		// Interfaces
	// ----------------------------------------------------------------
	byte_t		Flag	( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free				( void );
	void		Clear				( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	byte_t		itsFlag;
};

#endif	// #ifdef  CGzXfl_hxx
// --------------------------------------------------------------------
// EOF:	CGzXfl.hxx
// --------------------------------------------------------------------
