// --------------------------------------------------------------------
// CTar.hxx
// Whatis:	Class for writing tar files
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
#ifndef	CTar_hxx
#define	CTar_hxx

#include	"CZipStreamTar.hxx"
#include	"CZipNotification.hxx"

// --------------------------------------------------------------------
// Declaration of the CTar class
// --------------------------------------------------------------------
class	CTar {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CTar		( const CTarFile_l & );
	~CTar		();

	// ----------------------------------------------------------------
	private:	// Copy constructor and assignment operator invalid
	// ----------------------------------------------------------------
	CTar				( const CTar & );
    CTar & operator =	( const CTar & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void		WriteTar	( const char * aFileName, CZipNotification * );
	void		WriteTarGz	( const char * aFileName, CZipNotification * );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		FillNotification( CZipNotification *, const char * );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	CTarFile_l	itsTarFileList;

};

#endif	// #ifdef  CTar_hxx
// --------------------------------------------------------------------
// EOF:	CTar.hxx
// --------------------------------------------------------------------
