// --------------------------------------------------------------------
// CZipCentralDir.hxx
// Whatis:	Central directory of a zip file
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipCentralDir_hxx
#define	CZipCentralDir_hxx

#include	"CGz.hxx"
#include	"CZipFileBlock.hxx"
#include	"CZipFileHeader.hxx"
#include	"CZipDigitalSignature.hxx"
#include	"CZipHeaderSignature.hxx"
#include	"CZipEOCD.hxx"
#include	"CZipFlags.hxx"
#include	"IZipStream.hxx"

// --------------------------------------------------------------------
// Declaration of the CZipCentralDir class
// --------------------------------------------------------------------
class	CZipCentralDir {

	// ----------------------------------------------------------------
	public:		// Constructor
	// ----------------------------------------------------------------
	CZipCentralDir	();
	~CZipCentralDir	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CZipCentralDir				( const CZipCentralDir & );
    CZipCentralDir & operator =	( const CZipCentralDir & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void		Read				( const CZipHeaderSignature &, IZipStream & );
	void		Write				( CZipFileBlock_l &, IZipStream & );
	void		Cleanup				( void );
    void		AddZipComment		( const char * aComment );
    void		AddFileComment		( const char * aFilter, const char * aComment = NULL );
    void		DelDirectoryEntry	( const char * aFilter = NULL );
    void		AddDirectoryEntry	( const CZipFlags &, const char *, const char * );
    void		AddDirectoryEntry	( const CZipFlags &, const CZipFileBlock &, const char * );
    void		AddDirectoryEntry	( const CGz &, const char *, time_t );
    void		Update				( const CZipFileBlock_l & );

	// ----------------------------------------------------------------
    dword_t		ZippedSize	( void ) const;

	// ----------------------------------------------------------------
	public:		// Access instance data
	// ----------------------------------------------------------------
	const CZipFileHeader_l &		FileHeaders		( void ) const;
	const CZipDigitalSignature &	DigitalSignature( void ) const;
	const CZipEOCD &				EOCD			( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free				( void );
	void		Clear				( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	CZipFileHeader_l		itsFileHeaders;
	CZipDigitalSignature	itsDigitalSignature;
	CZipEOCD				itsEOCD;
};

#endif	// #ifdef  CZipCentralDir_hxx
// --------------------------------------------------------------------
// EOF:	CZipCentralDir.hxx
// --------------------------------------------------------------------
