// --------------------------------------------------------------------
// CZipCrc32.hxx
// Whatis:	File data
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipCrc32_hxx
#define	CZipCrc32_hxx

#include	"IZipStream.hxx"
#include	"CCrc32.hxx"

// --------------------------------------------------------------------
// Declaration of the CZipCrc32 class
// --------------------------------------------------------------------
class	CZipCrc32 {

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CZipCrc32	();
	CZipCrc32	( dword_t aV );
	~CZipCrc32	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CZipCrc32				( const CZipCrc32 & aC );
    CZipCrc32 & operator =	( const CZipCrc32 & aC );
    CZipCrc32 & operator =	( dword_t aV );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
	bool operator == ( const CZipCrc32 & aC ) const;
	bool operator != ( const CZipCrc32 & aC ) const;

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void	Calculate	( const void * aData, dword_t aLen );
	void	Read		( IZipStream & );
	void	Write		( IZipStream & );
	void	Cleanup		( void );

	// ----------------------------------------------------------------
    dword_t		ZippedSize	( void ) const;

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
    dword_t	Crc32	( void ) const;
    void	Crc32	( dword_t aV );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free				( void );
	void		Clear				( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	CCrc32		itsCrc32;
};

#endif	// #ifdef  CZipCrc32_hxx
// --------------------------------------------------------------------
// EOF:	CZipCrc32.hxx
// --------------------------------------------------------------------
