// --------------------------------------------------------------------
// CZipDataDescriptor.hxx
// Whatis:	Data descriptor
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipDataDescriptor_hxx
#define	CZipDataDescriptor_hxx

#include	"CZipLocalFileHeader.hxx"
#include	"CZipCrc32.hxx"
#include	"CZipDword.hxx"
#include	"IZipStream.hxx"

// --------------------------------------------------------------------
//	crc-32                          4 bytes
//	compressed size                 4 bytes
//	uncompressed size               4 bytes
// --------------------------------------------------------------------


// --------------------------------------------------------------------
// Declaration of the CZipDataDescriptor class
// --------------------------------------------------------------------
class	CZipDataDescriptor {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CZipDataDescriptor	();
	~CZipDataDescriptor	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operators
	// ----------------------------------------------------------------
	CZipDataDescriptor				( const CZipDataDescriptor & );
    CZipDataDescriptor & operator =	( const CZipDataDescriptor & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void		Read	( CZipLocalFileHeader &, IZipStream & );
	void		Write	( CZipLocalFileHeader &, IZipStream & );
	void		Cleanup	( void );

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const CZipCrc32 &	Crc32			( void ) const;
	const CZipDword &	CompressedSize	( void ) const;
	const CZipDword &	UncompressedSize( void ) const;

	void				Crc32			( dword_t );
	void				CompressedSize	( dword_t );
	void				UncompressedSize( dword_t );

	// ----------------------------------------------------------------
    dword_t		ZippedSize	( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free				( void );
	void		Clear				( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	CZipCrc32	itsCrc32;
	CZipDword	itsCompressedSize;
	CZipDword	itsUncompressedSize;
};


#endif	// #ifdef  CZipDataDescriptor_hxx
// --------------------------------------------------------------------
// EOF:	CZipDataDescriptor.hxx
// --------------------------------------------------------------------
