// --------------------------------------------------------------------
// CZipDataField.hxx
// Whatis:	File data
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipDataField_hxx
#define	CZipDataField_hxx

#include	"IZipStream.hxx"
#include	"CZipFlags.hxx"
#include	"CZipCrc32.hxx"
#include	"CZipNotification.hxx"

// --------------------------------------------------------------------
// Declaration of the CZipDataField class
// --------------------------------------------------------------------
class	CZipDataField {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CZipDataField	();
	~CZipDataField	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operators
	// ----------------------------------------------------------------
	CZipDataField				( const CZipDataField & );
	CZipDataField & operator =	( const CZipDataField & );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
    bool operator == ( const char * ) const;
    bool operator != ( const char * ) const;

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void			Read	( IZipStream &, dword_t aLen );
	void			Compress( const CZipFlags &, IZipStream &, CZipNotification * );
	void			Compress( const CZipFlags &, IZipStream &, IZipStream &, CZipNotification * );
	void			Write	( IZipStream & );
	void			Cleanup	( void );
	dword_t			Size	( void ) const;
	const byte_t * 	Data	( void ) const;
    void		   	Data	( const char * );
    void			RawData	( const byte_t *, dword_t );
    CZipCrc32		Crc32	( void ) const;

	// ----------------------------------------------------------------
    dword_t		ZippedSize	( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free				( void );
	void		Clear				( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	dword_t		itsSize;
	byte_t *	itsData;
    CZipCrc32	itsCrc32;
};

#endif	// #ifdef  CZipDataField_hxx
// --------------------------------------------------------------------
// EOF:	CZipDataField.hxx
// --------------------------------------------------------------------
