// --------------------------------------------------------------------
// CZipDeflate.hxx
// Whatis:	Class for compressing using the deflate method
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	20-JUN-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipDeflate_hxx
#define	CZipDeflate_hxx

#include	"IZipStream.hxx"
#include	"CZipFlags.hxx"
#include	"CZipCrc32.hxx"
#include	"CZipNotification.hxx"

// --------------------------------------------------------------------
// Declaration of the CZipDeflate class
// --------------------------------------------------------------------
class	CZipDeflate {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CZipDeflate		();
	~CZipDeflate	();

	// ----------------------------------------------------------------
	private:	// Copy constructor and assignment operator illegal
	// ----------------------------------------------------------------
	CZipDeflate					( const CZipDeflate & );
    CZipDeflate & operator =	( const CZipDeflate & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
    byte_t *	Compress		( CZipCrc32 &, dword_t &, const CZipFlags, IZipStream &, CZipNotification * );
    void		Compress		( CZipCrc32 &, dword_t &, const CZipFlags, IZipStream &, IZipStream &, CZipNotification * );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free				( void );
	void		Clear				( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
};

#endif	// #ifdef  CZipDeflate_hxx
// --------------------------------------------------------------------
// EOF:	CZipDeflate.hxx
// --------------------------------------------------------------------
