// --------------------------------------------------------------------
// CZipDigitalSignature.hxx
// Whatis:	Digital signature in the central directory
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipDigitalSignature_hxx
#define	CZipDigitalSignature_hxx

#include	"CZipHeaderSignature.hxx"
#include	"IZipStream.hxx"
#include	"CZipWord.hxx"
#include	"CZipDataField.hxx"

// --------------------------------------------------------------------
//	header signature                4 bytes  (0x05054b50)
//	size of data                    2 bytes
//	signature data (variable size)
// --------------------------------------------------------------------

// --------------------------------------------------------------------
// Declaration of the CZipCentralDir class
// --------------------------------------------------------------------
class	CZipDigitalSignature {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CZipDigitalSignature	();
	~CZipDigitalSignature	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CZipDigitalSignature				( const CZipDigitalSignature & aC );
    CZipDigitalSignature & operator =	( const CZipDigitalSignature & aC );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void		Read	( CZipHeaderSignature &, IZipStream & );
	void		Write	( IZipStream & );
	void		Cleanup	( void );

	// ----------------------------------------------------------------
    dword_t		ZippedSize	( void ) const;

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const CZipHeaderSignature &	Signature	( void ) const;
	const CZipWord &			Size		( void ) const;
	const CZipDataField &		Data		( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free				( void );
	void		Clear				( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	CZipHeaderSignature		itsSignature;
	CZipWord				itsSize;
	CZipDataField			itsData;
};

#endif	// #ifdef  CZipDigitalSignature_hxx
// --------------------------------------------------------------------
// EOF:	CZipDigitalSignature.hxx
// --------------------------------------------------------------------
