// --------------------------------------------------------------------
// CZipDword.hxx
// Whatis:	File data
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipDword_hxx
#define	CZipDword_hxx

#include	"IZipStream.hxx"

// --------------------------------------------------------------------
// Declaration of the CZipDword class
// --------------------------------------------------------------------
class	CZipDword {

	// ----------------------------------------------------------------
	public:		// Constructors and destructor
	// ----------------------------------------------------------------
	CZipDword	();
	CZipDword	( dword_t aW );
	~CZipDword	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operators
	// ----------------------------------------------------------------
	CZipDword				( const CZipDword & );
	CZipDword & operator =	( const CZipDword & );
	CZipDword & operator =	( dword_t );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void			Read	( IZipStream & );
	void			Write	( IZipStream & );
	void			Cleanup	( void );
	dword_t			Value	( void ) const;
	void			Value	( dword_t aV );

	// ----------------------------------------------------------------
    dword_t		ZippedSize	( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free				( void );
	void		Clear				( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	dword_t		itsDword;
};

#endif	// #ifdef  CZipDword_hxx
// --------------------------------------------------------------------
// EOF:	CZipDword.hxx
// --------------------------------------------------------------------
