// --------------------------------------------------------------------
// CZipEOCD.hxx
// Whatis:	End of central directory record
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipEOCD_hxx
#define	CZipEOCD_hxx

#include	"CZipDigitalSignature.hxx"
#include	"CZipFileHeader.hxx"
#include	"IZipStream.hxx"
#include	"CZipWord.hxx"
#include	"CZipDword.hxx"
#include	"CZipDataField.hxx"

// --------------------------------------------------------------------
//	end of central dir signature    4 bytes  (0x06054b50)
//	number of this disk             2 bytes
//	number of the disk with the
//	start of the central directory  2 bytes
//	total number of entries in
//	the central dir on this disk    2 bytes
//	total number of entries in
//	the central dir                 2 bytes
//	size of the central directory   4 bytes
//	offset of start of central
//	directory with respect to
//	the starting disk number        4 bytes
//	.ZIP file comment length        2 bytes
//	.ZIP file comment       (variable size)
// --------------------------------------------------------------------

// --------------------------------------------------------------------
// Declaration of the CZipEOCD class
// --------------------------------------------------------------------
class	CZipEOCD {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CZipEOCD	();
	~CZipEOCD	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CZipEOCD				( const CZipEOCD & );
	CZipEOCD & operator =	( const CZipEOCD & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void		Read			( CZipHeaderSignature &, IZipStream & );
	void		Write			( IZipStream & );
	void		Cleanup			( void );
    void		AddZipComment	( const char * );
    void		Update			( const CZipFileHeader_l &, dword_t );

	// ----------------------------------------------------------------
    dword_t		ZippedSize	( void ) const;

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
	const CZipHeaderSignature &	Signature					( void ) const;
	const CZipWord &			DiskNumber					( void ) const;
	const CZipWord &			CentralDirDiskNumber		( void ) const;
	const CZipWord &			CentralDirDiskEntryCount	( void ) const;
	const CZipWord &			CentralDirTotalEntryCount	( void ) const;
	const CZipDword	&			CentralDirSize				( void ) const;
	const CZipDword	&			CentralDirOffset			( void ) const;
	const CZipWord	&			CommentSize					( void ) const;
	const CZipDataField	&		Comment						( void ) const;

	void						DiskNumber					( word_t );
	void						CentralDirDiskNumber		( word_t );
	void						CentralDirDiskEntryCount	( word_t );
	void						CentralDirTotalEntryCount	( word_t );
	void						CentralDirSize				( dword_t );
	void						CentralDirOffset			( dword_t );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free				( void );
	void		Clear				( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	CZipHeaderSignature		itsSignature;
	CZipWord				itsDiskNumber;
	CZipWord				itsCentralDirDiskNumber;
	CZipWord				itsCentralDirDiskEntryCount;
	CZipWord				itsCentralDirTotalEntryCount;
	CZipDword				itsCentralDirSize;
	CZipDword				itsCentralDirOffset;
	CZipWord				itsCommentSize;
	CZipDataField			itsComment;
};

#endif	// #ifdef  CZipEOCD_hxx
// --------------------------------------------------------------------
// EOF:	CZipEOCD.hxx
// --------------------------------------------------------------------
