// --------------------------------------------------------------------
// CZipExternalAttr.hxx
// Whatis:	File data
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipExternalAttr_hxx
#define	CZipExternalAttr_hxx

#include	"IZipStream.hxx"

// --------------------------------------------------------------------
// The mapping of the external attributes is
// host-system dependent (see 'version made by').  For
// MS-DOS, the low order byte is the MS-DOS directory
// attribute byte.  If input came from standard input, this
// field is set to zero.
// --------------------------------------------------------------------

// --------------------------------------------------------------------
// Declaration of the CZipExternalAttr class
// --------------------------------------------------------------------
class	CZipExternalAttr {

	// ----------------------------------------------------------------
	public:		// Constructors and destructor
	// ----------------------------------------------------------------
	CZipExternalAttr	();
	CZipExternalAttr	( dword_t aV );
	~CZipExternalAttr	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CZipExternalAttr				( const CZipExternalAttr & aC );
	CZipExternalAttr & operator =	( const CZipExternalAttr & aC );
	CZipExternalAttr & operator =	( dword_t aV );

	// ----------------------------------------------------------------
	public:		// Interfaces
	// ----------------------------------------------------------------
	void		Read	( IZipStream & );
	void		Write	( IZipStream & );
	void		Cleanup	( void );

	// ----------------------------------------------------------------
    dword_t		ZippedSize	( void ) const;

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
    dword_t		Attributes	( void ) const;
    void		Attributes	( dword_t aV );

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free				( void );
	void		Clear				( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	dword_t		itsAttributes;

};

#endif	// #ifdef  CZipExternalAttr_hxx
// --------------------------------------------------------------------
// EOF:	CZipExternalAttr.hxx
// --------------------------------------------------------------------
