// --------------------------------------------------------------------
// CZipHeaderSignature.hxx
// Whatis:	File data
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipHeaderSignature_hxx
#define	CZipHeaderSignature_hxx

#include	"IZipStream.hxx"

// --------------------------------------------------------------------
//	local file header signature     4 bytes  (0x04034b50)
//	In the file there should be the following bytes: 50 4B 03 04
//
//	central file header signature   4 bytes  (0x02014b50)
//	In the file there should be the following bytes: 50 4B 01 02
//
//	digital signature               4 bytes  (0x05054b50)
//	In the file there should be the following bytes: 50 4B 05 05
//
//	end of central dir signature    4 bytes  (0x06054b50)
//	In the file there should be the following bytes: 50 4B 05 06
// --------------------------------------------------------------------
typedef	enum {
	zip_signature_localfile,
	zip_signature_centralfile,
	zip_signature_digital,
	zip_signature_eocd,
	zip_signature_unknown,
}	zip_signature_t;

// --------------------------------------------------------------------
// Declaration of the CZipHeaderSignature class
// --------------------------------------------------------------------
class	CZipHeaderSignature {

	// ----------------------------------------------------------------
	public:		// Constructors and destructor
	// ----------------------------------------------------------------
	CZipHeaderSignature	();
	CZipHeaderSignature	( zip_signature_t );
	~CZipHeaderSignature();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operators
	// ----------------------------------------------------------------
	CZipHeaderSignature					( const CZipHeaderSignature & );
	CZipHeaderSignature & operator =	( const CZipHeaderSignature & );
	CZipHeaderSignature & operator =	( zip_signature_t );

	// ----------------------------------------------------------------
	public:		// Comparison operators
	// ----------------------------------------------------------------
	bool operator == ( const CZipHeaderSignature & ) const;
	bool operator != ( const CZipHeaderSignature & ) const;
	bool operator == ( zip_signature_t ) const;
	bool operator != ( zip_signature_t ) const;

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void			Read	( IZipStream & );
	void			Write	( IZipStream & );
	void			Cleanup	( void );
	zip_signature_t	Type	( void ) const;
	void			Type	( zip_signature_t aType );

	// ----------------------------------------------------------------
    dword_t		ZippedSize	( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free				( void );
	void		Clear				( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	byte_t		itsSignature	[4];	// Should be 50 4B 03 04
										//        or 50 4B 01 02
										//        or 50 4B 05 05
										//        or 50 4B 05 06
	zip_signature_t	itsType;
};

#endif	// #ifdef  CZipHeaderSignature_hxx
// --------------------------------------------------------------------
// EOF:	CZipHeaderSignature.hxx
// --------------------------------------------------------------------
