// --------------------------------------------------------------------
// CZipLocalFileHeader.hxx
// Whatis:	Local file header
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipLocalFileHeader_hxx
#define	CZipLocalFileHeader_hxx

#include	"CGz.hxx"
#include	"CZipHeaderSignature.hxx"
#include	"CZipVersion.hxx"
#include	"CZipHeaderBitFlag.hxx"
#include	"CZipCompressionMethod.hxx"
#include	"CZipDateTime.hxx"
#include	"CZipCrc32.hxx"
#include	"CZipDword.hxx"
#include	"CZipWord.hxx"
#include	"CZipDataField.hxx"
#include	"CZipFlags.hxx"
#include	"IZipStream.hxx"


// --------------------------------------------------------------------
// Structure of the local file header
// --------------------------------------------------------------------
//	A.  Local file header:
//
//	local file header signature     4 bytes  (0x04034b50)
//	version needed to extract       2 bytes
//	general purpose bit flag        2 bytes
//	compression method              2 bytes
//	last mod file time              2 bytes
//	last mod file date              2 bytes
//	crc-32                          4 bytes
//	compressed size                 4 bytes
//	uncompressed size               4 bytes
//	filename length                 2 bytes
//	extra field length              2 bytes
//
//	filename (variable size)
//	extra field (variable size)
// --------------------------------------------------------------------


// --------------------------------------------------------------------
// Declaration of the CZipLocalFileHeader class
// --------------------------------------------------------------------
class	CZipLocalFileHeader {

	// ----------------------------------------------------------------
	public:		// Constructor and destructor
	// ----------------------------------------------------------------
	CZipLocalFileHeader	();
	CZipLocalFileHeader ( const CZipFlags &, const char *, const char * );
	CZipLocalFileHeader ( const CZipFlags &, IZipStream *, dword_t, const char * );
	CZipLocalFileHeader ( const CZipFlags &, const char *, dword_t, const char * );
    CZipLocalFileHeader	( const CGz &, const char *, time_t );
	~CZipLocalFileHeader();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
	CZipLocalFileHeader				( const CZipLocalFileHeader & );
    CZipLocalFileHeader & operator =( const CZipLocalFileHeader & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void			Read					( const CZipHeaderSignature &, IZipStream & );
	void			Write					( IZipStream & );
	void			Cleanup					( void );
    void			FileName				( const char * );
    void			UncompressedSize		( dword_t );
    void			LastModificationTime	( time_t );
    char *			TargetPath				( const char * aTarget, bool aFlatten );
    void			SetLateDetails			( void );

	// ----------------------------------------------------------------
    dword_t		ZippedSize	( void ) const;

	// ----------------------------------------------------------------
	public:		// Accessing instance data
	// ----------------------------------------------------------------
    const CZipHeaderSignature &		Signature			( void ) const;
	const CZipVersion &				ExtractVersion		( void ) const;
	const CZipHeaderBitFlag &		BitFlag				( void ) const;
	const CZipCompressionMethod &	CompressionMethod	( void ) const;
	const CZipDateTime &			LastModificationTime( void ) const;
	const CZipCrc32 &				Crc32				( void ) const;
	void							Crc32				( const CZipCrc32 & );
	const CZipDword &				CompressedSize		( void ) const;
	void							CompressedSize		( dword_t );
	const CZipDword &				UncompressedSize	( void ) const;
	const CZipWord &				FilenameLength		( void ) const;
	const CZipWord &				ExtraFieldLength	( void ) const;
	const CZipDataField &			FileName			( void ) const;
	const CZipDataField &			ExtraField			( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free				( void );
	void		Clear				( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
    CZipHeaderSignature		itsSignature;
	CZipVersion				itsExtractVersion;
	CZipHeaderBitFlag		itsBitFlag;
	CZipCompressionMethod	itsCompressionMethod;
	CZipDateTime			itsLastModificationTime;
	CZipCrc32				itsCrc32;
	CZipDword				itsCompressedSize;
	CZipDword				itsUncompressedSize;
	CZipWord				itsFilenameLength;
	CZipWord				itsExtraFieldLength;
	CZipDataField			itsFileName;
	CZipDataField			itsExtraField;
};

#endif	// #ifdef  CZipLocalFileHeader_hxx
// --------------------------------------------------------------------
// EOF:	CZipLocalFileHeader.hxx
// --------------------------------------------------------------------
