// --------------------------------------------------------------------
// CZipNotification.hxx
// Whatis:	Zip progress notification
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipNotification_hxx
#define	CZipNotification_hxx

#include	"CCpuMutex.hxx"

// --------------------------------------------------------------------
// Declaration of the CZipNotification class
// --------------------------------------------------------------------
class	CZipNotification {

	// ----------------------------------------------------------------
	public:		// Constructors
	// ----------------------------------------------------------------
	CZipNotification	();
	~CZipNotification	();

	// ----------------------------------------------------------------
	private:	// Copy constructor and assignment operator invalidated
	// ----------------------------------------------------------------
	CZipNotification				( const CZipNotification & );
    CZipNotification & operator =	( const CZipNotification & );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	const char *	Task			( void );
	const char *	FileName		( void );
	dword_t			TotalFiles		( void );
	dword_t			FilesDone		( void );
	dword_t			FileBytes		( void );
	dword_t			FileBytesDone	( void );
	dword_t			TotalBytes		( void );
	dword_t			TotalBytesDone	( void );
	bool			Aborting		( void );
    bool			Ready			( void );

	void			Task			( const char * );
	void			FileName		( const char * );
	void			TotalFiles		( dword_t );
	void			FilesDone		( dword_t );
	void			FileBytes		( dword_t );
	void			FileBytesDone	( dword_t );
	void			TotalBytes		( dword_t );
	void			TotalBytesDone	( dword_t );
	void			Aborting		( bool );
    void			Ready			( bool );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	CCpuMutex		itsMutex;
	const char *	itsTask;
	const char *	itsFileName;
	dword_t			itsTotalFiles;
	dword_t			itsFilesDone;
	dword_t			itsFileBytes;
	dword_t			itsFileBytesDone;
	dword_t			itsTotalBytes;
	dword_t			itsTotalBytesDone;
	bool			itsAborting;
    bool			itsReady;

};

#endif	// #ifdef  CZipNotification_hxx
// --------------------------------------------------------------------
// EOF:	CZipNotification.hxx
// --------------------------------------------------------------------
