// --------------------------------------------------------------------
// CZipWord.hxx
// Whatis:	File data
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CZip.hxx instead.
// --------------------------------------------------------------------
#ifndef	CZipWord_hxx
#define	CZipWord_hxx

#include	"IZipStream.hxx"

// --------------------------------------------------------------------
// Declaration of the CZipWord class
// --------------------------------------------------------------------
class	CZipWord {

	// ----------------------------------------------------------------
	public:		// Constructors and destructor
	// ----------------------------------------------------------------
	CZipWord	();
	CZipWord	( word_t aW );
	~CZipWord	();

	// ----------------------------------------------------------------
	public:		// Copy constructor and assignment operator
	// ----------------------------------------------------------------
    CZipWord 			  ( const CZipWord & aC );
	CZipWord & operator = ( const CZipWord & aC );
	CZipWord & operator = ( word_t aW );

	// ----------------------------------------------------------------
	public:		// Interface
	// ----------------------------------------------------------------
	void			Read	( IZipStream & );
	void			Write	( IZipStream & );
	void			Cleanup	( void );
	word_t			Value	( void ) const;
	void			Value	( word_t aV );

	// ----------------------------------------------------------------
    dword_t		ZippedSize	( void ) const;

	// ----------------------------------------------------------------
	private:	// Private helpers
	// ----------------------------------------------------------------
    void		Free				( void );
	void		Clear				( void );

	// ----------------------------------------------------------------
	private:	// Instance data
	// ----------------------------------------------------------------
	word_t		itsWord;
};

#endif	// #ifdef  CZipWord_hxx
// --------------------------------------------------------------------
// EOF:	CZipWord.hxx
// --------------------------------------------------------------------
