// --------------------------------------------------------------------
// CGzComment.cpp
// Whatis:	gz members
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	07-MAR-2003		Created	this source
// --------------------------------------------------------------------
#include	"CGzComment.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:	Constructors and destructors
// --------------------------------------------------------------------
CGzComment::CGzComment	() {
	CGzComment::Clear();
}

// --------------------------------------------------------------------
CGzComment::~CGzComment	() {
	CGzComment::Free();
}

// --------------------------------------------------------------------
CGzComment::CGzComment				( const CGzComment & aC ) {
	CGzComment::Clear();
    if	( aC.Comment() ) {
    	itsComment = new char [ ::strlen( aC.Comment() ) + 1 ];
        ::strcpy( itsComment, aC.Comment() );
    }
}

// --------------------------------------------------------------------
CGzComment & CGzComment::operator =	( const CGzComment & aC ) {
	CGzComment::Free();
    if	( aC.Comment() ) {
    	itsComment = new char [ ::strlen( aC.Comment() ) + 1 ];
        ::strcpy( itsComment, aC.Comment() );
    }
	return *this;
}

// --------------------------------------------------------------------
// public:	Interfaces
// --------------------------------------------------------------------
void			CGzComment::Read		( IZipStream & aReader ) {
	char	mycomment[8192];
    dword_t	szt;
    int		mypos	= 0;

	CGzComment::Free();

	while	( mypos < (int)sizeof( mycomment ) ) {
		szt = aReader.Read( mycomment + mypos, 1 );
        if	( szt < 1 ) {
        	throw CError( aReader.Name(), "Not enough data" );
        }
        if	( mycomment[mypos] == 0 )	break;
		mypos++;
    }
	if	( mypos >= (int)sizeof( mycomment ) ) {
    	throw CError( aReader.Name(), "Too long comment" );
    }
   	itsComment = new char [ ::strlen( mycomment ) + 1 ];
    ::strcpy( itsComment, mycomment );
}

// --------------------------------------------------------------------
void			CGzComment::Write		( IZipStream & aWriter ) {
	if	( itsComment ) {
    	aWriter.Write( itsComment, ::strlen( itsComment ) + 1 );
    }
}

// --------------------------------------------------------------------
void			CGzComment::Cleanup		( void ) {
	CGzComment::Free();
}

// --------------------------------------------------------------------
const char *	CGzComment::Comment		( void ) const {
	return itsComment;
}

// --------------------------------------------------------------------
void			CGzComment::Free		( void ) {
	if	( itsComment )	delete [] itsComment;
	CGzComment::Clear();
}

// --------------------------------------------------------------------
void			CGzComment::Clear		( void ) {
	itsComment = NULL;
}

// --------------------------------------------------------------------
// EOF:	CGzComment.cpp
// --------------------------------------------------------------------
