// --------------------------------------------------------------------
// CGzExtra.cpp
// Whatis:	gz members
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	10-MAR-2003		Created	this source
// --------------------------------------------------------------------
#include	"CGzExtra.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:	Constructors and destructor
// --------------------------------------------------------------------
CGzExtra::CGzExtra	() {
	CGzExtra::Clear();
}

// --------------------------------------------------------------------
CGzExtra::~CGzExtra	() {
	CGzExtra::Free();
}

// --------------------------------------------------------------------
CGzExtra::CGzExtra				( const CGzExtra & aC ) {
	CGzExtra::Clear();
    itsSize = aC.Size();
    if	( aC.Data() ) {
    	itsData = new byte_t [ itsSize.Value() ];
        ::memcpy( itsData, aC.Data(), itsSize.Value() );
    }
}

// --------------------------------------------------------------------
CGzExtra & CGzExtra::operator =	( const CGzExtra & aC ) {
	CGzExtra::Free();
    itsSize = aC.Size();
    if	( aC.Data() ) {
    	itsData = new byte_t [ itsSize.Value() ];
        ::memcpy( itsData, aC.Data(), itsSize.Value() );
    }
	return *this;
}

// --------------------------------------------------------------------
// public:	Interfaces
// --------------------------------------------------------------------
void			CGzExtra::Read		( IZipStream & aReader ) {
	CGzExtra::Free();
    itsSize.Read( aReader );
    if	( itsSize.Value() > 0 ) {
    	itsData = new byte_t [itsSize.Value()];
        dword_t rzt = aReader.Read( itsData, itsSize.Value() );
        if	( rzt < (dword_t)itsSize.Value() ) {
        	throw CError( aReader.Name(), "Not enough data" );
        }
    }
}

// --------------------------------------------------------------------
void			CGzExtra::Write		( IZipStream & aWriter ) {
	itsSize.Write( aWriter );
    if	( itsSize.Value() > 0 ) {
    	aWriter.Write( itsData, itsSize.Value() );
    }
}

// --------------------------------------------------------------------
void			CGzExtra::Cleanup		( void ) {
	CGzExtra::Free();
}

// --------------------------------------------------------------------
CZipWord		CGzExtra::Size	( void ) const {
	return	itsSize;
}

// --------------------------------------------------------------------
const byte_t *	CGzExtra::Data	( void ) const {
	return	itsData;
}

// --------------------------------------------------------------------
// private:	Private helpers
// --------------------------------------------------------------------
void		CGzExtra::Free		( void ) {
	if	( itsData )	delete [] itsData;
	CGzExtra::Clear();
}

// --------------------------------------------------------------------
void		CGzExtra::Clear		( void ) {
	itsSize.Cleanup();
    itsData	= NULL;
}

// --------------------------------------------------------------------
// EOF:	CGzExtra.cpp
// --------------------------------------------------------------------
