// --------------------------------------------------------------------
// CGzFhCrc.cpp
// Whatis:	gz members
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	10-MAR-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CGz.hxx instead.
// --------------------------------------------------------------------
#include	"CGzFhCrc.hxx"

// --------------------------------------------------------------------
// public:	Constructors and destructor
// --------------------------------------------------------------------
CGzFhCrc::CGzFhCrc	() {
	CGzFhCrc::Clear();
}

// --------------------------------------------------------------------
CGzFhCrc::~CGzFhCrc	() {
	CGzFhCrc::Free();
}

// --------------------------------------------------------------------
CGzFhCrc::CGzFhCrc				( const CGzFhCrc & aC ) {
	CGzFhCrc::Clear();
    itsCrc = aC.Crc();
}

// --------------------------------------------------------------------
CGzFhCrc & CGzFhCrc::operator =	( const CGzFhCrc & aC ) {
	CGzFhCrc::Free();
    itsCrc = aC.Crc();
	return *this;
}

// --------------------------------------------------------------------
// public:	Interfaces
// --------------------------------------------------------------------
void		CGzFhCrc::Read	( IZipStream & aReader ) {
	CGzFhCrc::Free();
	itsCrc.Read( aReader );
}

// --------------------------------------------------------------------
void		CGzFhCrc::Write	( IZipStream & aWriter ) {
	itsCrc.Write( aWriter );
}

// --------------------------------------------------------------------
void		CGzFhCrc::Cleanup	( void ) {
	CGzFhCrc::Free();
}

// --------------------------------------------------------------------
CZipWord	CGzFhCrc::Crc		( void ) const {
	return	itsCrc;
}

// --------------------------------------------------------------------
// private:	Private helpers
// --------------------------------------------------------------------
void		CGzFhCrc::Free	( void ) {
	CGzFhCrc::Clear();
}

// --------------------------------------------------------------------
void		CGzFhCrc::Clear	( void ) {
	itsCrc.Cleanup();
}

// --------------------------------------------------------------------
// EOF:	CGzFhCrc.cpp
// --------------------------------------------------------------------
