// --------------------------------------------------------------------
// CGzFlag.cpp
// Whatis:	gz members
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	10-MAR-2003		Created	this source
// --------------------------------------------------------------------
#include	"CGzFlag.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:	Constructors and destructor
// --------------------------------------------------------------------
CGzFlag::CGzFlag	() {
	CGzFlag::Clear();
}

// --------------------------------------------------------------------
CGzFlag::~CGzFlag	() {
	CGzFlag::Free();
}

// --------------------------------------------------------------------
CGzFlag::CGzFlag				( const CGzFlag & aC ) {
	CGzFlag::Clear();
	itsFlag = aC.Flag();
}

// --------------------------------------------------------------------
CGzFlag & CGzFlag::operator =	( const CGzFlag & aC ) {
	CGzFlag::Free();
	itsFlag = aC.Flag();
    return *this;
}

// --------------------------------------------------------------------
// public:	Interfaces
// --------------------------------------------------------------------
void		CGzFlag::Read		( IZipStream & aReader ) {
	CGzFlag::Free();
    if	( aReader.Read( &itsFlag, 1 ) < 1 )	throw CError( aReader.Name(), "Not enough data" );
    if	( (itsFlag & 0xE0 ) != 0 )	throw CError( aReader.Name(), "Invalid flags present" );
}

// --------------------------------------------------------------------
void		CGzFlag::Write		( IZipStream & aWriter ) {
	aWriter.Write( &itsFlag, 1 );
}

// --------------------------------------------------------------------
void		CGzFlag::Cleanup	( void ) {
	CGzFlag::Free();
}

// --------------------------------------------------------------------
byte_t		CGzFlag::Flag		( void ) const {
	return	itsFlag;
}

// --------------------------------------------------------------------
bool		CGzFlag::FTEXT		( void ) const {
	return	(itsFlag & 0x01) != 0;
}

// --------------------------------------------------------------------
bool		CGzFlag::FHCRC		( void ) const {
	return	(itsFlag & 0x02) != 0;
}

// --------------------------------------------------------------------
bool		CGzFlag::FEXTRA		( void ) const {
	return	(itsFlag & 0x04) != 0;
}

// --------------------------------------------------------------------
bool		CGzFlag::FNAME		( void ) const {
	return	(itsFlag & 0x08) != 0;
}

// --------------------------------------------------------------------
bool		CGzFlag::FCOMMENT	( void ) const {
	return	(itsFlag & 0x10) != 0;
}

// --------------------------------------------------------------------
// private:	Private helpers
// --------------------------------------------------------------------
void		CGzFlag::Free		( void ) {
	CGzFlag::Clear();
}

// --------------------------------------------------------------------
void		CGzFlag::Clear		( void ) {
	itsFlag = 0;
}

// --------------------------------------------------------------------
// EOF:	CGzFlag.cpp
// --------------------------------------------------------------------
