// --------------------------------------------------------------------
// CGzId.cpp
// Whatis:	gz id
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	10-MAR-2003		Created	this source
// --------------------------------------------------------------------
#include	"CGzId.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:	Constructors and destructor
// --------------------------------------------------------------------
CGzId::CGzId	() {
	CGzId::Clear();
}

// --------------------------------------------------------------------
CGzId::~CGzId	() {
	CGzId::Free();
}

// --------------------------------------------------------------------
CGzId::CGzId				( const CGzId & aC ) {
	CGzId::Clear();
    itsId1 = aC.Id1();
    itsId2 = aC.Id2();
}

// --------------------------------------------------------------------
CGzId & CGzId::operator =	( const CGzId & aC ) {
	CGzId::Free();
    itsId1 = aC.Id1();
    itsId2 = aC.Id2();
    return *this;
}

// --------------------------------------------------------------------
// public:	Interfaces
// --------------------------------------------------------------------
void		CGzId::Read		( IZipStream & aReader ) {
	CGzId::Free();
	if	( aReader.Read( &itsId1, 1 ) < 1 )	throw CError( aReader.Name(), "Not enough data" );
	if	( aReader.Read( &itsId2, 1 ) < 1 )	throw CError( aReader.Name(), "Not enough data" );
	if	( itsId1 != 0x1f )	throw CError( aReader.Name(), "Not a GZ file" );
	if	( itsId2 != 0x8b )	throw CError( aReader.Name(), "Not a GZ file" );
}

// --------------------------------------------------------------------
void		CGzId::Write	( IZipStream & aWriter ) {
	CGzId::Clear();
	aWriter.Write( &itsId1, 1 );
	aWriter.Write( &itsId2, 1 );
}

// --------------------------------------------------------------------
void		CGzId::Cleanup				( void ) {
	CGzId::Free();
}

// --------------------------------------------------------------------
byte_t		CGzId::Id1	( void ) const {
	return	itsId1;
}

// --------------------------------------------------------------------
byte_t		CGzId::Id2	( void ) const {
	return	itsId2;
}

// --------------------------------------------------------------------
// private:	Private helpers
// --------------------------------------------------------------------
void		CGzId::Free		( void ) {
	CGzId::Clear();
}

// --------------------------------------------------------------------
void		CGzId::Clear	( void ) {
	itsId1	= 0x1f;
	itsId2	= 0x8b;
}

// --------------------------------------------------------------------
// EOF:	CGzId.cpp
// --------------------------------------------------------------------
