// --------------------------------------------------------------------
// CGzXfl.cpp
// Whatis:	gz members
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	10-MAR-2003		Created	this source
// --------------------------------------------------------------------
// You should NOT include this file to your code. Use CGz.hxx instead.
// --------------------------------------------------------------------
#include	"CGzXfl.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:	Constructors and destructor
// --------------------------------------------------------------------
CGzXfl::CGzXfl	() {
	CGzXfl::Clear();
}

// --------------------------------------------------------------------
CGzXfl::~CGzXfl	() {
	CGzXfl::Free();
}

// --------------------------------------------------------------------
CGzXfl::CGzXfl				( const CGzXfl & aC ) {
	CGzXfl::Clear();
	itsFlag = aC.Flag();
}

// --------------------------------------------------------------------
CGzXfl & CGzXfl::operator =	( const CGzXfl & aC ) {
	CGzXfl::Free();
	itsFlag = aC.Flag();
	return *this;
}

// --------------------------------------------------------------------
// public:	Interfaces
// --------------------------------------------------------------------
void		CGzXfl::Read	( IZipStream & aReader ) {
	CGzXfl::Free();
	if	( aReader.Read( &itsFlag, 1 ) < 1 )	throw CError( aReader.Name(), "Not enough data" );
}

// --------------------------------------------------------------------
void		CGzXfl::Write	( IZipStream & aWriter ) {
	aWriter.Write( &itsFlag, 1 );
}

// --------------------------------------------------------------------
void		CGzXfl::Cleanup	( void ) {
	CGzXfl::Free();
}

// --------------------------------------------------------------------
byte_t		CGzXfl::Flag	( void ) const {
	return	itsFlag;
}

// --------------------------------------------------------------------
// private:	Helpers
// --------------------------------------------------------------------
void		CGzXfl::Free	( void ) {
	CGzXfl::Clear();
}

// --------------------------------------------------------------------
void		CGzXfl::Clear	( void ) {
	itsFlag	= 0;
}

// --------------------------------------------------------------------
// EOF:	CGzXfl.cpp
// --------------------------------------------------------------------
