// --------------------------------------------------------------------
// CZipCompressionMethod.cpp
// Whatis:	File data
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	01-MAR-2003		Created	this source
// --------------------------------------------------------------------
#include	"CZipCompressionMethod.hxx"
#include	"CZipWord.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:	Constructor and destructor
// --------------------------------------------------------------------
CZipCompressionMethod::CZipCompressionMethod () {
	CZipCompressionMethod::Clear();
}

// --------------------------------------------------------------------
CZipCompressionMethod::~CZipCompressionMethod () {
	CZipCompressionMethod::Free();
}

// --------------------------------------------------------------------
// public:	Copy constructor and assignment operator
// --------------------------------------------------------------------
CZipCompressionMethod::CZipCompressionMethod				( const CZipCompressionMethod & aC ) {
	CZipCompressionMethod::Clear();
	itsCompressionMethod = aC.CompressionMethod();
}

// --------------------------------------------------------------------
CZipCompressionMethod & CZipCompressionMethod::operator =	( const CZipCompressionMethod & aC ) {
	CZipCompressionMethod::Free();
	itsCompressionMethod = aC.CompressionMethod();
	return *this;
}

// --------------------------------------------------------------------
// public:	Interfaces
// --------------------------------------------------------------------
void	CZipCompressionMethod::Read	( IZipStream & aReader ) {

   	CZipCompressionMethod::Free();

	CZipWord	data;
    data.Read( aReader );
    switch	( data.Value() ) {
		case	0:	itsCompressionMethod = zip_compression_method_stored;		break;
		case	1:	itsCompressionMethod = zip_compression_method_shrunk;		break;
		case	2:	itsCompressionMethod = zip_compression_method_reduced1;		break;
		case	3:	itsCompressionMethod = zip_compression_method_reduced2;		break;
		case	4:	itsCompressionMethod = zip_compression_method_reduced3;		break;
		case	5:	itsCompressionMethod = zip_compression_method_reduced4;		break;
		case	6:	itsCompressionMethod = zip_compression_method_imploded;		break;
		case	7:	itsCompressionMethod = zip_compression_method_tokenized;	break;
		case	8:	itsCompressionMethod = zip_compression_method_deflated;		break;
		case	9:	itsCompressionMethod = zip_compression_method_deflate64;	break;
		case	10:	itsCompressionMethod = zip_compression_method_datecomp;		break;
        default:	throw CError( aReader.Name(), "Invalid compression method" );
    }
}

// --------------------------------------------------------------------
void	CZipCompressionMethod::Write	( IZipStream & aWriter ) {
	CZipWord	data( (word_t)itsCompressionMethod );
    data.Write( aWriter );
}

// --------------------------------------------------------------------
void	CZipCompressionMethod::Free( void ) {
	CZipCompressionMethod::Clear();
}

// --------------------------------------------------------------------
void	CZipCompressionMethod::Clear( void ) {
	itsCompressionMethod = zip_compression_method_stored;
}

// --------------------------------------------------------------------
void						CZipCompressionMethod::Cleanup	( void ) { CZipCompressionMethod::Free(); }
zip_compression_method_t	CZipCompressionMethod::CompressionMethod (void) const { return itsCompressionMethod; }
void						CZipCompressionMethod::CompressionMethod (zip_compression_method_t aM ) { itsCompressionMethod = aM; }

// --------------------------------------------------------------------
dword_t	CZipCompressionMethod::ZippedSize	( void ) const {
	return  2;
}

// --------------------------------------------------------------------
// EOF:	CZipCompressionMethod.cpp
// --------------------------------------------------------------------
