// --------------------------------------------------------------------
// CZipDataDescriptor.cpp
// Whatis:	Data descriptor
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	02-MAR-2003		Created	this source
// --------------------------------------------------------------------
#include	"CZipDataDescriptor.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:	Constructor and destructor
// --------------------------------------------------------------------
CZipDataDescriptor::CZipDataDescriptor () {
	CZipDataDescriptor::Clear();
}

// --------------------------------------------------------------------
CZipDataDescriptor::~CZipDataDescriptor () {
	CZipDataDescriptor::Free();
}

// --------------------------------------------------------------------
// public:	Copy constructor and assignment operators
// --------------------------------------------------------------------
CZipDataDescriptor::CZipDataDescriptor				( const CZipDataDescriptor & aC ) {
	CZipDataDescriptor::Clear();
	itsCrc32			= aC.Crc32();
	itsCompressedSize	= aC.CompressedSize();
	itsUncompressedSize	= aC.UncompressedSize();
}

// --------------------------------------------------------------------
CZipDataDescriptor & CZipDataDescriptor::operator =	( const CZipDataDescriptor & aC ) {
	CZipDataDescriptor::Free();
	itsCrc32			= aC.Crc32();
	itsCompressedSize	= aC.CompressedSize();
	itsUncompressedSize	= aC.UncompressedSize();
	return *this;
}

// --------------------------------------------------------------------
// public:	Interfaces
// --------------------------------------------------------------------
void	CZipDataDescriptor::Read	( CZipLocalFileHeader & aHdr, IZipStream & aReader ) {
	CZipDataDescriptor::Free();
	if	( aHdr.BitFlag().LateDetails() ) {
    	itsCrc32.Read			( aReader );
		itsCompressedSize.Read	( aReader );
		itsUncompressedSize.Read( aReader );
    }
    else {
    	itsCrc32				= aHdr.Crc32();
		itsCompressedSize		= aHdr.CompressedSize();
		itsUncompressedSize		= aHdr.UncompressedSize();
    }
}

// --------------------------------------------------------------------
void	CZipDataDescriptor::Write	( CZipLocalFileHeader & aHdr, IZipStream & aWriter ) {
	if	( aHdr.BitFlag().LateDetails() ) {
    	itsCrc32.Write				( aWriter );
		itsCompressedSize.Write		( aWriter );
		itsUncompressedSize.Write	( aWriter );
	}
}

// --------------------------------------------------------------------
void	CZipDataDescriptor::Free	( void ) {
	CZipDataDescriptor::Clear();
}

// --------------------------------------------------------------------
void	CZipDataDescriptor::Clear	( void ) {
	itsCrc32.Cleanup();
	itsCompressedSize.Cleanup();
	itsUncompressedSize.Cleanup();
}

// --------------------------------------------------------------------
void  				CZipDataDescriptor::Cleanup			( void ) { CZipDataDescriptor::Free(); }
const CZipCrc32 &	CZipDataDescriptor::Crc32			( void ) const { return itsCrc32; }
const CZipDword &	CZipDataDescriptor::CompressedSize	( void ) const { return itsCompressedSize; }
const CZipDword &	CZipDataDescriptor::UncompressedSize( void ) const { return itsUncompressedSize; }

void				CZipDataDescriptor::Crc32			( dword_t aV ) { itsCrc32 = aV; }
void				CZipDataDescriptor::CompressedSize	( dword_t aV ) { itsCompressedSize = aV; }
void				CZipDataDescriptor::UncompressedSize( dword_t aV ) { itsUncompressedSize = aV; }

// --------------------------------------------------------------------
dword_t	CZipDataDescriptor::ZippedSize	( void ) const {
	dword_t	zize	= 0;
	zize = zize + itsCrc32.ZippedSize();
	zize = zize + itsCompressedSize.ZippedSize();
	zize = zize + itsUncompressedSize.ZippedSize();
	return zize;
}

// --------------------------------------------------------------------
// EOF:	CZipDataDescriptor.cpp
// --------------------------------------------------------------------
