// --------------------------------------------------------------------
// CZipDataField.cpp
// Whatis:	File data
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	01-MAR-2003		Created	this source
// --------------------------------------------------------------------
#include	"CZipDataField.hxx"
#include	"CZipDeflate.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:	Constructor and destructor
// --------------------------------------------------------------------
CZipDataField::CZipDataField	() {
	CZipDataField::Clear();
}

// --------------------------------------------------------------------
CZipDataField::~CZipDataField	() {
	CZipDataField::Free();
}

// --------------------------------------------------------------------
// public:	Copy constructor and assignment operators
// --------------------------------------------------------------------
CZipDataField::CZipDataField	( const CZipDataField & aC ) {
	CZipDataField::Clear();
    itsSize = aC.Size();
	if	( itsSize > 0 ) {
	    itsData = new byte_t [itsSize + 1];
	    ::memcpy( itsData, aC.Data(), itsSize );
	    itsData[itsSize] = 0;
    }
}

// --------------------------------------------------------------------
CZipDataField & CZipDataField::operator =	( const CZipDataField & aC ) {
	CZipDataField::Free();
    itsSize = aC.Size();
	if	( itsSize > 0 ) {
	    itsData = new byte_t [itsSize + 1];
	    ::memcpy( itsData, aC.Data(), itsSize );
	    itsData[itsSize] = 0;
    }
	return *this;
}

// --------------------------------------------------------------------
// public:	Comparison operators
// --------------------------------------------------------------------
bool CZipDataField::operator == ( const char * aS ) const {
	return ::strcmp( (const char *)itsData ? (const char *)itsData : "", aS ? aS : "" ) == 0;
}

// --------------------------------------------------------------------
bool CZipDataField::operator != ( const char * aS ) const {
	return ::strcmp( (const char *)itsData ? (const char *)itsData : "", aS ? aS : "" ) != 0;
}

// --------------------------------------------------------------------
// public:	Interfaces
// --------------------------------------------------------------------
void	CZipDataField::Read	( IZipStream & aReader, dword_t aLen ) {
	CZipDataField::Free();
	if	( aLen > 0 ) {
    	itsSize = aLen;
		itsData = new byte_t [itsSize + 1];
		dword_t	rsz	= aReader.Read( itsData, itsSize );
        if	( rsz != itsSize )	throw CError( aReader.Name(), "Not enough data" );
	    itsData[itsSize] = 0;
    }
}

// --------------------------------------------------------------------
void	CZipDataField::Write	( IZipStream & aWriter ) {
	if	( itsSize )	aWriter.Write( itsData, itsSize );
}

// --------------------------------------------------------------------
void	CZipDataField::Data		( const char * aS ) {
	CZipDataField::Free();
    if	( aS != NULL ) {
    	itsSize = ::strlen( aS );
        if	( itsSize > 0 ) {
        	itsData = new byte_t [itsSize + 1];
            ::memcpy( itsData, aS, itsSize );
            itsData[itsSize] = 0;
        }
    }
}

// --------------------------------------------------------------------
void	CZipDataField::RawData	( const byte_t * aS, dword_t aL ) {
	CZipDataField::Free();
	itsData = (byte_t *)aS;
    itsSize = aL;
}

// --------------------------------------------------------------------
// public:		Deflate data into output and set data accordingly
// --------------------------------------------------------------------
void			CZipDataField::Compress	(	const CZipFlags & 	aFg,
											IZipStream &		aIn,
											IZipStream &		aOut,
                                            CZipNotification *  aNotify ) {
	CZipDeflate	mydeflate;
	CZipDataField::Free();
	mydeflate.Compress( itsCrc32, itsSize, aFg, aIn, aOut, aNotify );
}

// --------------------------------------------------------------------
// public:		Deflate data into the buffer and set data accordingly
// --------------------------------------------------------------------
void			CZipDataField::Compress	(	const CZipFlags & 	aFg,
											IZipStream &		aIn,
                                            CZipNotification *  aNotify ) {
	CZipDeflate	mydeflate;
	CZipDataField::Free();
	itsData  = mydeflate.Compress( itsCrc32, itsSize, aFg, aIn, aNotify );
}

// --------------------------------------------------------------------
dword_t			CZipDataField::Size			( void ) const	{ return itsSize; }
const byte_t *	CZipDataField::Data			( void ) const	{ return itsData; }
dword_t			CZipDataField::ZippedSize	( void ) const	{ return itsSize; }
void			CZipDataField::Cleanup		( void ) { CZipDataField::Free(); }
CZipCrc32		CZipDataField::Crc32		( void ) const	{ return itsCrc32; }

// --------------------------------------------------------------------
// private:		Private helpers
// --------------------------------------------------------------------
void	CZipDataField::Free () {
	if	( itsData != NULL )	delete [] itsData;
	CZipDataField::Clear();
}

// --------------------------------------------------------------------
void	CZipDataField::Clear () {
	itsData = NULL;
    itsSize = 0;
}

// --------------------------------------------------------------------
// EOF:	CZipDataField.cpp
// --------------------------------------------------------------------

