// --------------------------------------------------------------------
// CZipDateTime.cpp
// Whatis:	File data
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	01-MAR-2003		Created	this source
// --------------------------------------------------------------------
#include	"CZipDateTime.hxx"
#include	"CZipWord.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:	Constructor and destructor
// --------------------------------------------------------------------
CZipDateTime::CZipDateTime () {
	CZipDateTime::Clear();
}

// --------------------------------------------------------------------
CZipDateTime::CZipDateTime	( time_t aT ) {
	CZipDateTime::Clear();
    itsDateTime = aT;
}

// --------------------------------------------------------------------
CZipDateTime::~CZipDateTime () {
	CZipDateTime::Free();
}

// --------------------------------------------------------------------
// public:	Copy constructor and assignment operator
// --------------------------------------------------------------------
CZipDateTime::CZipDateTime				( const CZipDateTime & aC ) {
	CZipDateTime::Clear();
	itsDateTime = aC.DateTime();
}

// --------------------------------------------------------------------
CZipDateTime & CZipDateTime::operator =	( const CZipDateTime & aC ) {
	CZipDateTime::Free();
	itsDateTime = aC.DateTime();
	return *this;
}

// --------------------------------------------------------------------
CZipDateTime & CZipDateTime::operator =	( time_t aT ) {
	CZipDateTime::Free();
	itsDateTime = aT;
	return *this;
}

// --------------------------------------------------------------------
// public:	Interfaces
// --------------------------------------------------------------------
void	CZipDateTime::Read	( IZipStream & aReader ) {

	CZipDateTime::Free();

	CZipWord	mytime;
    CZipWord	mydate;

    mytime.Read( aReader );
    mydate.Read( aReader );

    // Convert into struct tm
    struct tm	mytm;

	// Initialize the tm struct with current time
    ::memset( &mytm, 0, sizeof( mytm ) );

	// ----------------------------------------------------------------
	//   15 14 13 12 11 10  9  8  7  6  5  4  3  2  1  0
	//  |<--- hour --->|<---- minute --->|<- second/2 ->|
	// ----------------------------------------------------------------
	mytm.tm_sec		= (int)((mytime.Value() << 1)  & 0x003E);
	mytm.tm_min		= (int)((mytime.Value() >> 5)  & 0x003F);
	mytm.tm_hour	= (int)((mytime.Value() >> 11) & 0x001F);

	// ----------------------------------------------------------------
	//   31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16
	//  |<---- year-1980 --->|<- month ->|<--- day ---->|
	// ----------------------------------------------------------------
	mytm.tm_mday	= (int)(mydate.Value()         & 0x001F) + 1;
	mytm.tm_mon		= (int)((mydate.Value() >> 5)  & 0x000F);
	mytm.tm_year	= (int)((mydate.Value() >> 9)  & 0x007F) + 80;

	// Set up the local time value
    itsDateTime = ::mktime( &mytm );
}

// --------------------------------------------------------------------
void	CZipDateTime::Write	( IZipStream & aWriter ) {
	word_t		gtime = 0;
	word_t		gdate = 0;
	struct tm	mytm;

   	// Convert the value into the structure
    ::memcpy( &mytm, ::localtime( &itsDateTime ), sizeof( mytm ) );

	// ----------------------------------------------------------------
	//   15 14 13 12 11 10  9  8  7  6  5  4  3  2  1  0
	//  |<--- hour --->|<---- minute --->|<- second/2 ->|
	// ----------------------------------------------------------------
	gtime |= (word_t)(mytm.tm_sec  >> 1);
	gtime |= (word_t)(mytm.tm_min  << 5);
	gtime |= (word_t)(mytm.tm_hour << 11);

	// ----------------------------------------------------------------
	//   31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16
	//  |<---- year-1980 --->|<- month ->|<--- day ---->|
	// ----------------------------------------------------------------
	gdate |= (word_t)(mytm.tm_mday & 0x001F);
	gdate |= (word_t)((mytm.tm_mon + 1)   << 5);
	gdate |= (word_t)((mytm.tm_year - 80) << 9);

	CZipWord	wd;
    wd = gtime;	wd.Write( aWriter );
    wd = gdate;	wd.Write( aWriter );
}

// --------------------------------------------------------------------
void	CZipDateTime::Free( void ) {
	CZipDateTime::Clear();
}

// --------------------------------------------------------------------
void	CZipDateTime::Clear( void ) {
    itsDateTime = ::time( NULL );
}

// --------------------------------------------------------------------
bool	CZipDateTime::operator ==	( const CZipDateTime & aC ) const { return itsDateTime == aC.DateTime(); }
bool	CZipDateTime::operator !=	( const CZipDateTime & aC ) const { return itsDateTime != aC.DateTime(); }
bool	CZipDateTime::operator <=	( const CZipDateTime & aC ) const { return itsDateTime <= aC.DateTime(); }
bool	CZipDateTime::operator >=	( const CZipDateTime & aC ) const { return itsDateTime >= aC.DateTime(); }
bool	CZipDateTime::operator <	( const CZipDateTime & aC ) const { return itsDateTime < aC.DateTime(); }
bool	CZipDateTime::operator >	( const CZipDateTime & aC ) const { return itsDateTime > aC.DateTime(); }
bool	CZipDateTime::operator ==	( time_t aT ) const { return itsDateTime == aT; }
bool	CZipDateTime::operator !=	( time_t aT ) const { return itsDateTime != aT; }
bool	CZipDateTime::operator <=	( time_t aT ) const { return itsDateTime <= aT; }
bool	CZipDateTime::operator >=	( time_t aT ) const { return itsDateTime >= aT; }
bool	CZipDateTime::operator <	( time_t aT ) const { return itsDateTime < aT; }
bool	CZipDateTime::operator >	( time_t aT ) const { return itsDateTime > aT; }
time_t	CZipDateTime::DateTime ( void ) const { return itsDateTime; }
void  	CZipDateTime::DateTime ( time_t aT )	{ itsDateTime = aT; }
void  	CZipDateTime::Cleanup	( void ) { CZipDateTime::Free(); }

// --------------------------------------------------------------------
dword_t	CZipDateTime::ZippedSize	( void ) const {
	return	4;
}

// --------------------------------------------------------------------
// EOF:	CZipDateTime.cpp
// --------------------------------------------------------------------
