// --------------------------------------------------------------------
// CZipDigitalSignature.cpp
// Whatis:	Digital signature in the central directory
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	01-MAR-2003		Created	this source
// --------------------------------------------------------------------
#include	"CZipDigitalSignature.hxx"

// --------------------------------------------------------------------
// public:	Constructor and destructor
// --------------------------------------------------------------------
CZipDigitalSignature::CZipDigitalSignature () {
	CZipDigitalSignature::Clear();
}

// --------------------------------------------------------------------
CZipDigitalSignature::~CZipDigitalSignature () {
	CZipDigitalSignature::Free();
}

// --------------------------------------------------------------------
// public:	Copy constructor and assignment operator
// --------------------------------------------------------------------
CZipDigitalSignature::CZipDigitalSignature				( const CZipDigitalSignature & aC ) {
	CZipDigitalSignature::Clear();
	itsSignature 	= aC.Signature();
    itsSize			= aC.Size();
    itsData			= aC.Data();
}

// --------------------------------------------------------------------
CZipDigitalSignature & CZipDigitalSignature::operator =	( const CZipDigitalSignature & aC ) {
	CZipDigitalSignature::Free();
	itsSignature 	= aC.Signature();
    itsSize			= aC.Size();
    itsData			= aC.Data();
	return *this;
}

// --------------------------------------------------------------------
// public:	Interfaces
// --------------------------------------------------------------------
void	CZipDigitalSignature::Read	( CZipHeaderSignature & aSig, IZipStream & aReader ) {
	CZipDigitalSignature::Free();
	itsSignature = aSig;
    itsSize.Read( aReader );
    itsData.Read( aReader, itsSize.Value() );
}

// --------------------------------------------------------------------
void	CZipDigitalSignature::Write	( IZipStream & aWriter ) {
	if	( itsSize.Value() > 0 ) {
		itsSignature = zip_signature_digital;	// Just in case
		itsSignature.Write( aWriter );
	    itsSize.Write( aWriter );
	    itsData.Write( aWriter );
    }
}

// --------------------------------------------------------------------
void	CZipDigitalSignature::Free	( void ) {
	CZipDigitalSignature::Clear();
}

// --------------------------------------------------------------------
void	CZipDigitalSignature::Clear	( void ) {
	itsSignature.Cleanup();
	itsSize.Cleanup();
	itsData.Cleanup();
}

// --------------------------------------------------------------------
void						CZipDigitalSignature::Cleanup	( void ) { CZipDigitalSignature::Free(); }
const CZipHeaderSignature &	CZipDigitalSignature::Signature	( void ) const { return itsSignature; }
const CZipWord &			CZipDigitalSignature::Size		( void ) const { return itsSize; }
const CZipDataField &		CZipDigitalSignature::Data		( void ) const { return itsData; }

// --------------------------------------------------------------------
dword_t	CZipDigitalSignature::ZippedSize	( void ) const {
	return	itsSize.Value() > 0
			? itsSignature.ZippedSize()
	    	+ itsSize.ZippedSize()
	    	+ itsData.ZippedSize()
            : 0;
}

// --------------------------------------------------------------------
// EOF:	CZipDigitalSignature.cpp
// --------------------------------------------------------------------
