// --------------------------------------------------------------------
// CZipDword.cpp
// Whatis:	Dword
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
#include	"CZipDword.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:	Constructor and destructor
// --------------------------------------------------------------------
CZipDword::CZipDword () {
	CZipDword::Clear();
}

// --------------------------------------------------------------------
CZipDword::CZipDword( dword_t aW ) {
	CZipDword::Clear();
    itsDword = aW;
}

// --------------------------------------------------------------------
CZipDword::~CZipDword () {
	CZipDword::Free();
}

// --------------------------------------------------------------------
// public:	Copy constructor and assignment operators
// --------------------------------------------------------------------
CZipDword::CZipDword		( const CZipDword & aC ) {
	CZipDword::Clear();
	itsDword = aC.Value();
}

// --------------------------------------------------------------------
CZipDword & 	CZipDword::operator =	( const CZipDword & aC ) {
	CZipDword::Free();
	itsDword = aC.Value();
	return *this;
}

// --------------------------------------------------------------------
CZipDword & 	CZipDword::operator =	( dword_t aW ) {
	CZipDword::Free();
	itsDword = aW;
	return *this;
}

// --------------------------------------------------------------------
// public:	Interface
// --------------------------------------------------------------------
void	CZipDword::Read	( IZipStream & aS ) {

   	CZipDword::Free();

	byte_t	buf[4];
	dword_t	siz	= aS.Read( buf, 4 );

	if	( siz < 4 ) throw CError( aS.Name(), "Not enough data" );

	itsDword   =	(dword_t)buf[3];
    itsDword <<=	8;
	itsDword  |=	(dword_t)buf[2];
    itsDword <<=	8;
	itsDword  |=	(dword_t)buf[1];
    itsDword <<=	8;
    itsDword  |=	(dword_t)buf[0];
}

// --------------------------------------------------------------------
void	CZipDword::Write	( IZipStream & aS ) {
	byte_t	buf[4];

	buf[0] = (byte_t)( itsDword & 0xff );
	buf[1] = (byte_t)( (itsDword >> 8)  & 0xff );
	buf[2] = (byte_t)( (itsDword >> 16) & 0xff );
	buf[3] = (byte_t)( (itsDword >> 24) & 0xff );

	aS.Write( buf, 4 );
}

// --------------------------------------------------------------------
void	CZipDword::Free	( void ) {
   	CZipDword::Clear();
}

// --------------------------------------------------------------------
void	CZipDword::Clear( void ) {
	itsDword = 0;
}

// --------------------------------------------------------------------
void			CZipDword::Cleanup	( void ) { CZipDword::Free(); }
dword_t			CZipDword::Value	( void ) const 	{ return itsDword; }
void			CZipDword::Value	( dword_t aV )	{ itsDword = aV; }

// --------------------------------------------------------------------
dword_t	CZipDword::ZippedSize	( void ) const {
	return	4;
}

// --------------------------------------------------------------------
// EOF:	CZipDword.cpp
// --------------------------------------------------------------------
