// --------------------------------------------------------------------
// CZipHeaderBitFlag.cpp
// Whatis:	File data
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	01-MAR-2003		Created	this source
// --------------------------------------------------------------------
#include	"CZipHeaderBitFlag.hxx"
#include	"CZipWord.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:	Constructor and destructor
// --------------------------------------------------------------------
CZipHeaderBitFlag::CZipHeaderBitFlag () {
	CZipHeaderBitFlag::Clear();
}

// --------------------------------------------------------------------
CZipHeaderBitFlag::~CZipHeaderBitFlag () {
	CZipHeaderBitFlag::Free();
}

// --------------------------------------------------------------------
// public:	Copy constructor and assignment operator
// --------------------------------------------------------------------
CZipHeaderBitFlag::CZipHeaderBitFlag				( const CZipHeaderBitFlag & aC ) {
	CZipHeaderBitFlag::Clear();
	itsEncrypted			= aC.Encrypted();
	itsImploBigDict			= aC.ImploBigDict();
	itsImploTripleTrees		= aC.ImploTripleTrees();
	itsDeflateType			= aC.DeflateType();
    itsLateDetails			= aC.LateDetails();
	itsEnchangedDeflate		= aC.EnchangedDeflate();
	itsCompressedPatchData	= aC.CompressedPatchData();
}

// --------------------------------------------------------------------
CZipHeaderBitFlag & CZipHeaderBitFlag::operator =	( const CZipHeaderBitFlag & aC ) {
	CZipHeaderBitFlag::Free();
	itsEncrypted			= aC.Encrypted();
	itsImploBigDict			= aC.ImploBigDict();
	itsImploTripleTrees		= aC.ImploTripleTrees();
	itsDeflateType			= aC.DeflateType();
    itsLateDetails			= aC.LateDetails();
	itsEnchangedDeflate		= aC.EnchangedDeflate();
	itsCompressedPatchData	= aC.CompressedPatchData();
	return *this;
}

// --------------------------------------------------------------------
// public:	Come more peculiar settings
// --------------------------------------------------------------------
void	CZipHeaderBitFlag::ImploBigDict		( bool aV ) {
	itsImploBigDict = aV;

    word_t	data	= (word_t)(  itsImploBigDict ? 1 : 0
    				           + itsImploTripleTrees ? 2 : 0 );
	itsDeflateType	= (zip_deflate_type_t)data;
}

// --------------------------------------------------------------------
void	CZipHeaderBitFlag::ImploTripleTrees	( bool aV ) {
	itsImploTripleTrees = aV;

    word_t	data	= (word_t)(  itsImploBigDict ? 1 : 0
    				           + itsImploTripleTrees ? 2 : 0 );
	itsDeflateType	= (zip_deflate_type_t)data;
}

// --------------------------------------------------------------------
void	CZipHeaderBitFlag::DeflateType		( zip_deflate_type_t aV ) {
	itsDeflateType = aV;
	itsImploBigDict			= ( (((word_t)aV) & 0x0001) != 0 );
	itsImploTripleTrees		= ( (((word_t)aV) & 0x0002) != 0 );
}

// --------------------------------------------------------------------
// public:	Interfaces
// --------------------------------------------------------------------
void	CZipHeaderBitFlag::Read	( IZipStream & aReader ) {
	CZipHeaderBitFlag::Free();
	CZipWord	data;
    data.Read( aReader );
	itsEncrypted			= ( (data.Value() & 0x0001) != 0 );
	itsImploBigDict			= ( (data.Value() & 0x0002) != 0 );
	itsImploTripleTrees		= ( (data.Value() & 0x0004) != 0 );
	itsDeflateType			= (zip_deflate_type_t)((data.Value() >> 1) & 0x0003);
    itsLateDetails			= ( (data.Value() & 0x0008) != 0 );
	itsEnchangedDeflate		= ( (data.Value() & 0x0010) != 0 );
	itsCompressedPatchData	= ( (data.Value() & 0x0020) != 0 );
}

// --------------------------------------------------------------------
void	CZipHeaderBitFlag::Write( IZipStream & aWriter ) {
	word_t		data	= 0;
	if	( itsEncrypted )			data |= 0x0001;
	if	( itsImploBigDict )			data |= 0x0002;
	if	( itsImploTripleTrees )		data |= 0x0004;
    if	( itsLateDetails )			data |= 0x0008;
	if	( itsEnchangedDeflate )		data |= 0x0010;
	if	( itsCompressedPatchData )	data |= 0x0020;

    CZipWord	wd(data);
    wd.Write( aWriter );
}

// --------------------------------------------------------------------
void	CZipHeaderBitFlag::Free( void ) {
	CZipHeaderBitFlag::Clear();
}

// --------------------------------------------------------------------
void	CZipHeaderBitFlag::Clear( void ) {
	itsEncrypted			= false;
	itsImploBigDict			= false;
	itsImploTripleTrees		= false;
	itsDeflateType			= zip_deflate_type_normal;
    itsLateDetails			= false;
	itsEnchangedDeflate		= false;
	itsCompressedPatchData	= false;
}

// --------------------------------------------------------------------
void				CZipHeaderBitFlag::Cleanup				( void ) { CZipHeaderBitFlag::Free(); }
bool				CZipHeaderBitFlag::Encrypted			( void ) const { return itsEncrypted;}
bool				CZipHeaderBitFlag::ImploBigDict			( void ) const { return itsImploBigDict;}
bool				CZipHeaderBitFlag::ImploTripleTrees		( void ) const { return itsImploTripleTrees;;}
zip_deflate_type_t	CZipHeaderBitFlag::DeflateType			( void ) const { return itsDeflateType;}
bool				CZipHeaderBitFlag::LateDetails			( void ) const { return itsLateDetails;}
bool				CZipHeaderBitFlag::EnchangedDeflate		( void ) const { return itsEnchangedDeflate;}
bool				CZipHeaderBitFlag::CompressedPatchData	( void ) const { return itsCompressedPatchData;}
void				CZipHeaderBitFlag::Encrypted			( bool aV ) { itsEncrypted = aV;}
void				CZipHeaderBitFlag::LateDetails			( bool aV )	{ itsLateDetails = aV; }
void				CZipHeaderBitFlag::EnchangedDeflate		( bool aV )	{ itsEnchangedDeflate = aV; }
void				CZipHeaderBitFlag::CompressedPatchData	( bool aV )	{ itsCompressedPatchData = aV; }

// --------------------------------------------------------------------
dword_t	CZipHeaderBitFlag::ZippedSize	( void ) const {
	return	2;
}
// --------------------------------------------------------------------
// EOF:	CZipHeaderBitFlag.cpp
// --------------------------------------------------------------------
