// --------------------------------------------------------------------
// CZipVersion.cpp
// Whatis:	Zip version
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	01-MAR-2003		Created	this source
// --------------------------------------------------------------------
#include	"CZipVersion.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:	Constructor and destructor
// --------------------------------------------------------------------
CZipVersion::CZipVersion () {
	CZipVersion::Clear();
}

// --------------------------------------------------------------------
CZipVersion::~CZipVersion () {
	CZipVersion::Free();
}

// --------------------------------------------------------------------
// public:	Copy constructor and assignment operator
// --------------------------------------------------------------------
CZipVersion::CZipVersion	( const CZipVersion & aC ) {
	CZipVersion::Clear();
	itsCompatibility= aC.Compatibility();
	itsMajorVersion = aC.MajorVersion();
	itsMinorVersion = aC.MinorVersion();
}

// --------------------------------------------------------------------
CZipVersion & CZipVersion::operator = ( const CZipVersion &  aC ) {
	CZipVersion::Free();
	itsCompatibility= aC.Compatibility();
	itsMajorVersion = aC.MajorVersion();
	itsMinorVersion = aC.MinorVersion();
    return *this;
}

// --------------------------------------------------------------------
// public:	Comparing versions
// --------------------------------------------------------------------
bool CZipVersion::operator == ( const CZipVersion & aC ) const {
     return CZipVersion::Version() == aC.Version();
}

// --------------------------------------------------------------------
bool CZipVersion::operator != ( const CZipVersion & aC ) const {
     return CZipVersion::Version() != aC.Version();
}

// --------------------------------------------------------------------
bool CZipVersion::operator <= ( const CZipVersion & aC ) const {
     return CZipVersion::Version() <= aC.Version();
}

// --------------------------------------------------------------------
bool CZipVersion::operator >= ( const CZipVersion & aC ) const {
     return CZipVersion::Version() >= aC.Version();
}

// --------------------------------------------------------------------
bool CZipVersion::operator <  ( const CZipVersion & aC ) const {
     return CZipVersion::Version() < aC.Version();
}

// --------------------------------------------------------------------
bool CZipVersion::operator >  ( const CZipVersion & aC ) const {
     return CZipVersion::Version() > aC.Version();
}

// --------------------------------------------------------------------
// public:	Interfaces
// --------------------------------------------------------------------
void	CZipVersion::Read	( IZipStream & aReader ) {

	CZipVersion::Free();

	// Read in the version data
	byte_t	data[2];
    dword_t	rsiz = aReader.Read( data, 2 );
    if	( rsiz != 2 )	throw CError( aReader.Name(), "Not enough data" );

	// ----------------------------------------------------------------
    // Decode the first byte
	//	0 - MS-DOS and OS/2 (FAT / VFAT / FAT32 file systems)
	//	1 - Amiga                     2 - OpenVMS
	//	3 - Unix                      4 - VM/CMS
	//	5 - Atari ST                  6 - OS/2 H.P.F.S.
	//	7 - Macintosh                 8 - Z-System
	//	9 - CP/M                     10 - Windows NTFS
	//	11 thru 255 - unused
	// ----------------------------------------------------------------
    switch	( data[1] ) {
		case	0:	itsCompatibility = zip_data_compat_msdos;	break;
		case	1:	itsCompatibility = zip_data_compat_amiga;	break;
		case	2:	itsCompatibility = zip_data_compat_vms;		break;
		case	3:	itsCompatibility = zip_data_compat_unix;	break;
		case	4:	itsCompatibility = zip_data_compat_vmcms;	break;
		case	5:	itsCompatibility = zip_data_compat_atarist;	break;
		case	6:	itsCompatibility = zip_data_compat_os2hpfs;	break;
		case	7:	itsCompatibility = zip_data_compat_mac;		break;
		case	8:	itsCompatibility = zip_data_compat_zsystem;	break;
		case	9:	itsCompatibility = zip_data_compat_cpm;		break;
		case	10:	itsCompatibility = zip_data_compat_winntfs;	break;
		default:	throw CError( aReader.Name(), "Invalid combat byte" );
    }
	itsMinorVersion = (byte_t)(data[0] % 10);
	itsMajorVersion = (byte_t)(data[0] / 10);
}

// --------------------------------------------------------------------
void	CZipVersion::Write	( IZipStream & aWriter ) {
	byte_t	data[2];
    data[0] = (byte_t)CZipVersion::Version();
    data[1] = (byte_t)itsCompatibility;
    aWriter.Write( data, 2 );
}

// --------------------------------------------------------------------
void	CZipVersion::Free	( void ) {
	CZipVersion::Clear();
}

// --------------------------------------------------------------------
void	CZipVersion::Clear	( void ) {
	itsCompatibility= zip_data_compat_msdos;
	itsMajorVersion = 2;
	itsMinorVersion = 0;
}

void	CZipVersion::SetVersion (	byte_t				aMajor,
									byte_t				aMinor,
                                    zip_data_compat_t 	aCompat ) {
	itsCompatibility= aCompat;
	itsMajorVersion = aMajor;
	itsMinorVersion = aMinor;
}

// --------------------------------------------------------------------
void				CZipVersion::Cleanup		( void ) { CZipVersion::Free(); }
zip_data_compat_t	CZipVersion::Compatibility	( void ) const { return itsCompatibility; }
byte_t				CZipVersion::MajorVersion	( void ) const { return itsMajorVersion; }
byte_t				CZipVersion::MinorVersion	( void ) const { return itsMinorVersion; }
word_t				CZipVersion::Version		( void ) const { return (word_t)(10 * itsMajorVersion + itsMinorVersion); }

// --------------------------------------------------------------------
dword_t	CZipVersion::ZippedSize	( void ) const {
	return	2;
}

// --------------------------------------------------------------------
// EOF:	CZipVersion.cpp
// --------------------------------------------------------------------
