// --------------------------------------------------------------------
// CZipWord.cpp
// Whatis:	Word
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	24-FEB-2003		Created	this source
// --------------------------------------------------------------------
#include	"CZipWord.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:	Constructor and destructor
// --------------------------------------------------------------------
CZipWord::CZipWord () {
	CZipWord::Clear();
}

// --------------------------------------------------------------------
CZipWord::CZipWord	( word_t aW ) {
	CZipWord::Clear();
    itsWord = aW;
}

// --------------------------------------------------------------------
CZipWord::~CZipWord () {
	CZipWord::Free();
}

// --------------------------------------------------------------------
// public:	Copy constructor and assignment operators
// --------------------------------------------------------------------
CZipWord::CZipWord		( const CZipWord & aC ) {
	CZipWord::Clear();
	itsWord = aC.Value();
}

// --------------------------------------------------------------------
CZipWord & 	CZipWord::operator =	( const CZipWord & aC ) {
	CZipWord::Free();
	itsWord = aC.Value();
	return *this;
}

// --------------------------------------------------------------------
CZipWord & 	CZipWord::operator =	( word_t aW ) {
	CZipWord::Free();
	itsWord = aW;
	return *this;
}

// --------------------------------------------------------------------
// public:	Interface
// --------------------------------------------------------------------
void	CZipWord::Read	( IZipStream & aS ) {
	CZipWord::Free();

	byte_t	buf[2];
	dword_t	siz	= aS.Read( buf, 2 );

	if	( siz < 2 ) throw CError( aS.Name(), "Not enough data" );

	itsWord   =	(word_t)buf[1];
    itsWord <<=	8;
    itsWord  |=	(word_t)buf[0];
}

// --------------------------------------------------------------------
void	CZipWord::Write	( IZipStream & aS ) {
	byte_t	buf[2];

	buf[0] = (byte_t)( itsWord & 0xff );
	buf[1] = (byte_t)( (itsWord >> 8) & 0xff );

	aS.Write( buf, 2 );
}

// --------------------------------------------------------------------
void	CZipWord::Free	( void ) {
	CZipWord::Clear();
}

// --------------------------------------------------------------------
void	CZipWord::Clear	( void ) {
	itsWord = 0;
}

// --------------------------------------------------------------------
void	CZipWord::Cleanup	( void ) { CZipWord::Free(); }
word_t	CZipWord::Value		( void ) const 	{ return itsWord; }
void	CZipWord::Value		( word_t aV )	{ itsWord = aV; }

// --------------------------------------------------------------------
dword_t	CZipWord::ZippedSize	( void ) const {
	return	2;
}

// --------------------------------------------------------------------
// EOF:	CZipWord.cpp
// --------------------------------------------------------------------
