// --------------------------------------------------------------------
// IZipStream.cpp
// Whatis:	The non-virtual methods of this base class
// Authors:	Esko 'Varpu' Ilola	EIL
// History:	EIL	10-MAR-2003		Created	this source
// --------------------------------------------------------------------
#include	"IZipStream.hxx"
#include	"CError.hxx"

// --------------------------------------------------------------------
// public:	Constructor and destructor
// --------------------------------------------------------------------
IZipStream::IZipStream	()	{}
IZipStream::~IZipStream	()	{}

// --------------------------------------------------------------------
// public:	Utility methods
// --------------------------------------------------------------------
void	IZipStream::Copy ( IZipStream & aReader, dword_t aSize ) {
	dword_t	len = 0;
	dword_t	rzt;
	char	buf	[8192];
	while	( len < aSize ) {
		if	( aSize - len > sizeof(buf) ) {
			rzt = aReader.Read( buf, sizeof(buf) );
			if	( rzt != sizeof(buf) )	throw CError( aReader.Name(), "Not enough data" );
			this->Write( buf, sizeof(buf) );
			len += sizeof(buf);
		}
		else {
			rzt = aReader.Read( buf, aSize - len );
			if	( rzt != aSize - len )	throw CError( aReader.Name(), "Not enough data" );
            this->Write( buf, aSize - len );
			len = aSize;
		}
	}
}

// --------------------------------------------------------------------
// EOF:	IZipStream.cpp
// --------------------------------------------------------------------
