// --------------------------------------------------------------------
// AuthorAdmin.cxx
// Whatis:  CGI for administering teh authors
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 15-SEP-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CSession.hxx"
#include	"CCgiArgs.hxx"
#include	"CCache.hxx"
#include	"CStorage.hxx"
#include	"CAuthor.hxx"
#include	"CIdentifyFile.hxx"
#include    "CPreviewTemplate.hxx"
#include	"CMySqlWhere.hxx"
#include	"CTablePref.hxx"
#include	"CTableFile.hxx"
#include	"CTableAuth.hxx"
#include	"CTableArep.hxx"
#include	"CFileScore.hxx"

// --------------------------------------------------------------------
// local:	Save argument name list
// --------------------------------------------------------------------
static	const char *	saveargs[] = {
	"findname", "task", "forw",
	"arep_fnam", "arep_nnam", "arep_lnam", "page",
	"auid0", "auid1", "auid2", "auid3", "auid4",
	"auid5", "auid6", "auid7", "auid8", "auid9",
	"auid10", "auid11", "auid12", "auid13", "auid14",
	"auid15", "auid16", "auid17", "auid18", "auid19",
	NULL
};

// --------------------------------------------------------------------
// local:	The CGI arguments
// --------------------------------------------------------------------
static	CMySqlConnect		db( "quest", "", "UTCMS" );
static	CCgiArgs			cgi;
static	dword_t				taskid	= 0;
static	dword_t				userid	= 0;
static	dword_t				sessid	= 0;
static	dword_t				pagenow	= 0;
static	dword_t				lastpage= 0;
static	dword_t				selectnu= 0;
static	dword_t				rownumber	= 0;
static	CPreviewTemplate	previewtemplate;

// --------------------------------------------------------------------
// local:	Some database tables needed
// --------------------------------------------------------------------
static	CTablePref		pref;
static	CTableFile		file;
static	CTableAuth		auth;
static	CTableArep		arep;

// --------------------------------------------------------------------
// local:	Data associated with those tables
// --------------------------------------------------------------------
static	data_user_t		logndata		= { 0 };
static	data_file_t		filedata		= { 0 };
static	data_auth_t		authdata		= { 0 };
static	data_arep_t		arepdata		= { { 0 } };

static	char 			fn_now	[1024]	= { 0 };
static	char 			nn_now	[1024]	= { 0 };
static	char 			ln_now	[1024]	= { 0 };

// --------------------------------------------------------------------
// local:	Output first part for true, last part for false
//			The parts are separated by '\' character
// --------------------------------------------------------------------
static	void	__outpart	( 	const char *	aS,
								bool			aFirst ) {
	char *	cs	= ::my_private_strdup( aS );
	char *	s	= ::strchr( cs, '|' );

	if	( s ) {
		*s = 0;
		s++;
	}
	else {
		s = "";
	}

	::printf( "%s", aFirst ? cs : s );

	delete [] cs;
}

// --------------------------------------------------------------------
// local:	Output something depending on state of a flag
// --------------------------------------------------------------------
static	void	__onflag	( 	dword_t				aU,
								const char * 		aS ) {

	if		( ! ::strncmp( aS, "DENY_READ?", 	10 ) )	__outpart( aS + 10, (aU & FLAG_DENY_READ) != 0 );
	else if	( ! ::strncmp( aS, "DENY_WRITE?",	11 ) )	__outpart( aS + 11, (aU & FLAG_DENY_WRITE) != 0 );
	else if	( ! ::strncmp( aS, "DENY_VIEW?",	10 ) )	__outpart( aS + 10, (aU & FLAG_DENY_VIEW) != 0 );
	else if	( ! ::strncmp( aS, "DENY_MOD?",		9 ) )	__outpart( aS + 9,  (aU & FLAG_DENY_MOD) != 0 );
	else if	( ! ::strncmp( aS, "DENY_REN?",		9 ) )	__outpart( aS + 9,  (aU & FLAG_DENY_REN) != 0 );
	else if	( ! ::strncmp( aS, "DENY_DEL?",		9 ) )	__outpart( aS + 9,  (aU & FLAG_DENY_DEL) != 0 );
	else if	( ! ::strncmp( aS, "FIX_FLAG?",		9 ) )	__outpart( aS + 9,  (aU & FLAG_FIX_FLAG) != 0 );
	else if	( ! ::strncmp( aS, "ACCEPTED?",		9 ) )	__outpart( aS + 9,  (aU & FLAG_ACCEPTED) != 0 );
	else if	( ! ::strncmp( aS, "BANNED?",		7 ) )	__outpart( aS + 7,  (aU & FLAG_BANNED) != 0 );
	else if	( ! ::strncmp( aS, "NOSUGGEST?",	10 ) )	__outpart( aS + 10, (aU & FLAG_NOSUGGEST) != 0 );
	else if	( ! ::strncmp( aS, "NODOWNLOAD?",	11 ) )	__outpart( aS + 11, (aU & FLAG_NODOWNLOAD) != 0 );
	else if	( ! ::strncmp( aS, "SUPERUSER?",	10 ) )	__outpart( aS + 10, (aU & FLAG_SUPERUSER) != 0 );
	else if	( ! ::strncmp( aS, "NEWSADMIN?",	10 ) )	__outpart( aS + 10, (aU & FLAG_NEWSADMIN) != 0 );
	else if	( ! ::strncmp( aS, "REVIADMIN?",	10 ) )	__outpart( aS + 10, (aU & FLAG_REVIADMIN) != 0 );
	else if	( ! ::strncmp( aS, "COMMADMIN?",	10 ) )	__outpart( aS + 10, (aU & FLAG_COMMADMIN) != 0 );
}

// --------------------------------------------------------------------
// local:	See if the line is checked
// --------------------------------------------------------------------
static	void	__checkchecked	( void ) {
	char	argname	[128];
	::sprintf( argname, "auid%d", selectnu );

	if	( cgi.Exist( argname ) ) {
		::printf( "checked" );
	}
}

// --------------------------------------------------------------------
// local:	Parser questions are sent here for answering
// --------------------------------------------------------------------
static	void	__answer	( const char * aQ ) {

	// ----------------------------------------------------------------
	// Local parsing
	// ----------------------------------------------------------------
	if		( ! ::strcmp( aQ, "sessid" ) )			::printf( "%d", sessid );
	else if	( ! ::strcmp( aQ, "userid" ) )			::printf( "%d", userid );
	else if	( ! ::strcmp( aQ, "selectnum" ) )		::printf( "%d", selectnu );
	else if	( ! ::strcmp( aQ, "checkit" ) )			__checkchecked();
	else if	( ! ::strcmp( aQ, "pagenow" ) )			::printf( "%d", pagenow );
	else if	( ! ::strcmp( aQ, "nextpage" ) )		::printf( "%d", pagenow + 1 );
	else if	( ! ::strcmp( aQ, "prevpage" ) )		::printf( "%d", pagenow - 1 );
	else if	( ! ::strcmp( aQ, "lastpage" ) )		::printf( "%d", lastpage );
	else if	( ! ::strcmp( aQ, "linepair" ) )		::printf( "%d", rownumber & 0x01 );

	else if	( ! ::strcmp( aQ, "fn_now" ) )			::HTML_quote( fn_now );
	else if	( ! ::strcmp( aQ, "nn_now" ) )			::HTML_quote( nn_now );
	else if	( ! ::strcmp( aQ, "ln_now" ) )			::HTML_quote( ln_now );


	else if	( ! ::strcmp( aQ, "super_b" ) )			::printf( "%s", (logndata.user_flag & FLAG_SUPERUSER) != 0 ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "super_e" ) )			::printf( "%s", (logndata.user_flag & FLAG_SUPERUSER) != 0 ? "" : " -->" );

	// ----------------------------------------------------------------
	// The onflag directive
	// ----------------------------------------------------------------
	else if	( ! ::strncmp( aQ, "onlogflag-", 10 ) )	__onflag( logndata.user_flag, aQ + 10 );
	else if	( ! ::strncmp( aQ, "onautflag-", 10 ) )	__onflag( authdata.auth_flag, aQ + 10 );

	// ----------------------------------------------------------------
	// Paging
	// ----------------------------------------------------------------
	else if	( ! ::strcmp( aQ, "pagenext_b" ) )		::printf( "%s", pagenow < lastpage ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pagenext_e" ) )		::printf( "%s", pagenow < lastpage ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "pagenext_bx" ) )		::printf( "%s", pagenow >= lastpage ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pagenext_ex" ) )		::printf( "%s", pagenow >= lastpage ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "pageprev_b" ) )		::printf( "%s", pagenow > 1 ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pageprev_e" ) )		::printf( "%s", pagenow > 1 ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "pageprev_bx" ) )		::printf( "%s", pagenow <= 1 ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pageprev_ex" ) )		::printf( "%s", pagenow <= 1 ? "" : " -->" );

	// ----------------------------------------------------------------
	// Parsing table data
	// ----------------------------------------------------------------
	else if	( ::MySqlTableParser( auth.Layout(), "auth", (const char *)(&authdata), aQ ) )	;
	else if	( ::MySqlTableParser( file.Layout(), "file", (const char *)(&filedata), aQ ) )	;
	else if	( ::MySqlTableParser( arep.Layout(), "arep", (const char *)(&arepdata), aQ ) )	;

	// ----------------------------------------------------------------
	// Parsing the CGI data
	// ----------------------------------------------------------------
	else if	( ::cgi_parser( cgi, aQ ) )	;

	// ----------------------------------------------------------------
	// Everything else goes to default parser
	// ----------------------------------------------------------------
	else	::my_default_answer( aQ );
}

// --------------------------------------------------------------------
// local:	Set a flag
// --------------------------------------------------------------------
static	void	__set_flag ( dword_t & aFlag, dword_t aMask, bool aVal ) {

	if	( aVal ) {
		aFlag = aFlag | aMask;

	}
	else {
		aFlag = aFlag & (aMask ^ 0xffffffff);
	}
}

// --------------------------------------------------------------------
// local:	Set up author name from components
// --------------------------------------------------------------------
static	void		__buildname		( 	char *			aBuf,
										const char *	aFn,
										const char *	aNn,
										const char *	aLn ) {
	char	myfn	[512];
	char	mynn	[512];
	char	myln	[512];

	::strcpy( myfn, aFn );	::my_strfix( myfn );
	::strcpy( mynn, aNn );	::my_strfix( mynn );
	::strcpy( myln, aLn );	::my_strfix( myln );

	::strcpy( aBuf, myfn );

	if	( *mynn ) {
		if	( *aBuf )	::strcat( aBuf, " " );
		::strcat( aBuf, "'" );
		::strcat( aBuf, mynn );
		::strcat( aBuf, "'" );
	}

	if	( *myln ) {
		if	( *aBuf )	::strcat( aBuf, " " );
		::strcat( aBuf, myln );		
	}
}

// --------------------------------------------------------------------
// local:	Fix entries in the replacement table
// --------------------------------------------------------------------
static	data_arep_t	__fixreplaces	( 	const char *	aFind,
										const char *	aFn,
										const char *	aNn,
										const char *	aLn ) {
	data_arep_t		data;
	data_arep_tl	list;
	CMySqlWhere		w;
	CMySqlQuote		q;
	char			mykey[1024];

	// Check if we already have this entry stored ?
	w << "arep_find='" << q.Quote( aFind ) << "'";
	list = arep.Select( db, w );

	// Yeah, we have one - Check if the data matches
	if	(  list.size() > 0 ) {
		data = *(list.begin());

		// We return if the record matches
		if		( ::strcmp( data.arep_fnam, aFn ) )	;
		else if	( ::strcmp( data.arep_nnam, aNn ) )	;
		else if	( ::strcmp( data.arep_lnam, aLn ) )	;
		else										return	data;

		// There is something different, remove the record to
		// be able to reinsert it
		arep.Delete( db, &data );
	}

	// Are there entries searched by the replace thing ?
	__buildname( mykey, aFn, aNn, aLn );
	w = "";
	w << "arep_find='" << q.Quote( mykey ) << "'";
	list = arep.Select( db, w );

	// We found one - we shall use the replace from there instead
	::memset( &data, 0, sizeof( data ) );
	if	( list.size() > 0 ) {
		data = *(list.begin());
	}
	else {
		::my_strfit( data.arep_fnam, sizeof( data.arep_fnam ), aFn );
		::my_strfit( data.arep_nnam, sizeof( data.arep_nnam ), aNn );
		::my_strfit( data.arep_lnam, sizeof( data.arep_lnam ), aLn );
	}

	::my_strfit( data.arep_find, sizeof( data.arep_find ), aFind );
	arep.Insert( db, &data );

	return	data;
}

// --------------------------------------------------------------------
// local:	Author list
// --------------------------------------------------------------------
static	void	__authorlist	( void ) {

	// ----------------------------------------------------------------
	// More information from the cgi
	// ----------------------------------------------------------------
	pagenow	= ::atol( cgi.Arg( "page" ) );
	if	( pagenow < 1 )	pagenow = 1;

	CMySqlWhere		w;
	CMySqlQuote		q;
	data_auth_tl	list;
	data_auth_tli	loop;

	w << "auth_name like '%" << q.Quote( cgi.Arg( "findname" ) ) << "%'";

	lastpage = auth.Count( db, w ) / 20 + 1;
	if	( pagenow > lastpage )	pagenow = lastpage;

	w << " order by auth_name LIMIT "
	  << (dword_t)((pagenow-1) * 20)
	  << ",20";

	list = auth.Select( db, w );

	previewtemplate.Execute( __answer, "tmpl-authadmin-list-head" );

	CAuthor	myauthor;

	rownumber = 0;
	for	( loop = list.begin(); loop != list.end(); loop++ ) {
		authdata = *loop;

		myauthor.SetNames( authdata.auth_name );

		*fn_now = 0;
		*nn_now = 0;
		*ln_now = 0;

		if	( myauthor.FirstName() )	::strcpy( fn_now, myauthor.FirstName() );
		if	( myauthor.NickName() )		::strcpy( nn_now, myauthor.NickName() );
		if	( myauthor.LastName() )		::strcpy( ln_now, myauthor.LastName() );


		previewtemplate.Execute( __answer, "tmpl-authadmin-list-body" );
		selectnu++;
		rownumber++;
	}
	previewtemplate.Execute( __answer, "tmpl-authadmin-list-tail" );
}

// --------------------------------------------------------------------
// local:	Rename the selected authors
//			The operation will make insertion to the author name
//			replacement table as well
// --------------------------------------------------------------------
static	void	__renauthors ( void ) {
	// Now, check if this is the superuser or the ordinary user
	if	( (logndata.user_flag & FLAG_SUPERUSER) == 0 ) {
		return;
	}

	// Loop through arguments with name auidxx
	char	argname	[128];
	char	repname	[1024];
	CMySqlWhere		w;
	CMySqlQuote		q;
	data_auth_tl	alist;
	data_auth_t		adata;
	data_arep_t		repda;
	data_file_tl	flist;
	data_file_tli	floop;
	data_file_t		fdata;
	const char *	fn	= cgi.Arg( "arep_fnam" );
	const char *	nn	= cgi.Arg( "arep_nnam" );
	const char *	ln	= cgi.Arg( "arep_lnam" );

	for	( int i = 0; i < 20; i++ ) {
		::sprintf( argname, "auid%d", i );
		if	( cgi.Exist( argname ) ) {
			w = "";
			w << "auth_idnt=" << (dword_t)::atol( cgi.Arg( argname ) );
			alist = auth.Select( db, w );

			if	( alist.size() > 0 ) {
				adata = *(alist.begin());

				// Keep the replace table updated
				repda = __fixreplaces( adata.auth_name, fn, nn, ln );

				// Set up the replace name
				__buildname( 	repname,
								repda.arep_fnam,
								repda.arep_nnam,
								repda.arep_lnam );

				// If we already have entry with the new name, we just delete the selected ones
				// giving the files the existing author ID
				w = "";
				w << "auth_name='" << q.Quote( repname ) << "'";
				alist = auth.Select( db, w );
				if	( alist.size() > 0 ) {
					dword_t	exid = (*(alist.begin())).auth_idnt;

					if	( exid != adata.auth_idnt ) {
						w = "";
						w << "file_auth=" << adata.auth_idnt;
						flist = file.Select( db, w );
						for	( floop = flist.begin(); floop != flist.end(); floop++ ) {
							fdata = *floop;
							fdata.file_auth = exid;
							file.Update( db, &fdata );
						}
	
						auth.Delete( db, &adata );

						CFileScore	myscore( 0 );
						myscore.AuthorScore( exid );
						myscore.Update();
					}
				}
				else {
					::my_strfit( adata.auth_name, sizeof( adata.auth_name ), repname );
					auth.Update( db, &adata );
					CFileScore	myscore( 0 );
					myscore.AuthorScore( adata.auth_idnt );
					myscore.Update();
				}
			}
			cgi.Arg( argname, "" );	// Remove to not confuse the listing
		}
	}
	return;
}

// --------------------------------------------------------------------
// local:	Create a new author
// --------------------------------------------------------------------
static	void	__newauthor	( void ) {
	// Now, check if this is the superuser or the ordinary user
	if	( (logndata.user_flag & FLAG_SUPERUSER) == 0 ) {
		return;
	}

	// Loop through arguments with name auidxx
	CMySqlWhere		w;
	CMySqlQuote		q;
	data_auth_t		adata;
	const char *	fn	= cgi.Arg( "arep_fnam" );
	const char *	nn	= cgi.Arg( "arep_nnam" );
	const char *	ln	= cgi.Arg( "arep_lnam" );

	::memset( &adata, 0, sizeof( adata ) );
	__buildname( adata.auth_name, fn, nn, ln );

	w << "auth_name='" << q.Quote( adata.auth_name ) << "'";
	if	( auth.Count( db, w ) > 0 ) {
		return;
	}

	adata.auth_user = logndata.user_idnt;
	adata.auth_flag = 0;
	adata.auth_idnt = auth.NextIdnt( db );
	
	auth.Insert( db, &adata );

	CFileScore	myscore( 0 );
	myscore.AuthorScore( adata.auth_idnt );
	myscore.Update();

}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );
	try	{
		CSession	session(	cgi, 
								"tmpl-authadmin-logn",
								cgi.Arg("forw"),
								"./regsaves",
								saveargs );

		if	( session.Check() ) {

			::HTTP_text( "en" );

			// --------------------------------------------------------
			// First we make a copy of the logged in user record
			// --------------------------------------------------------
			logndata = session.UserData();

			// --------------------------------------------------------
			// Also, collect other useful information of the session
			// --------------------------------------------------------
			userid	= session.User();
			sessid	= session.SessId();
			taskid	= ::atol( cgi.Arg( "task" ) );

			switch	( taskid ) {

				case	3:	// Rename the checked authors
				__renauthors();
				__authorlist();
				break;

				case	4:	// Create a new author
				__newauthor();
				__authorlist();
				break;

				default:	// Give the visitor a list of authors - no redirection
				__authorlist();
				break;
			}
		}
    }

	catch	( CError e ) {
		::HTTP_text( "en" );
		::printf( "ERROR: %s", e.Error() );
	}

    catch   ( ... ) {
		::HTTP_text( "en" );
		::printf( "Failed to execute administering program" );
    }

    return	0;
}

// --------------------------------------------------------------------
// EOF: Storage.cxx
// --------------------------------------------------------------------
