// --------------------------------------------------------------------
// ColorAdmin.cxx
// Whatis:  CGI for administering teh authors
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 15-SEP-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CSession.hxx"
#include	"CCgiArgs.hxx"
#include    "CPreviewTemplate.hxx"
#include	"CMySqlWhere.hxx"
#include	"CTablePref.hxx"

// --------------------------------------------------------------------
// local:	Save argument name list
// --------------------------------------------------------------------
static	const char *	saveargs[] = {
	"task", "usersize", "preset", "usepreset",
	"r0", "g0", "b0",
	"r1", "g1", "b1",
	"r2", "g2", "b2",
	"r3", "g3", "b3",
	"r4", "g4", "b4",
	"r5", "g5", "b5",
	"r6", "g6", "b6",
	"r7", "g7", "b7",
	"r8", "g8", "b8",
	"r9", "g9", "b9",
	"r10", "g10", "b10",
	"r11", "g11", "b11",
	"r12", "g12", "b12",
	"r13", "g13", "b13",
	"r14", "g14", "b14",
	"r15", "g15", "b15",
	"r16", "g16", "b16",
	"r17", "g17", "b17",
	"r18", "g18", "b18",
	"r19", "g19", "b19",
	"r20", "g20", "b20",
	"r21", "g21", "b21",
	NULL
};

// --------------------------------------------------------------------
// local:	The CGI arguments
// --------------------------------------------------------------------
static	CMySqlConnect		db( "quest", "", "UTCMS" );
static	CCgiArgs			cgi;
static	dword_t				userid	= 0;
static	dword_t				sessid	= 0;
static	dword_t				taskid	= 0;
static	CPreviewTemplate	previewtemplate;

// --------------------------------------------------------------------
// local:	Some database tables needed
// --------------------------------------------------------------------
static	CTablePref		pref;
static	CTableUser		user;

// --------------------------------------------------------------------
// local:	Data associated with those tables
// --------------------------------------------------------------------
static	data_user_t		userdata							= { 0 };
static	char			usercolo[COLOR_SCHEME_COLORS][8]	= { { 0 } };
static	dword_t			usercolo_r[COLOR_SCHEME_COLORS]		= { 0 };
static	dword_t			usercolo_g[COLOR_SCHEME_COLORS]		= { 0 };
static	dword_t			usercolo_b[COLOR_SCHEME_COLORS]		= { 0 };
static	dword_t			usersize							= 0;
static	const char *	hexstr[16] = {
	"0", "1", "2", "3", "4", "5", "6", "7",
	"8", "9", "A", "B", "C", "D", "E", "F"
};
                                  
// --------------------------------------------------------------------
// local:	Output the preset list
// --------------------------------------------------------------------
static	void	__preset_list	( void ) {
	data_user_tl	list;
	data_user_tli	loop;
	CMySqlQuote		q;

	list = user.Select( db, " where user_logn like '#%' and user_name='Preset user entry' order by user_logn" );
	for	( loop = list.begin(); loop != list.end(); loop++ ) {
		::printf( "<option value=\"%s\">", (*loop).user_colo );
		::HTML_quote( (*loop).user_logn + 1 );
		::printf( "</option>\n" );
	}
}

// --------------------------------------------------------------------
// local:	Parser questions are sent here for answering
// --------------------------------------------------------------------
static	void	__answer	( const char * aQ ) {
                                  
	// ----------------------------------------------------------------
	// Local parsing              
	// ----------------------------------------------------------------
	if		( ! ::strcmp( aQ, "sessid" ) )			::printf( "%d", sessid );
	else if	( ! ::strcmp( aQ, "userid" ) )			::printf( "%d", userid );
	else if	( ! ::strcmp( aQ, "taskid" ) )			::printf( "%d", taskid );
	else if	( ! ::strcmp( aQ, "usersize" ) )		::printf( "%d", usersize );
	else if	( ! ::strcmp( aQ, "presetlist" ) )		__preset_list();
	else if	( ! ::strcmp( aQ, "super_b" ) )			::printf( "%s", (userdata.user_flag & FLAG_SUPERUSER) != 0 ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "super_e" ) )			::printf( "%s", (userdata.user_flag & FLAG_SUPERUSER) != 0 ? "" : " -->" );
                          
	// ----------------------------------------------------------------
	// Color output               
	// ----------------------------------------------------------------
	else if	( ! ::strcmp( aQ, "color00" ) )			::printf( usercolo[0] );
	else if	( ! ::strcmp( aQ, "color01" ) )			::printf( usercolo[1] );
	else if	( ! ::strcmp( aQ, "color02" ) )			::printf( usercolo[2] );
	else if	( ! ::strcmp( aQ, "color03" ) )			::printf( usercolo[3] );
	else if	( ! ::strcmp( aQ, "color04" ) )			::printf( usercolo[4] );
	else if	( ! ::strcmp( aQ, "color05" ) )			::printf( usercolo[5] );
	else if	( ! ::strcmp( aQ, "color06" ) )			::printf( usercolo[6] );
	else if	( ! ::strcmp( aQ, "color07" ) )			::printf( usercolo[7] );
	else if	( ! ::strcmp( aQ, "color08" ) )			::printf( usercolo[8] );
	else if	( ! ::strcmp( aQ, "color09" ) )			::printf( usercolo[9] );
	else if	( ! ::strcmp( aQ, "color10" ) )			::printf( usercolo[10] );
	else if	( ! ::strcmp( aQ, "color11" ) )			::printf( usercolo[11] );
	else if	( ! ::strcmp( aQ, "color12" ) )			::printf( usercolo[12] );
	else if	( ! ::strcmp( aQ, "color13" ) )			::printf( usercolo[13] );
	else if	( ! ::strcmp( aQ, "color14" ) )			::printf( usercolo[14] );
	else if	( ! ::strcmp( aQ, "color15" ) )			::printf( usercolo[15] );
	else if	( ! ::strcmp( aQ, "color16" ) )			::printf( usercolo[16] );
	else if	( ! ::strcmp( aQ, "color17" ) )			::printf( usercolo[17] );
	else if	( ! ::strcmp( aQ, "color18" ) )			::printf( usercolo[18] );
	else if	( ! ::strcmp( aQ, "color19" ) )			::printf( usercolo[19] );
	else if	( ! ::strcmp( aQ, "color20" ) )			::printf( usercolo[20] );
	else if	( ! ::strcmp( aQ, "color21" ) )			::printf( usercolo[21] );

	else if	( ! ::strcmp( aQ, "color00r" ) )		::printf( "%d", usercolo_r[0] );
	else if	( ! ::strcmp( aQ, "color01r" ) )		::printf( "%d", usercolo_r[1] );
	else if	( ! ::strcmp( aQ, "color02r" ) )		::printf( "%d", usercolo_r[2] );
	else if	( ! ::strcmp( aQ, "color03r" ) )		::printf( "%d", usercolo_r[3] );
	else if	( ! ::strcmp( aQ, "color04r" ) )		::printf( "%d", usercolo_r[4] );
	else if	( ! ::strcmp( aQ, "color05r" ) )		::printf( "%d", usercolo_r[5] );
	else if	( ! ::strcmp( aQ, "color06r" ) )		::printf( "%d", usercolo_r[6] );
	else if	( ! ::strcmp( aQ, "color07r" ) )		::printf( "%d", usercolo_r[7] );
	else if	( ! ::strcmp( aQ, "color08r" ) )		::printf( "%d", usercolo_r[8] );
	else if	( ! ::strcmp( aQ, "color09r" ) )		::printf( "%d", usercolo_r[9] );
	else if	( ! ::strcmp( aQ, "color10r" ) )		::printf( "%d", usercolo_r[10] );
	else if	( ! ::strcmp( aQ, "color11r" ) )		::printf( "%d", usercolo_r[11] );
	else if	( ! ::strcmp( aQ, "color12r" ) )		::printf( "%d", usercolo_r[12] );
	else if	( ! ::strcmp( aQ, "color13r" ) )		::printf( "%d", usercolo_r[13] );
	else if	( ! ::strcmp( aQ, "color14r" ) )		::printf( "%d", usercolo_r[14] );
	else if	( ! ::strcmp( aQ, "color15r" ) )		::printf( "%d", usercolo_r[15] );
	else if	( ! ::strcmp( aQ, "color16r" ) )		::printf( "%d", usercolo_r[16] );
	else if	( ! ::strcmp( aQ, "color17r" ) )		::printf( "%d", usercolo_r[17] );
	else if	( ! ::strcmp( aQ, "color18r" ) )		::printf( "%d", usercolo_r[18] );
	else if	( ! ::strcmp( aQ, "color19r" ) )		::printf( "%d", usercolo_r[19] );
	else if	( ! ::strcmp( aQ, "color20r" ) )		::printf( "%d", usercolo_r[20] );
	else if	( ! ::strcmp( aQ, "color21r" ) )		::printf( "%d", usercolo_r[21] );

	else if	( ! ::strcmp( aQ, "color00g" ) )		::printf( "%d", usercolo_g[0] );
	else if	( ! ::strcmp( aQ, "color01g" ) )		::printf( "%d", usercolo_g[1] );
	else if	( ! ::strcmp( aQ, "color02g" ) )		::printf( "%d", usercolo_g[2] );
	else if	( ! ::strcmp( aQ, "color03g" ) )		::printf( "%d", usercolo_g[3] );
	else if	( ! ::strcmp( aQ, "color04g" ) )		::printf( "%d", usercolo_g[4] );
	else if	( ! ::strcmp( aQ, "color05g" ) )		::printf( "%d", usercolo_g[5] );
	else if	( ! ::strcmp( aQ, "color06g" ) )		::printf( "%d", usercolo_g[6] );
	else if	( ! ::strcmp( aQ, "color07g" ) )		::printf( "%d", usercolo_g[7] );
	else if	( ! ::strcmp( aQ, "color08g" ) )		::printf( "%d", usercolo_g[8] );
	else if	( ! ::strcmp( aQ, "color09g" ) )		::printf( "%d", usercolo_g[9] );
	else if	( ! ::strcmp( aQ, "color10g" ) )		::printf( "%d", usercolo_g[10] );
	else if	( ! ::strcmp( aQ, "color11g" ) )		::printf( "%d", usercolo_g[11] );
	else if	( ! ::strcmp( aQ, "color12g" ) )		::printf( "%d", usercolo_g[12] );
	else if	( ! ::strcmp( aQ, "color13g" ) )		::printf( "%d", usercolo_g[13] );
	else if	( ! ::strcmp( aQ, "color14g" ) )		::printf( "%d", usercolo_g[14] );
	else if	( ! ::strcmp( aQ, "color15g" ) )		::printf( "%d", usercolo_g[15] );
	else if	( ! ::strcmp( aQ, "color16g" ) )		::printf( "%d", usercolo_g[16] );
	else if	( ! ::strcmp( aQ, "color17g" ) )		::printf( "%d", usercolo_g[17] );
	else if	( ! ::strcmp( aQ, "color18g" ) )		::printf( "%d", usercolo_g[18] );
	else if	( ! ::strcmp( aQ, "color19g" ) )		::printf( "%d", usercolo_g[19] );
	else if	( ! ::strcmp( aQ, "color20g" ) )		::printf( "%d", usercolo_g[20] );
	else if	( ! ::strcmp( aQ, "color21g" ) )		::printf( "%d", usercolo_g[21] );

	else if	( ! ::strcmp( aQ, "color00b" ) )		::printf( "%d", usercolo_b[0] );
	else if	( ! ::strcmp( aQ, "color01b" ) )		::printf( "%d", usercolo_b[1] );
	else if	( ! ::strcmp( aQ, "color02b" ) )		::printf( "%d", usercolo_b[2] );
	else if	( ! ::strcmp( aQ, "color03b" ) )		::printf( "%d", usercolo_b[3] );
	else if	( ! ::strcmp( aQ, "color04b" ) )		::printf( "%d", usercolo_b[4] );
	else if	( ! ::strcmp( aQ, "color05b" ) )		::printf( "%d", usercolo_b[5] );
	else if	( ! ::strcmp( aQ, "color06b" ) )		::printf( "%d", usercolo_b[6] );
	else if	( ! ::strcmp( aQ, "color07b" ) )		::printf( "%d", usercolo_b[7] );
	else if	( ! ::strcmp( aQ, "color08b" ) )		::printf( "%d", usercolo_b[8] );
	else if	( ! ::strcmp( aQ, "color09b" ) )		::printf( "%d", usercolo_b[9] );
	else if	( ! ::strcmp( aQ, "color10b" ) )		::printf( "%d", usercolo_b[10] );
	else if	( ! ::strcmp( aQ, "color11b" ) )		::printf( "%d", usercolo_b[11] );
	else if	( ! ::strcmp( aQ, "color12b" ) )		::printf( "%d", usercolo_b[12] );
	else if	( ! ::strcmp( aQ, "color13b" ) )		::printf( "%d", usercolo_b[13] );
	else if	( ! ::strcmp( aQ, "color14b" ) )		::printf( "%d", usercolo_b[14] );
	else if	( ! ::strcmp( aQ, "color15b" ) )		::printf( "%d", usercolo_b[15] );
	else if	( ! ::strcmp( aQ, "color16b" ) )		::printf( "%d", usercolo_b[16] );
	else if	( ! ::strcmp( aQ, "color17b" ) )		::printf( "%d", usercolo_b[17] );
	else if	( ! ::strcmp( aQ, "color18b" ) )		::printf( "%d", usercolo_b[18] );
	else if	( ! ::strcmp( aQ, "color19b" ) )		::printf( "%d", usercolo_b[19] );
	else if	( ! ::strcmp( aQ, "color20b" ) )		::printf( "%d", usercolo_b[20] );
	else if	( ! ::strcmp( aQ, "color21b" ) )		::printf( "%d", usercolo_b[21] );

	// ----------------------------------------------------------------
	// Size output
	// ----------------------------------------------------------------
	else if	( ! ::strcmp( aQ, "small" ) )			::printf( "%d", usersize - 2 );
	else if	( ! ::strcmp( aQ, "normal" ) )			::printf( "%d", usersize );
	else if	( ! ::strcmp( aQ, "big" ) )				::printf( "%d", usersize + 2 );
	else if	( ! ::strcmp( aQ, "huge" ) )			::printf( "%d", usersize * 2 );

	// ----------------------------------------------------------------
	// Parsing table data
	// ----------------------------------------------------------------
	else if	( ::MySqlTableParser( user.Layout(), "user", (const char *)(&userdata), aQ ) )	;

	// ----------------------------------------------------------------
	// Parsing the CGI data
	// ----------------------------------------------------------------
	else if	( ::cgi_parser( cgi, aQ ) )	;

	// ----------------------------------------------------------------
	// Everything else goes to default parser
	// ----------------------------------------------------------------
	else	::my_default_answer( aQ );
}

// --------------------------------------------------------------------
// local:	Convert hex char
// --------------------------------------------------------------------
static	dword_t	__hex	( char	aNibble ) {
	switch	( aNibble ) {
		case	'0':	return	0;
		case	'1':	return	1;
		case	'2':	return	2;
		case	'3':	return	3;
		case	'4':	return	4;
		case	'5':	return	5;
		case	'6':	return	6;
		case	'7':	return	7;
		case	'8':	return	8;
		case	'9':	return	9;
		case	'a':	return	10;
		case	'A':	return	10;
		case	'b':	return	11;
		case	'B':	return	11;
		case	'c':	return	12;
		case	'C':	return	12;
		case	'd':	return	13;
		case	'D':	return	13;
		case	'e':	return	14;
		case	'E':	return	14;
		case	'f':	return	15;
		case	'F':	return	15;
	}
	return	0;
}

// --------------------------------------------------------------------
// local:	Set the color scheme
// --------------------------------------------------------------------
static	void	__set_colorscheme	( const char * aCs ) {
	data_pref_tl	data;

	if	( *aCs == 0 ) {
		data = pref.Select( db, " where pref_name='default-colors'" );
		if	( data.size() < 1 ) {
			throw CError( "Preference not found", "default-colors" );
		}
		aCs = (*(data.begin())).pref_valu;
	}

	// Extract the colors from the color scheme
	int		i;
	for	( i = 0; i < COLOR_SCHEME_COLORS; i++ ) {
		usercolo[i][0]	= '#';
		usercolo[i][1]	= aCs[0];
		usercolo[i][2]	= aCs[0];
		usercolo[i][3]	= aCs[1];
		usercolo[i][4]	= aCs[1];
		usercolo[i][5]	= aCs[2];
		usercolo[i][6]	= aCs[2];
		usercolo[i][7]	= 0;
		usercolo_r[i]	= __hex( aCs[0] );
		usercolo_g[i]	= __hex( aCs[1] );
		usercolo_b[i]	= __hex( aCs[2] );
		aCs += 3;
	}

	// The last thing in the string is the text base size
	usersize = ::atol( aCs );
	if	( usersize < 8 )	usersize = 8;
	if	( usersize > 16 )	usersize = 16;
}

// --------------------------------------------------------------------
// local:	Save colorscheme
// --------------------------------------------------------------------
static	void	__save_colorscheme	( void ) {
	char		mycolor	[200];
	char		argname	[32];
	dword_t		ix;

	*mycolor = 0;
	for	( ix = 0; ix < COLOR_SCHEME_COLORS; ix++ ) {
		::sprintf( argname, "r%d", ix );	::strcat( mycolor, hexstr[::atol( cgi.Arg( argname ) ) & 0x0f] );
		::sprintf( argname, "g%d", ix );	::strcat( mycolor, hexstr[::atol( cgi.Arg( argname ) ) & 0x0f] );
		::sprintf( argname, "b%d", ix );	::strcat( mycolor, hexstr[::atol( cgi.Arg( argname ) ) & 0x0f] );
	}

	ix = ::atol( cgi.Arg( "usersize" ) );
	if	( ix < 8 )	ix = 8;
	if	( ix > 16 )	ix = 16;
	::sprintf( mycolor + ::strlen( mycolor ), "%d", ix );

	::strcpy( userdata.user_colo, mycolor );
	user.Update( db, &userdata );	

}

// --------------------------------------------------------------------
// local:	Save as preset
// --------------------------------------------------------------------
static	void	__save_preset	( void ) {
	char		mycolor	[200];
	char		argname	[32];
	dword_t		ix;
	CMySqlWhere	w;
	CMySqlQuote	q;

	if	( ! cgi.Exist( "preset" ) )	return;

	if	( (userdata.user_flag & FLAG_SUPERUSER) == 0 )	return;


	*mycolor = 0;
	for	( ix = 0; ix < COLOR_SCHEME_COLORS; ix++ ) {
		::sprintf( argname, "r%d", ix );	::strcat( mycolor, hexstr[::atol( cgi.Arg( argname ) ) & 0x0f] );
		::sprintf( argname, "g%d", ix );	::strcat( mycolor, hexstr[::atol( cgi.Arg( argname ) ) & 0x0f] );
		::sprintf( argname, "b%d", ix );	::strcat( mycolor, hexstr[::atol( cgi.Arg( argname ) ) & 0x0f] );
	}

	ix = ::atol( cgi.Arg( "usersize" ) );
	if	( ix < 8 )	ix = 8;
	if	( ix > 16 )	ix = 16;
	::sprintf( mycolor + ::strlen( mycolor ), "%d", ix );

	data_user_t	udata;

	::memset( &udata, 0, sizeof( udata ) );
	::strcpy( udata.user_name, "Preset user entry" );
	::strcpy( udata.user_logn, "#" );
	::my_strfit( udata.user_logn + 1, sizeof( udata.user_logn ) - 1, cgi.Arg( "preset" ) );

	udata.user_atim = ::time( NULL );
	udata.user_ltim = ::time( NULL );
	udata.user_flag = FLAG_BANNED | FLAG_DENY_VIEW;
	::strcpy( udata.user_colo, mycolor );

	// Let's check if this entry already exists
	w << "user_logn='" << q.Quote( udata.user_logn ) << "'";
	if	( user.Count( db, w ) > 0 )	return;

	udata.user_idnt = user.NextIdnt( db );
	user.Insert( db, &udata );

	__set_colorscheme( mycolor );
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );
	try	{
		CSession	session(	cgi, 
								"tmpl-coloradmin-logn",
								cgi.Arg("forw"),
								"./regsaves",
								saveargs );

		if	( session.Check() ) {

			::HTTP_text( "en" );

			// --------------------------------------------------------
			// First we make a copy of the logged in user record
			// --------------------------------------------------------
			userdata = session.UserData();

			// --------------------------------------------------------
			// Also, collect other useful information of the session
			// --------------------------------------------------------
			userid	= session.User();
			sessid	= session.SessId();
			taskid	= ::atol( cgi.Arg( "task" ) );

			switch	( taskid ) {
				case	0:	// Will output the test form
				__set_colorscheme( userdata.user_colo );
				previewtemplate.Execute( __answer, "tmpl-coloradmin-data" );
				break;

				case	1:	// Saves and outputs the test form
				__save_colorscheme();
				__set_colorscheme( userdata.user_colo );
				previewtemplate.Execute( __answer, "tmpl-coloradmin-data" );
				break;

				case	2:	// Revert to default colors
				__set_colorscheme( "" );
				previewtemplate.Execute( __answer, "tmpl-coloradmin-data" );
				break;

				case	3:	// Save as preset - a name must be specified
				__save_preset();
				previewtemplate.Execute( __answer, "tmpl-coloradmin-data" );
				break;

				case	4:	// Use a given value as preset
				__set_colorscheme( cgi.Arg( "usepreset" ) );
				previewtemplate.Execute( __answer, "tmpl-coloradmin-data" );
				break;
			}
		}
    }

	catch	( CError e ) {
		::HTTP_text( "en" );
		::printf( "ERROR: %s", e.Error() );
	}

    catch   ( ... ) {
		::HTTP_text( "en" );
		::printf( "Failed to execute administering program" );
    }

    return	0;
}

// --------------------------------------------------------------------
// EOF: Storage.cxx
// --------------------------------------------------------------------
