// --------------------------------------------------------------------
// DisplayLinks.cxx
// Whatis:  CGI for viewing the link database
// CGI arguments:
//
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 14-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableUrll.hxx"
#include    "CTablePref.hxx"
#include	"CCgiArgs.hxx"
#include    "CPreviewTemplate.hxx"
#include	"CMySqlWhere.hxx"
#include	"CSpam.hxx"

// --------------------------------------------------------------------
// local:	The local data
// --------------------------------------------------------------------
static	CCgiArgs			cgi;
static	CMySqlConnect		db( "quest", "", "UTCMS" );
static	CPreviewTemplate	previewtemplate;

// --------------------------------------------------------------------
// local:	Some database tables needed
// --------------------------------------------------------------------
static	CTableUrll		urll;
static	CTablePref		pref;

// --------------------------------------------------------------------
// local:	Data associated with those tables
// --------------------------------------------------------------------
static	data_urll_t		urlldata		= { { 0 } };
static	char			prevname[256]	= { 0 };
static	char			prevtext[256]	= { 0 };
static	char			estimate[512]	= { 0 };
static	char			mirror	[512]	= { 0 };
static	dword_t			mirrornum		= 0;
static	dword_t			rownumber		= 0;

// --------------------------------------------------------------------
// local:	Output the file size instead of the "mirror" text
// --------------------------------------------------------------------
static	void	__mirrorsize( dword_t aSize ) {
	if		( aSize < 1000 )		::sprintf( mirror, "%d", aSize );
	else if	( aSize < 10000 )		::sprintf( mirror, "%-4.3lfK", (double)aSize / 1000.0 );
	else if	( aSize < 100000 )		::sprintf( mirror, "%-4.2lfK", (double)aSize / 1000.0 );
	else if	( aSize < 1000000 )		::sprintf( mirror, "%-4.1lfK", (double)aSize / 1000.0 );
	else if	( aSize < 10000000 )	::sprintf( mirror, "%-4.3lfM", (double)aSize / 1000000.0 );
	else if	( aSize < 100000000 )	::sprintf( mirror, "%-4.2lfM", (double)aSize / 1000000.0 );
	else if	( aSize < 1000000000 )	::sprintf( mirror, "%-4.1lfM", (double)aSize / 1000000.0 );
	else							::sprintf( mirror, "%-4.3lfG", (double)aSize / 1000000000.0 );

	dword_t	dlseconds = aSize / 8192;
	
	::sprintf( 	estimate, "Estimated download time %d minutes and %d seconds",
				dlseconds / 60,
				dlseconds % 60 );
}

// --------------------------------------------------------------------
// local:	Checking out if this is in our local repository
// --------------------------------------------------------------------
static	void	__mirrorfile( void ) {
	char		fixfile[300];
	char		filepath[300];
	char *		p;
	struct stat	mystat;

	::strcpy( fixfile, urlldata.urll_addr );
	p = ::strchr( fixfile, ':' );
	if	( p )	::strcpy( fixfile, p + 1 );

	while	( *fixfile == '/' )	::strcpy( fixfile, fixfile + 1 );

	p = ::strchr( fixfile, '/' );
	if	( p )	::strcpy( fixfile, p );



	// In the FTP root ?
	::sprintf( filepath, "/home/ftp%s", fixfile );
	if	( ! ::stat( filepath, &mystat ) ) {
		__mirrorsize( mystat.st_size );
		return;
	}

	// In the WWW root ?
	::sprintf( filepath, "/mnt/disk8/wwwroot%s", fixfile );
	if	( ! ::stat( filepath, &mystat ) ) {
		__mirrorsize( mystat.st_size );
		return;
	}

	::sprintf( mirror, "leech%d", mirrornum++ );
}

// --------------------------------------------------------------------
// local:	Output the mirror text
// --------------------------------------------------------------------
static	void	__mirror( void ) {
	::strcpy( estimate, urlldata.urll_addr );
	if		( ! ::strcmp( urlldata.urll_ftyp, "HTTPFILE" ) )	__mirrorfile();
	else if	( ! ::strcmp( urlldata.urll_ftyp, "HTTPSITE" ) )	::sprintf( mirror, "view%d",  mirrornum++ );
	else if	( ! ::strcmp( urlldata.urll_ftyp, "FTP FILE" ) )	__mirrorfile();
	else if	( ! ::strcmp( urlldata.urll_ftyp, "FTP SITE" ) )	::sprintf( mirror, "list%d",  mirrornum++ );
	else														::sprintf( mirror, "omg%d",   mirrornum++ );
}

// --------------------------------------------------------------------
// local:	Parser questions are sent here for answering
// --------------------------------------------------------------------
static	void	__answer	( const char * aQ ) {

	// ----------------------------------------------------------------
	// local parsing
	// ----------------------------------------------------------------
	if		( ! ::strcmp( aQ, "text" ) )		::HTML_quote( prevtext );
	else if	( ! ::strcmp( aQ, "mirror" ) )		::HTML_quote( mirror );
	else if	( ! ::strcmp( aQ, "estimate" ) )	::HTML_quote( estimate );
	else if	( ! ::strcmp( aQ, "linepair" ) )	::printf( "%d", rownumber & 0x01 );

	// ----------------------------------------------------------------
	// Parsing table data
	// ----------------------------------------------------------------
	else if	( ::MySqlTableParser( urll.Layout(), "urll", (const char *)(&urlldata), aQ ) )	;

	// ----------------------------------------------------------------
	// Parsing the CGI data
	// ----------------------------------------------------------------
	else if	( ::cgi_parser( cgi, aQ ) )	;

	// ----------------------------------------------------------------
	// Everything else goes to default parser
	// ----------------------------------------------------------------
	else	::my_default_answer( aQ );
}

// --------------------------------------------------------------------
// local:	Show the link list
// --------------------------------------------------------------------
static	void	__show_link_list	( const char * aType, const char * aFtyp ) {
	CMySqlWhere		w;
	CMySqlQuote		q;
	data_urll_tl	list;
	data_urll_tli	loop;


	w << "urll_type='" << q.Quote( aType ) << "'";
	if	( *aFtyp ) {
		w << " and urll_ftyp='" << q.Quote( aFtyp ) << "'";
	}
	w << " order by urll_name, urll_type, urll_addr";
	list = urll.Select( db, w );

	if	( list.size() > 0 ) {
		previewtemplate.Execute( __answer, "tmpl-displink-list-head" );
		*prevname = 0;
		rownumber = 0;
		for	( loop = list.begin(); loop != list.end(); loop++ ) {
			urlldata = *loop;
			if		( loop == list.begin() ) {
				::strcpy( prevname, urlldata.urll_name );
				::strcpy( prevtext, urlldata.urll_text );
				mirrornum = 1;
				__mirror();
				rownumber++;
				previewtemplate.Execute( __answer, "tmpl-displink-list-bhead" );
				previewtemplate.Execute( __answer, "tmpl-displink-list-bbody" );
			}
	
			else if	( ::strcmp( prevname, urlldata.urll_name ) ) {
				previewtemplate.Execute( __answer, "tmpl-displink-list-btail" );
				::strcpy( prevname, urlldata.urll_name );
				::strcpy( prevtext, urlldata.urll_text );
				mirrornum = 1;
				__mirror();
				rownumber++;
				previewtemplate.Execute( __answer, "tmpl-displink-list-bhead" );
				previewtemplate.Execute( __answer, "tmpl-displink-list-bbody" );
			}
			else {
				if	( *prevtext == 0 ) {
					::strcpy( prevtext, urlldata.urll_text );
				}
				__mirror();
				previewtemplate.Execute( __answer, "tmpl-displink-list-bbody" );
			}
		}
		previewtemplate.Execute( __answer, "tmpl-displink-list-btail" );
		previewtemplate.Execute( __answer, "tmpl-displink-list-tail" );
	}
	else {
		previewtemplate.Execute( __answer, "tmpl-displink-list-none" );
	}
}

// --------------------------------------------------------------------
// local:	Prevent spam
// --------------------------------------------------------------------
static	bool	__spam	( void ) {
	bool	is_spam	= false;

	try	{
		CSpam	myspam1( cgi.Arg( CGI_REMOTE_ADDR ), cgi.Arg( CGI_QUERY_STRING ), 1 );
	}

	catch	( CError e ) {
		is_spam = true;
	}

	return	is_spam;
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );
	::HTTP_text( "en" );

	try	{
		if	( __spam() ) {
			previewtemplate.Execute( __answer, "tmpl-spam-warning" );
			return	-1;
		}

		__show_link_list( cgi.Arg( "type" ), cgi.Arg( "ftyp" ) );
	}

	catch 	( CError e ) {
		::HTML_quote( e.Error() );
		::printf( "</p>" );
	}

	catch	( ... ) {
		::printf( "<p>Error: Unknown error</p>" );
	}
	::fflush( stdout );
	::fclose( stdout );
    return	0;
}

// --------------------------------------------------------------------
// EOF: Preview.cxx
// --------------------------------------------------------------------
