// --------------------------------------------------------------------
// ExtractTex.cxx
// Whatis:  Program for extracting textures from files
//
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 14-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CStorage.hxx"
#include    "CTableFile.hxx"
#include	"CMySqlWhere.hxx"
#include	"CUnUtils.hxx"
#include	"CPictureSourceUTX.hxx"
#include	"CPictureSourceJPG.hxx"
#include	"CPictureFilterAlphaBlend.hxx"
#include	"CPicture.hxx"
#include	"CUnUtils.hxx"
#include	"CUnTexture.hxx"

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );

	try	{
		CMySqlConnect	db( "quest", "", "UTCMS" );
		CUnUtils		unr( aAv[1] );
		unr_actor_tl	list = unr.ActorList( "Texture" );
		unr_actor_tli	loop;
		CPicture		picture;
		CPictureFilterAlphaBlend	blend( 0, 0, 0, 255 );
		bool			testonly	= false;
		bool			useblend	= false;

		for	( int i = 2; i < aAc; i++ ) {
			if		( ! ::strcmp( aAv[i], "blend" ) )	useblend = true;
			else if	( ! ::strcmp( aAv[i], "test" ) )	testonly = true;
		}

		for	( loop = list.begin(); loop != list.end(); loop++ ) {

			try {
				::printf( "Texture %s\n", (*loop).name );
	
				unr.Seek( *loop );
				CUnTexture	tex( unr.UnFile(), unr.UnNameTable(), unr.UnExportTable(), unr.UnImportTable() );
				CPictureSourceUTX	upic( &tex );
	
				char				myjpeg[64];
				::strcpy( myjpeg, (*loop).name );
				::strcat( myjpeg, ".jpg" );
				CPictureSourceJPG	jpeg( myjpeg, 70 );
	
				picture.Load( upic );
				if	( useblend )	picture.Filter( blend );
				if	( ! testonly )	picture.Save( jpeg );
			}
			catch	( CError e ) {
				::printf( "Error: %s\n", e.Error() );
			}
		}

	}

	catch 	( CError e ) {
		::printf( "Error: %s\n", e.Error() );
		return	-1;
	}

	catch	( ... ) {
		::printf( "Unknown Error\n" );
		return	-1;
	}
    return	0;
}

// --------------------------------------------------------------------
// EOF: ExtractTex.cxx
// --------------------------------------------------------------------
