// --------------------------------------------------------------------
// HitCount.cxx
// Whatis:  Chooses a random quote from database
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 02-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTableHitc.hxx"
#include	"CCgiArgs.hxx"
#include	"CMySqlConnect.hxx"
#include	"CMySqlWhere.hxx"

static	CCgiArgs			cgi;
static	CMySqlConnect		db			( "quest", "", "UTCMS" );
static	CTableHitc			hitc;

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );
	::HTTP_text( "en" );
	try	{
		if	( cgi.Exist( "id" ) ) {
			CMySqlWhere		w;
			CMySqlQuote		q;
			data_hitc_t		data;
			data_hitc_tl	list;

			::memset( &data, 0, sizeof( data ) );
			::my_strfit( data.hitc_idnt, sizeof( data.hitc_idnt ), cgi.Arg( "id" ) );
			w << "hitc_idnt='" << q.Quote( data.hitc_idnt ) << "'";
			list = hitc.Select( db, w );
			if	( list.size() > 0 ) {
				data = *(list.begin());
				data.hitc_hits++;
				hitc.Update( db, &data );
			}
			else {
				data.hitc_hits = 1;
				hitc.Insert( db, &data );
			}

			if	( cgi.Exist( "fu" ) ) {
				char			numbuf	[32];
				const char *	fu = cgi.Arg( "fu" );
				char *			p;
				::sprintf( numbuf, "%d", data.hitc_hits );

				::printf( "<img src=\"%sH.gif\" border=\"0\">", fu );
				for	( p = numbuf; *p; p++ ) {
					::printf( "<img src=\"%s%c.gif\" border=\"0\">", fu, *p );
				}
				::printf( "<img src=\"%sT.gif\" border=\"0\">", fu );
			}
			else {
				::printf( "%d", data.hitc_hits );
			}
		}
    }
    catch   ( ... ) {
		::printf( "Yikes" );
    }

	::fflush( stdout );
	::fclose( stdout );
    return  0;
}

// --------------------------------------------------------------------
// EOF: HitCount.cxx
// --------------------------------------------------------------------
