// --------------------------------------------------------------------
// LeechKiller.cxx
// Whatis:  A process that kills double downloads
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 22-SEP-2002     Created this source
// --------------------------------------------------------------------
#include    "Platform.hxx"

// --------------------------------------------------------------------
// This program can handle 64 processes
// --------------------------------------------------------------------
static	char	procdata[64][512]	= { { 0 } };

// --------------------------------------------------------------------
// Get pointer to the end of proc ID
// --------------------------------------------------------------------
static	char *	__endprocid	( char * aPd ) {
	while	( ( *aPd > 0 ) && ( *aPd <= ' ' ) )	aPd++;
	return	::strchr( aPd, ' ' );
}

// --------------------------------------------------------------------
// Get the process list
// --------------------------------------------------------------------
static	word_t	__processes	( void ) {
	word_t	mycount	= 0;
	FILE *	mypipe 	= ::popen( "ps -C proftpd --format pid,args --cols 400", "r" );

	::memset( procdata, 0, sizeof( procdata ) );

	// Always skip over the first as it is the root process

	if	( mypipe ) {
		// Always skip over the first as it is the root process
		if	( ::fgets( procdata[mycount], 511, mypipe ) ) {
			procdata[mycount][0] = 0;
			while	( ( ::fgets( procdata[mycount], 511, mypipe ) ) && ( mycount < 64 ) )	mycount++;
		}
		else {
			procdata[mycount][0] = 0;
		}
		::pclose( mypipe );
	}

	return	mycount;
}

// --------------------------------------------------------------------
// local:	Check for exact duplicate leeches
// --------------------------------------------------------------------
static	bool	__has_duplicate	( word_t aIx, word_t aTc ) {
	bool	result	= false;
	word_t	ix;
	char *	scmp = __endprocid( procdata[aIx] );

	if	( scmp ) {
		for	( ix = 0; ix < aTc; ix++ ) {
			if	( ix != aIx ) {
				char * tcmp = __endprocid( procdata[ix] );
				if	( ! tcmp )	break;
				if	( ! ::strcmp( scmp, tcmp ) ) {
					result = true;
					break;
				}
			}
		}
	}

	return	result;
}

// --------------------------------------------------------------------
// local:	Killer
// --------------------------------------------------------------------
static	void	__kill_process	( word_t aIx ) {
	char *	ktrm = __endprocid( procdata[aIx] );
	char	killer[512];

	if	( ktrm ) {
		*ktrm = 0;

		::sprintf( killer, "kill %s", procdata[aIx] );
		::system( killer );
	}
}

// --------------------------------------------------------------------
// local:	The process itself
// --------------------------------------------------------------------
static	void	__process	( void ) {
	dword_t	sleeptime	= 20;
	while	( 1 == 1 ) {
		word_t	mycount 	= __processes();
		int		prcnow;
		bool	didkill;

		didkill = false;
		if	( mycount > 1 ) {
			for	( prcnow = 1; prcnow < mycount; prcnow++ ) {
				if	( __has_duplicate( prcnow, mycount ) ) {
					__kill_process( prcnow );
					didkill = true;
				}
			}
		}

		if		( didkill )			sleeptime = 1;
		else if	( sleeptime < 20 )	sleeptime++;
		::sleep( sleeptime );
	}
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::daemon( 1, 0 );
	__process();
    return  0;
}

// --------------------------------------------------------------------
// EOF: Motd.cxx
// --------------------------------------------------------------------
