// --------------------------------------------------------------------
// LinkAdmin.cxx
// Whatis:  CGI for administering teh authors
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 15-SEP-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CSession.hxx"
#include	"CCgiArgs.hxx"
#include    "CPreviewTemplate.hxx"
#include	"CMySqlWhere.hxx"
#include	"CTablePref.hxx"
#include	"CTableUser.hxx"
#include	"CTableUrll.hxx"

// --------------------------------------------------------------------
// local:	Structure of link types
// --------------------------------------------------------------------
typedef	struct linktype_s {
	bool	super;
	char	type	[64];
	char	name	[128];
}	linktype_t;
typedef list <linktype_t>			linktype_tl;
typedef linktype_tl::iterator       linktype_tli;
typedef linktype_tl::const_iterator	linktype_tlci;

// --------------------------------------------------------------------
// local:	Save argument name list
// --------------------------------------------------------------------
static	const char *	saveargs[] = {
	"task",
	"findname", "findtype", "findaddr", "forw", "page", "taskid",
	"urll_name", "urll_type", "urll_ftyp", "urll_addr", "urll_text", "urll_user",
	"old_urll_name", "old_urll_type", "old_urll_addr", "old_urll_ftyp", "old_urll_user", "old_urll_text",

	NULL
};

// --------------------------------------------------------------------
// local:	The CGI arguments
// --------------------------------------------------------------------
static	CCgiArgs		cgi;
static	CMySqlConnect		db( "quest", "", "UTCMS" );
static	CPreviewTemplate	previewtemplate;
static	dword_t			userid	= 0;
static	dword_t			sessid	= 0;
static	dword_t			taskid	= 0;
static	dword_t			pagenow	= 0;
static	dword_t			lastpage= 0;
static	dword_t			rownumber	= 0;

// --------------------------------------------------------------------
// local:	Some database tables needed
// --------------------------------------------------------------------
static	CTablePref		pref;
static	CTableUrll		urll;

// --------------------------------------------------------------------
// local:	Data associated with those tables
// --------------------------------------------------------------------
static	data_user_t		logndata		= { 0 };
static	data_urll_t		urlldata		= { { 0 } };
static	linktype_t		typedata		= { 0 };

// --------------------------------------------------------------------
// local:	Link types read from config
// --------------------------------------------------------------------
static	linktype_tl		typelist;

// --------------------------------------------------------------------
// local:	Output first part for true, last part for false
//			The parts are separated by '\' character
// --------------------------------------------------------------------
static	void	__outpart	( 	const char *	aS,
								bool			aFirst ) {
	char *	cs	= ::my_private_strdup( aS );
	char *	s	= ::strchr( cs, '|' );

	if	( s ) {
		*s = 0;
		s++;
	}
	else {
		s = "";
	}

	::printf( "%s", aFirst ? cs : s );

	delete [] cs;
}

// --------------------------------------------------------------------
// local:	Output something depending on state of a flag
// --------------------------------------------------------------------
static	void	__onflag	( 	dword_t				aU,
								const char * 		aS ) {

	if		( ! ::strncmp( aS, "DENY_READ?", 	10 ) )	__outpart( aS + 10, (aU & FLAG_DENY_READ) != 0 );
	else if	( ! ::strncmp( aS, "DENY_WRITE?",	11 ) )	__outpart( aS + 11, (aU & FLAG_DENY_WRITE) != 0 );
	else if	( ! ::strncmp( aS, "DENY_VIEW?",	10 ) )	__outpart( aS + 10, (aU & FLAG_DENY_VIEW) != 0 );
	else if	( ! ::strncmp( aS, "DENY_MOD?",		9 ) )	__outpart( aS + 9,  (aU & FLAG_DENY_MOD) != 0 );
	else if	( ! ::strncmp( aS, "DENY_REN?",		9 ) )	__outpart( aS + 9,  (aU & FLAG_DENY_REN) != 0 );
	else if	( ! ::strncmp( aS, "DENY_DEL?",		9 ) )	__outpart( aS + 9,  (aU & FLAG_DENY_DEL) != 0 );
	else if	( ! ::strncmp( aS, "FIX_FLAG?",		9 ) )	__outpart( aS + 9,  (aU & FLAG_FIX_FLAG) != 0 );
	else if	( ! ::strncmp( aS, "ACCEPTED?",		9 ) )	__outpart( aS + 9,  (aU & FLAG_ACCEPTED) != 0 );
	else if	( ! ::strncmp( aS, "BANNED?",		7 ) )	__outpart( aS + 7,  (aU & FLAG_BANNED) != 0 );
	else if	( ! ::strncmp( aS, "NOSUGGEST?",	10 ) )	__outpart( aS + 10, (aU & FLAG_NOSUGGEST) != 0 );
	else if	( ! ::strncmp( aS, "NODOWNLOAD?",	11 ) )	__outpart( aS + 11, (aU & FLAG_NODOWNLOAD) != 0 );
	else if	( ! ::strncmp( aS, "SUPERUSER?",	10 ) )	__outpart( aS + 10, (aU & FLAG_SUPERUSER) != 0 );
	else if	( ! ::strncmp( aS, "NEWSADMIN?",	10 ) )	__outpart( aS + 10, (aU & FLAG_NEWSADMIN) != 0 );
	else if	( ! ::strncmp( aS, "REVIADMIN?",	10 ) )	__outpart( aS + 10, (aU & FLAG_REVIADMIN) != 0 );
	else if	( ! ::strncmp( aS, "COMMADMIN?",	10 ) )	__outpart( aS + 10, (aU & FLAG_COMMADMIN) != 0 );
}

// --------------------------------------------------------------------
// local:	Check if this link is editable
// --------------------------------------------------------------------
static	bool	__editable	( void ) {
	if	( (logndata.user_flag & FLAG_SUPERUSER) != 0 )	return true;

	linktype_tli	loop;

	for	( loop = typelist.begin(); loop != typelist.end(); loop++ ) {
		if	( ! ::strcmp( (*loop).type, urlldata.urll_type ) ) {
			if	( (*loop).super )	return false;
		}
	}

	return	true;
}

// --------------------------------------------------------------------
// local:	Read in the typelist from preferences
// --------------------------------------------------------------------
static	void	__read_types	( void ) {
	CMySqlWhere		w;
	data_pref_tl	list;
	data_pref_tli	loop;
	linktype_t		type;
	char			buff	[1024];
	char *			name;

	w << "pref_name like 'urltype-%' order by pref_name";
	list = pref.Select( db, w );

	for	( loop = list.begin(); loop != list.end(); loop++ ) {
		::strcpy( buff, (*loop).pref_valu );

		::memset( &type, 0, sizeof( type ) );
		type.super = (*buff != '0');

		::strcpy( buff, buff + 2 );
		name = ::strchr( buff, ' ' );

		if	( ! name )	continue;

		*name = 0;
		name++;

		::my_strfit( type.type, sizeof( type.type ), buff );
		::my_strfit( type.name, sizeof( type.name ), name );

		typelist.push_back( type );
	}
}

// --------------------------------------------------------------------
// local:	Parser questions are sent here for answering
// --------------------------------------------------------------------
static	void	__answer	( const char * aQ ) {

	// ----------------------------------------------------------------
	// Local parsing
	// ----------------------------------------------------------------
	if		( ! ::strcmp( aQ, "sessid" ) )			::printf( "%d", sessid );
	else if	( ! ::strcmp( aQ, "userid" ) )			::printf( "%d", userid );
	else if	( ! ::strcmp( aQ, "taskid" ) )			::printf( "%d", taskid );
	else if	( ! ::strcmp( aQ, "pagenow" ) )			::printf( "%d", pagenow );
	else if	( ! ::strcmp( aQ, "nextpage" ) )		::printf( "%d", pagenow + 1 );
	else if	( ! ::strcmp( aQ, "prevpage" ) )		::printf( "%d", pagenow - 1 );
	else if	( ! ::strcmp( aQ, "lastpage" ) )		::printf( "%d", lastpage );
	else if	( ! ::strcmp( aQ, "rownumber" ) )		::printf( "%d", rownumber );

	else if	( ! ::strcmp( aQ, "typename" ) )		::printf( "%s", typedata.name );
	else if	( ! ::strcmp( aQ, "typetype" ) )		::printf( "%s", typedata.type );

	else if	( ! ::strcmp( aQ, "super_b" ) )			::printf( "%s", (logndata.user_flag & FLAG_SUPERUSER) != 0 ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "super_e" ) )			::printf( "%s", (logndata.user_flag & FLAG_SUPERUSER) != 0 ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "nosuper_b" ) )		::printf( "%s", (logndata.user_flag & FLAG_SUPERUSER) == 0 ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "nosuper_e" ) )		::printf( "%s", (logndata.user_flag & FLAG_SUPERUSER) == 0 ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "edit_b" ) )			::printf( "%s", __editable() ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "edit_e" ) )			::printf( "%s", __editable() ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "noedit_b" ) )		::printf( "%s", ! __editable() ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "noedit_e" ) )		::printf( "%s", ! __editable() ? "" : " -->" );

	// ----------------------------------------------------------------
	// The onflag directive
	// ----------------------------------------------------------------
	else if	( ! ::strncmp( aQ, "onlogflag-", 10 ) )	__onflag( logndata.user_flag, aQ + 10 );

	// ----------------------------------------------------------------
	// Fetch type popup selection
	// ----------------------------------------------------------------
	else if	( ! ::strcmp( aQ, "ftypsel1" ) )		::printf( "%s", ! ::strcmp( urlldata.urll_ftyp, "HTTPSITE" ) ? "selected" : "" );
	else if	( ! ::strcmp( aQ, "ftypsel2" ) )		::printf( "%s", ! ::strcmp( urlldata.urll_ftyp, "HTTPFILE" ) ? "selected" : "" );
	else if	( ! ::strcmp( aQ, "ftypsel3" ) )		::printf( "%s", ! ::strcmp( urlldata.urll_ftyp, "FTP SITE" ) ? "selected" : "" );
	else if	( ! ::strcmp( aQ, "ftypsel4" ) )		::printf( "%s", ! ::strcmp( urlldata.urll_ftyp, "FTP FILE" ) ? "selected" : "" );

	// ----------------------------------------------------------------
	// Link type popup selection
	// ----------------------------------------------------------------
	else if	( ! ::strcmp( aQ, "linktypsel" ) )		::printf( "%s", ! ::strcmp( urlldata.urll_type, typedata.type ) ? "selected" : "" );
	else if	( ! ::strcmp( aQ, "findtypsel" ) )		::printf( "%s", ! ::strcmp( cgi.Arg( "findtype" ), typedata.type ) ? "selected" : "" );

	// ----------------------------------------------------------------
	// Paging
	// ----------------------------------------------------------------
	else if	( ! ::strcmp( aQ, "pagenext_b" ) )		::printf( "%s", pagenow < lastpage ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pagenext_e" ) )		::printf( "%s", pagenow < lastpage ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "pagenext_bx" ) )		::printf( "%s", pagenow >= lastpage ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pagenext_ex" ) )		::printf( "%s", pagenow >= lastpage ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "pageprev_b" ) )		::printf( "%s", pagenow > 1 ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pageprev_e" ) )		::printf( "%s", pagenow > 1 ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "pageprev_bx" ) )		::printf( "%s", pagenow <= 1 ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pageprev_ex" ) )		::printf( "%s", pagenow <= 1 ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "linepair" ) )		::printf( "%d", rownumber & 0x01 );

	// ----------------------------------------------------------------
	// Parsing table data
	// ----------------------------------------------------------------
	else if	( ::MySqlTableParser( urll.Layout(), "urll", (const char *)(&urlldata), aQ ) )	;

	// ----------------------------------------------------------------
	// Parsing the CGI data
	// ----------------------------------------------------------------
	else if	( ::cgi_parser( cgi, aQ ) )	;

	// ----------------------------------------------------------------
	// Everything else goes to default parser
	// ----------------------------------------------------------------
	else	::my_default_answer( aQ );
}

// --------------------------------------------------------------------
// local:	Produce a list of links
// --------------------------------------------------------------------
static	void	__linklist	( void ) {
	// ----------------------------------------------------------------
	// More information from the cgi
	// ----------------------------------------------------------------
	pagenow	= ::atol( cgi.Arg( "page" ) );
	if	( pagenow < 1 )	pagenow = 1;

	CMySqlWhere		w;
	CMySqlQuote		q;
	data_urll_tl	list;
	data_urll_tli	loop;
	linktype_tli	liloop;

	w << "urll_name like '%" << q.Quote( cgi.Arg( "findname" ) ) << "%' and ";
	w << "urll_type like '%" << q.Quote( cgi.Arg( "findtype" ) ) << "%' and ";
	w << "urll_addr like '%" << q.Quote( cgi.Arg( "findaddr" ) ) << "%'";

	// Only superuser can see all links
	if	( (logndata.user_flag & FLAG_SUPERUSER) == 0 ) {
		w << " and urll_user=" << userid;
	}

	lastpage = urll.Count( db, w ) / 20 + 1;
	if	( pagenow > lastpage )	pagenow = lastpage;

	w << " order by urll_name, urll_type, urll_addr LIMIT "
	  << (dword_t)((pagenow-1) * 20)
	  << ",20";

	list = urll.Select( db, w );

	::HTTP_text( "en" );
	previewtemplate.Execute( __answer, "tmpl-linkadmin-list-hhead" );

	for	( liloop = typelist.begin(); liloop != typelist.end(); liloop++ ) {
		typedata = *liloop;
		if	( (logndata.user_flag & FLAG_SUPERUSER) == 0 ) {
			if	( typedata.super == false ) {
				previewtemplate.Execute( __answer, "tmpl-linkadmin-list-hbody" );
			}
		}
		else {
			previewtemplate.Execute( __answer, "tmpl-linkadmin-list-hbody" );
		}
	}

	previewtemplate.Execute( __answer, "tmpl-linkadmin-list-htail" );

	rownumber = 0;
	for	( loop = list.begin(); loop != list.end(); loop++ ) {
		urlldata = *loop;
		previewtemplate.Execute( __answer, "tmpl-linkadmin-list-body" );
		rownumber++;
	}
	previewtemplate.Execute( __answer, "tmpl-linkadmin-list-tail" );
}

// --------------------------------------------------------------------
// local:	Output the link edit form
// --------------------------------------------------------------------
static	void	__output_link_form	( void ) {
	::HTTP_text( "en" );
	previewtemplate.Execute( __answer, "tmpl-linkadmin-edit-head" );
	linktype_tli	loop;

	for	( loop = typelist.begin(); loop != typelist.end(); loop++ ) {
		typedata = *loop;
		if	( (logndata.user_flag & FLAG_SUPERUSER) == 0 ) {
			if	( typedata.super == false ) {
				previewtemplate.Execute( __answer, "tmpl-linkadmin-edit-body" );
			}
		}
		else {
			previewtemplate.Execute( __answer, "tmpl-linkadmin-edit-body" );
		}
	}

	previewtemplate.Execute( __answer, "tmpl-linkadmin-edit-tail" );
}

// --------------------------------------------------------------------
// local:	Remove a link
// --------------------------------------------------------------------
static	void	__remove_link	( void ) {
	CMySqlWhere		w;
	CMySqlQuote		q;
	data_urll_tl	list;

	w << "urll_name='" << q.Quote( cgi.Arg( "urll_name" ) ) << "' and ";
	w << "urll_type='" << q.Quote( cgi.Arg( "urll_type" ) ) << "' and ";
	w << "urll_addr='" << q.Quote( cgi.Arg( "urll_addr" ) ) << "'";

	// Only superuser can see all links
	if	( (logndata.user_flag & FLAG_SUPERUSER) == 0 ) {
		w << " and urll_user=" << userid;
	}

	list = urll.Select( db, w );
	if	( list.size() > 0 ) {
		urlldata = *(list.begin());
		if	( __editable() ) {
			urll.Delete( db, w );
		}
	}
}

// --------------------------------------------------------------------
// local:	Add new link to database
// --------------------------------------------------------------------
static	void	__add_new_link	( void ) {
	CMySqlWhere		w;
	CMySqlQuote		q;
	data_urll_tl	list;
	data_urll_t		newurll;

	::my_strfit( newurll.urll_name, sizeof( newurll.urll_name ), cgi.Arg( "urll_name" ) );
	::my_strfix( newurll.urll_name );

	::my_strfit( newurll.urll_type, sizeof( newurll.urll_type ), cgi.Arg( "urll_type" ) );

	::my_strfit( newurll.urll_addr, sizeof( newurll.urll_addr ), cgi.Arg( "urll_addr" ) );
	::my_strfix( newurll.urll_addr );


	::my_strfit( newurll.urll_ftyp, sizeof( newurll.urll_ftyp ), cgi.Arg( "urll_ftyp" ) );

	newurll.urll_user = ::atol( cgi.Arg( "urll_user" ) );
	::my_strfit( newurll.urll_text, sizeof( newurll.urll_text ), cgi.Arg( "urll_text" ) );

	// If not superuser, we must check for ownership
	if	( (logndata.user_flag & FLAG_SUPERUSER) == 0 ) {
		if	( newurll.urll_user != userid ) {
			return;
		}
	}

	urlldata = newurll;
	if	( ! __editable() ) {
		return;
	}


	urll.Delete( db, &newurll );
	urll.Insert( db, &newurll );
}

// --------------------------------------------------------------------
// local:	Give form for editing a link
// --------------------------------------------------------------------
static	void	__edit_link_form	( void ) {
	CMySqlWhere		w;
	CMySqlQuote		q;
	data_urll_tl	list;

	w << "urll_name='" << q.Quote( cgi.Arg( "urll_name" ) ) << "' and ";
	w << "urll_type='" << q.Quote( cgi.Arg( "urll_type" ) ) << "' and ";
	w << "urll_addr='" << q.Quote( cgi.Arg( "urll_addr" ) ) << "'";

	// Only superuser can see all links
	if	( (logndata.user_flag & FLAG_SUPERUSER) == 0 ) {
		w << " and urll_user=" << userid;
	}

	list = urll.Select( db, w );
	if	( list.size() > 0 ) {
		urlldata = *(list.begin());
		if	( __editable() ) {
			__output_link_form();
		}
		else {
			__linklist();
		}
	}
	else {
		__linklist();
	}
}

// --------------------------------------------------------------------
// local:	Adding a new link to database
// --------------------------------------------------------------------
static	void	__update_old_link	( void ) {
	CMySqlWhere		w;
	CMySqlQuote		q;
	data_urll_tl	list;
	data_urll_t		newurll;
	data_urll_t		oldurll;

	::my_strfit( oldurll.urll_name, sizeof( oldurll.urll_name ), cgi.Arg( "old_urll_name" ) );
	::my_strfit( oldurll.urll_type, sizeof( oldurll.urll_type ), cgi.Arg( "old_urll_type" ) );
	::my_strfit( oldurll.urll_addr, sizeof( oldurll.urll_addr ), cgi.Arg( "old_urll_addr" ) );
	::my_strfit( oldurll.urll_ftyp, sizeof( oldurll.urll_ftyp ), cgi.Arg( "old_urll_ftyp" ) );
	oldurll.urll_user = ::atol( cgi.Arg( "old_urll_user" ) );
	::my_strfit( oldurll.urll_text, sizeof( oldurll.urll_text ), cgi.Arg( "old_urll_text" ) );

	::my_strfit( newurll.urll_name, sizeof( newurll.urll_name ), cgi.Arg( "urll_name" ) );
	::my_strfit( newurll.urll_type, sizeof( newurll.urll_type ), cgi.Arg( "urll_type" ) );
	::my_strfit( newurll.urll_addr, sizeof( newurll.urll_addr ), cgi.Arg( "urll_addr" ) );
	::my_strfit( newurll.urll_ftyp, sizeof( newurll.urll_ftyp ), cgi.Arg( "urll_ftyp" ) );
	newurll.urll_user = ::atol( cgi.Arg( "urll_user" ) );
	::my_strfit( newurll.urll_text, sizeof( newurll.urll_text ), cgi.Arg( "urll_text" ) );

	// If not superuser, we must check for ownership
	if	( (logndata.user_flag & FLAG_SUPERUSER) == 0 ) {
		if	( ( oldurll.urll_user != userid ) ||
			  ( newurll.urll_user != userid ) ) {
			return;
		}
	}

	urlldata = newurll;
	if	( ! __editable() ) {
		return;
	}

	urlldata = oldurll;
	if	( ! __editable() ) {
		return;
	}

	// Editing key fields ?
	if	( ( ::strcmp( oldurll.urll_name, newurll.urll_name ) ) ||
		  ( ::strcmp( oldurll.urll_type, newurll.urll_type ) ) ||
		  ( ::strcmp( oldurll.urll_addr, newurll.urll_addr ) ) ) {
		w << "urll_name='" << q.Quote( newurll.urll_name ) << "' and ";
		w << "urll_type='" << q.Quote( newurll.urll_type ) << "' and ";
		w << "urll_addr='" << q.Quote( newurll.urll_addr ) << "'";
	
		list = urll.Select( db, w );
		if	( list.size() > 0 ) {
			return;
		}
	}

	// Make the change
	urll.Delete( db, &oldurll );
	urll.Delete( db, &newurll );
	urll.Insert( db, &newurll );
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );
	try	{
		__read_types();

		CSession	session(	cgi, 
								"tmpl-linkadmin-logn",
								cgi.Arg("forw"),
								"./regsaves",
								saveargs );

		if	( session.Check() ) {

			// --------------------------------------------------------
			// First we make a copy of the logged in user record
			// --------------------------------------------------------
			logndata = session.UserData();

			// --------------------------------------------------------
			// Also, collect other useful information of the session
			// --------------------------------------------------------
			userid	= session.User();
			sessid	= session.SessId();

			// --------------------------------------------------------
			// What should we do ?
			// --------------------------------------------------------
			taskid = ::atol( cgi.Arg( "task" ) );

			switch	( taskid ) {
				case	2:	// Output the edit form for editing an existing link
				taskid = 21;
				__edit_link_form();
				break;

				case	3:	// Remove the given entry
				__remove_link();
				__linklist();
				break;

				case	4:	// Give edit for for adding a new link - redirect
				urlldata.urll_user = userid;
				taskid = 41;
				__output_link_form();
				break;

				case	21:	// Update an old link
				__update_old_link();
				__edit_link_form();
				break;

				case	41:	// Adding a new link to database
				__add_new_link();
				__edit_link_form();
				break;

				default:	// Give the visitor a list of authors - see if needs redirection
				__linklist();
				break;
			}
		}
    }

	catch	( CError e ) {
		::HTTP_text( "en" );
		::printf( "ERROR: %s", e.Error() );
	}

    catch   ( ... ) {
		::HTTP_text( "en" );
		::printf( "Failed to execute administering program" );
    }

    return	0;
}

// --------------------------------------------------------------------
// EOF: LinkAdmin.cxx
// --------------------------------------------------------------------
