// --------------------------------------------------------------------
// MakeStorageDirs.cxx
// Whatis:  Creates the storage directories as stated in the database
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 02-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CTablePref.hxx"

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	int		result = 0;

	try	{
		CMySqlConnect   db( "quest", NULL, "UTCMS" );
		CMySqlWhere		w;
		CTablePref		pref;
		data_pref_tl	list;
		data_pref_tli	loop;
		char			chmbuf[1024];

		// ------------------------------------------------------------
		// Select all storage entries
		// ------------------------------------------------------------
		w << "pref_name >= 'storage000' AND pref_name <= 'storage999'";
		list = pref.Select( db, w );

		// ------------------------------------------------------------
		// Loop them through creating as needed
		// ------------------------------------------------------------
		for	( loop = list.begin(); loop != list.end(); loop++ ) {
			::printf( "\rDirectory: %s   ", (*loop).pref_valu );
	    	::mkdir( (*loop).pref_valu, 0775 );
			::sprintf( chmbuf, "chgrp www \"%s\"", (*loop).pref_valu );
			::system( chmbuf );
		}
		::printf( "\n" );
    }

    catch   ( CError e ) {
		::printf( "MakeStorageDirs: ERROR: %s\n", e.Error() );
        result = -1;
    }

    catch   ( ... ) {
		::printf( "MakeStorageDirs: ERROR: Abort\n" );
        result = -1;
    }

    return  result;
}

// --------------------------------------------------------------------
// EOF: MakeStorageDirs.cxx
// --------------------------------------------------------------------
