// --------------------------------------------------------------------
// Menu.cxx
// Whatis:  Creates a menu depending on arguments
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 02-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CCgiArgs.hxx"
#include    "CMySqlWhere.hxx"
#include    "CTableMenu.hxx"
#include    "CSession.hxx"
#include	"CTablePref.hxx"

// --------------------------------------------------------------------
// local:	Some local data
// --------------------------------------------------------------------
static	CCgiArgs		cgi;
static	CMySqlConnect	db			( "quest", "", "UTCMS" );
static	bool			haslogout	= false;
static	CTableMenu		menu;
static	CTablePref		pref;

// --------------------------------------------------------------------
// local:	Generate the css from template and the color scheme
// --------------------------------------------------------------------
static	void	__colorscheme	( const char * aCs ) {
	data_pref_tl	data;
	data = pref.Select( db, " where pref_name='default-css'" );
	if	( data.size() < 1 ) {
		throw CError( "Preference not found", "default-css" );
	}

	char *	tmpl = ::my_load_file( (*(data.begin())).pref_valu );
	char *	tp	 = tmpl;
	char	colo[COLOR_SCHEME_COLORS][8];
	dword_t	tbs	 = 0;

	try	{
		// Extract the colors from the color scheme
		int		i;
		for	( i = 0; i < COLOR_SCHEME_COLORS; i++ ) {
			colo[i][0]	= '#';
			colo[i][1]	= aCs[0];
			colo[i][2]	= aCs[0];
			colo[i][3]	= aCs[1];
			colo[i][4]	= aCs[1];
			colo[i][5]	= aCs[2];
			colo[i][6]	= aCs[2];
			colo[i][7]	= 0;
			aCs += 3;
		}

		// The last thing in the string is the text base size
		tbs = ::atol( aCs );
		if	( tbs < 8 )		tbs = 8;
		if	( tbs > 16 )	tbs = 16;

		while	( *tp ) {
			if	( *tp == '#' ) {
				if	( (tp[1]) && (tp[2]) ) {
					word_t	cidx;
					
					cidx = 10   * ((tp[1] - '0') & 0x0f);
					cidx = cidx + ((tp[2] - '0') & 0x0f);
					if	( cidx < 1 )	cidx = 0;
					if	( cidx >= COLOR_SCHEME_COLORS )	cidx = COLOR_SCHEME_COLORS - 1;
					::printf( "%s", colo[cidx] );
					tp += 3;
				}
				else {
					putchar( *(tp++) );
				}
			}
			else if	( *tp == '$' ) {
				if	( tp[1] ) {
					switch	( tp[1] ) {
						case	's':
						::printf( "%d", tbs - 2 );
						break;

						case	'b':
						::printf( "%d", tbs + 2 );
						break;

						case	'h':
						::printf( "%d", tbs * 2 );
						break;

						case	'n':
						::printf( "%d", tbs );
						break;
					}
					tp += 2;
				}
				else {
					putchar( *(tp++) );
				}
			}
			else {
				putchar( *(tp++) );
			}
		}

		delete [] tmpl;
	}

	catch	( ... ) {
		if	( tmpl )	delete [] tmpl;
		throw;
	}
}

// --------------------------------------------------------------------
// local:	Generate default colorscheme
// --------------------------------------------------------------------
static	void	__default_colorscheme	( void ) {
	data_pref_tl	data;

	data = pref.Select( db, " where pref_name='default-colors'" );
	if	( data.size() < 1 ) {
		throw CError( "Preference not found", "default-colors" );
	}

	__colorscheme( (*(data.begin())).pref_valu );
}

// --------------------------------------------------------------------
// local:	Generate user colorscheme
// --------------------------------------------------------------------
static	void	__user_colorscheme	( const char *	aCs ) {
	if	( *aCs == 0 ) {
		__default_colorscheme();
	}
	else {
		__colorscheme( aCs );
	}
}

// --------------------------------------------------------------------
// local:	Generate one table column entry
// --------------------------------------------------------------------
static	void	__menu_col( const data_menu_t & 	aMenu,
							bool					aSelect,
							dword_t					aPerc ) {
	const char * cssclass = aSelect ? aMenu.menu_onst : aMenu.menu_ofst;
	::printf( "\t\t<td class=\"%std\" width=\"%d%%\" nowrap>", cssclass, aPerc );
	::printf( "<a href=\"%s\" class=\"%s\" title=\"%s\">", aMenu.menu_link, cssclass, aMenu.menu_titl );
	::HTML_quote( aMenu.menu_text );
	::printf( "</a></td>\n" );
}

// --------------------------------------------------------------------
// local:	Output a link row
// --------------------------------------------------------------------
static	void	__menu_linkrow	( 	const data_menu_tl &	aMenu,
									dword_t					aSelId,
									bool					aLoggedIn ) {
	if	( aMenu.size() > 0 ) {
		data_menu_tlci	loop;
		dword_t			perc = 100 / aMenu.size();
	
		// Start by setting up the table
		::printf( "<table width=\"100%%\" class=\"default\">\n" );
		::printf( "\t<tr>\n" );
	
		// Login/Logout button ?
		if	( ! haslogout ) {
			data_menu_tl	data;
			if		( aLoggedIn )	data = menu.Select( db, " where menu_name='menulogout'" );
			else					data = menu.Select( db, " where menu_name='menulogin'" );
			perc = 100 / ( aMenu.size() + 1 );
			__menu_col( *(data.begin()), false, perc );
			haslogout = true;
		}

		// Generate entry for each link in the list
		for	( loop = aMenu.begin(); loop != aMenu.end(); loop++ ) {
			__menu_col( *loop, (*loop).menu_ordr == aSelId, perc );
		}
	
		// Terminate the table
		::printf( "\t</tr>\n</table>" );
	}
}

// --------------------------------------------------------------------
// local:	Output a title row
// --------------------------------------------------------------------
static	void	__menu_titlerow	(	const data_menu_t &		aMenu ) {

	if	( aMenu.menu_ttst[0] != 0 ) {
		// Start by setting up the table
		::printf( 	"<table width=\"100%%\" class=\"default\">\n" );
		::printf(	"\t<tr>\n" );

		// The row
		::printf(	"\t\t<td align=\"center\" class=\"%s\" nowrap><span class=\"%s\">",
					aMenu.menu_ttst,
					aMenu.menu_ttst );

		::HTML_quote( aMenu.menu_titl );
	
		// Termination
		::printf(	"</span></td>\n\t</tr>\n</table>" );
	}
}

// --------------------------------------------------------------------
// local:	Generate the menu - this is a recursive function so watch out !
// --------------------------------------------------------------------
static	void	__menu_menu	(	const char *	aName,
								dword_t			aSelId,
								bool			aParent,
								bool			aLoggedIn ) {
	data_menu_tl	list;
	bool			hasparent;
	data_menu_t		parent;
	CMySqlWhere		w;
	CMySqlQuote		q;

	// Get my own entry first - use the #1 entry in case the SelId was zero
	w = "";
	w << "menu_name='" << q.Quote( aName ) << "' and menu_ordr=" << (dword_t)( aSelId ? aSelId : 1);
	list = menu.Select( db, w );

	// No such entry ???? Yikes !
	if	( list.size() < 1 ) {
		throw CError( w.Where(), "Menu entry not found" );
	}

	// Do we propably have a parent ?
	hasparent = ( (*(list.begin())).menu_pord > 0 );
	if	( hasparent ) {
		__menu_menu( (*(list.begin())).menu_pnam, (*(list.begin())).menu_pord, true, aLoggedIn );

		// Do we need the parent data in the future ?
		if	( ! aParent ) {
			// We have two options here - if there was a select
			// we use the selected one, else the banner is from parent
			if	( aSelId == 0 ) {
				w = "";
				w << "menu_name='" << q.Quote( (*(list.begin())).menu_pnam ) << "' and menu_ordr=" << (*(list.begin())).menu_pord;
				list = menu.Select( db, w );
			}
			parent = *(list.begin());
		}
	}

	// Now, get all my menu items
	w = "";
	w << "menu_name='" << q.Quote( aName ) << "' order by menu_ordr";
	list = menu.Select( db, w );

	// And output them
	__menu_linkrow( list, aSelId, aLoggedIn );

	// Skip banner for parents and nonselects
	if	( ( ! aParent ) && ( hasparent ) )	__menu_titlerow( parent );
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );
	::HTTP_text( "en" );

	try	{
		// If this guy was logged in - he just might have a color scheme
		// If he is with color scheme we use it alse we use the default
		CSession	session( cgi );
		::printf( "<!-- start menu -->" );
		if	( session.Check() ) {
			__user_colorscheme( session.UserData().user_colo );
		}
		else {
			__default_colorscheme();
		}
		__menu_menu( cgi.Arg( "menu" ), ::atol( cgi.Arg( "item" ) ), false, session.Check() );
		::printf( "<!-- end menu -->" );
    }
    catch   ( CError e ) {
    	::printf( "ERROR : %s", e.Error() );
    }
    catch	( ... ) {
    	::printf( "ERROR : unknown" );
    }
    ::fflush( stdout );
	::fclose( stdout );
	return	0;
}

// --------------------------------------------------------------------
// EOF: Motd.cxx
// --------------------------------------------------------------------
