// --------------------------------------------------------------------
// PackAdmin.cxx
// Whatis:  CGI for administering teh files
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 28-SEP-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CSession.hxx"
#include	"CCgiArgs.hxx"
#include	"CAuthor.hxx"
#include	"CMySqlWhere.hxx"
#include	"CStorage.hxx"
#include	"CTablePack.hxx"
#include	"CTableFile.hxx"
#include	"CTablePackFile.hxx"
#include	"CPreviewTemplate.hxx"

// --------------------------------------------------------------------
// local:	Save argument name list
// --------------------------------------------------------------------
static	const char *	saveargs[] = {
	"page", "forw", "task",
	"find_pack_name", "find_pack_file",
	"idnt0",	"sel0",		"file0",	"name0",
	"idnt1",	"sel1",		"file1",	"name1",
	"idnt2",	"sel2",		"file2",	"name2",
	"idnt3",	"sel3",		"file3",	"name3",
	"idnt4",	"sel4",		"file4",	"name4",
	"idnt5",	"sel5",		"file5",	"name5",
	"idnt6",	"sel6",		"file6",	"name6",
	"idnt7",	"sel7",		"file7",	"name7",
	"idnt8",	"sel8",		"file8",	"name8",
	"idnt9",	"sel9",		"file9",	"name9",
	"idnt10",	"sel10",	"file10",	"name10",
	"idnt11",	"sel11",	"file11",	"name11",
	"idnt12",	"sel12",	"file12",	"name12",
	"idnt13",	"sel13",	"file13",	"name13",
	"idnt14",	"sel14",	"file14",	"name14",
	"idnt15",	"sel15",	"file15",	"name15",
	"idnt16",	"sel16",	"file16",	"name16",
	"idnt17",	"sel17",	"file17",	"name17",
	"idnt18",	"sel18",	"file18",	"name18",
	"idnt19",	"sel19",	"file19",	"name19",

	NULL
};


// --------------------------------------------------------------------
// local:	The CGI arguments
// --------------------------------------------------------------------
static	CCgiArgs			cgi;
static	CMySqlConnect		db			( "quest", "", "UTCMS" );
static	CPreviewTemplate	previewtemplate;
static	dword_t				userid		= 0;
static	dword_t				sessid		= 0;
static	dword_t				pagenow		= 0;
static	dword_t				lastpage	= 0;
static	dword_t				rownumber	= 0;
static	dword_t				filecount	= 0;
static	const char *		message		= NULL;

// --------------------------------------------------------------------
// local:	Some database tables needed
// --------------------------------------------------------------------
static	CTablePack			pack;
static	CTableFile			file;
static	CTablePackFile		packfile;
static	CTableUser			user;

// --------------------------------------------------------------------
// local:	Data associated with those tables
// --------------------------------------------------------------------
static	data_user_t		logndata		= { 0 };
static	data_pack_t		packdata		= { 0 };

// --------------------------------------------------------------------
// local:	Parser questions are sent here for answering
// --------------------------------------------------------------------
static	void	__answer	( const char * aQ ) {

	// ----------------------------------------------------------------
	// Local parsing
	// ----------------------------------------------------------------
	if		( ! ::strcmp( aQ, "sessid" ) )			::printf( "%d", sessid );
	else if	( ! ::strcmp( aQ, "userid" ) )			::printf( "%d", userid );
	else if	( ! ::strcmp( aQ, "pagenow" ) )			::printf( "%d", pagenow );
	else if	( ! ::strcmp( aQ, "nextpage" ) )		::printf( "%d", pagenow + 1 );
	else if	( ! ::strcmp( aQ, "prevpage" ) )		::printf( "%d", pagenow - 1 );
	else if	( ! ::strcmp( aQ, "lastpage" ) )		::printf( "%d", lastpage );
	else if	( ! ::strcmp( aQ, "rownumber" ) )		::printf( "%d", rownumber );
	else if	( ! ::strcmp( aQ, "filecount" ) )		::printf( "%d", filecount );
	else if	( ! ::strcmp( aQ, "linepair" ) )		::printf( "%d", rownumber & 0x01 );

	else if	( ! ::strcmp( aQ, "message_b" ) )		::printf( "%s", message ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "message_e" ) )		::printf( "%s", message ? "" : " -->" );
	else if	( ! ::strcmp( aQ, "message" ) )			::printf( "%s", message ? message : "" );


	// ----------------------------------------------------------------
	// Paging
	// ----------------------------------------------------------------
	else if	( ! ::strcmp( aQ, "pagenext_b" ) )		::printf( "%s", pagenow < lastpage ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pagenext_e" ) )		::printf( "%s", pagenow < lastpage ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "pagenext_bx" ) )		::printf( "%s", pagenow >= lastpage ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pagenext_ex" ) )		::printf( "%s", pagenow >= lastpage ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "pageprev_b" ) )		::printf( "%s", pagenow > 1 ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pageprev_e" ) )		::printf( "%s", pagenow > 1 ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "pageprev_bx" ) )		::printf( "%s", pagenow <= 1 ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pageprev_ex" ) )		::printf( "%s", pagenow <= 1 ? "" : " -->" );

	// ----------------------------------------------------------------
	// Parsing table data
	// ----------------------------------------------------------------
	else if	( ::MySqlTableParser( pack.Layout(), "pack", (const char *)(&packdata), aQ ) )	;

	// ----------------------------------------------------------------
	// Parsing the CGI data
	// ----------------------------------------------------------------
	else if	( ::cgi_parser( cgi, aQ ) )	;

	// ----------------------------------------------------------------
	// Everything else goes to default parser
	// ----------------------------------------------------------------
	else	::my_default_answer( aQ );
}

// --------------------------------------------------------------------
// public:  List the packages here
// --------------------------------------------------------------------
static	void	__packlist	( void ) {
	CMySqlWhere		w;
	CMySqlQuote		q;
	data_pack_tl	list;
	data_pack_tli	loop;
	bool			useand = false;

	// The page
	pagenow	= ::atol( cgi.Arg( "page" ) );
	if	( pagenow < 1 ) {
		cgi.Arg( "page", "1" );
		pagenow = 1;
	}

	// Filtering
	if	( cgi.Arg( "find_pack_name" )[0] != 0 ) {
		w << "pack_name like '" << q.Quote( cgi.Arg( "find_pack_name" ) ) << "%'";
		useand = true;
	}
	if	( cgi.Arg( "find_pack_file" )[0] != 0 ) {
		if	( useand )	w << " and ";
		w << "pack_file like '" << q.Quote( cgi.Arg( "find_pack_file" ) ) << "%'";
		useand = true;
	}
	if	( ! useand ) {
		w << "pack_idnt>0";
	}

	lastpage = pack.Count( db, w ) / 20 + 1;
	if	( pagenow > lastpage ) pagenow = lastpage;

	w << " order by pack_atim desc LIMIT "
	  << (dword_t)((pagenow-1) * 20)
	  << ",20";

	list = pack.Select( db, w );

	rownumber = 0;
	previewtemplate.Execute( __answer, "tmpl-packadmin-list-head" );
	for	( loop = list.begin(); loop != list.end(); loop++ ) {
		packdata = *loop;

		w = "";
		w << "packfile_pack=" << packdata.pack_idnt;
		filecount = packfile.Count( db, w );

		previewtemplate.Execute( __answer, "tmpl-packadmin-list-body" );
		rownumber++;
	}
	previewtemplate.Execute( __answer, "tmpl-packadmin-list-tail" );
}

// --------------------------------------------------------------------
// local:	Is this row selected ?
// --------------------------------------------------------------------
static	bool			__is_selected		( dword_t aRow ) {
	char			argnm[32];
	::sprintf( argnm, "sel%d", aRow );
	return	cgi.Exist( argnm );
}

// --------------------------------------------------------------------
// local:	Get a string value
// --------------------------------------------------------------------
static	char *			__get_string		( 	char *			aB,
												size_t			aL,
												const char *	aBase,
												dword_t			aRow ) {
	char	argnm[32];
	::sprintf( argnm, "%s%d", aBase, aRow );
	::memset( aB, 0, aL );
	::my_strfit( aB, aL, cgi.Arg( argnm ) );

	return	aB;
}

// --------------------------------------------------------------------
// local:	Get old record
// --------------------------------------------------------------------
static	data_pack_t		__get_old_record	( dword_t aRow ) {
	data_pack_t		data;
	char			buf	[32];
	CMySqlWhere		w;

	w << "pack_idnt=" << (dword_t)::atol( __get_string( buf, sizeof( buf ), "idnt", aRow ) );
	if	( pack.Count( db, w ) == 1 ) {
		data = *( pack.Select( db, w ).begin() );
	}
	else {
		::memset( &data, 0, sizeof( data ) );
	}

	return	data;
}

// --------------------------------------------------------------------
// local:	Get new record
// --------------------------------------------------------------------
static	data_pack_t		__get_new_record	( dword_t aRow ) {
	data_pack_t		data	= __get_old_record( aRow );

	__get_string( data.pack_name, sizeof( data.pack_name ), "name", aRow );
	__get_string( data.pack_file, sizeof( data.pack_file ), "file", aRow );

	return	data;
}

// --------------------------------------------------------------------
// local:	Is a file in a list ?
// --------------------------------------------------------------------
static	bool			__is_in_list		(	data_file_tl &	aList,
												data_file_t &	aData ) {
	data_file_tli	loop;
	for	( loop = aList.begin(); loop != aList.end(); loop++ ) {
		if	( aData.file_idnt == (*loop).file_idnt )	return true;
	}
	return	false;
}


// --------------------------------------------------------------------
// local:	Combine one file
// --------------------------------------------------------------------
static	void			__combine_file		(	data_file_tl &	aAddfList,
												data_file_t		aData ) {
	if		( __is_in_list( aAddfList, aData ) )	return;
	else {
		data_file_tli	loop;

		// Go through all file searching for identical file
		for	( loop = aAddfList.begin(); loop != aAddfList.end(); loop++ ) {
			// Different file name
			if	( ::my_stricmp( aData.file_name, (*loop).file_name ) )	continue;

			// Different file suffix
			if	( ::my_stricmp( aData.file_suff, (*loop).file_suff ) )	continue;

			// Which is newer ?
			if	( aData.file_ctim > (*loop).file_ctim ) {
				aAddfList.erase( loop );
				aAddfList.push_back( aData );
			}
			return;
		}

		// Oookay - the file was not in any list in any form
		aAddfList.push_back( aData );
	}
}

// --------------------------------------------------------------------
// local:	Combine pack files into common list
// --------------------------------------------------------------------
static	void			__combine_packfiles	(	data_file_tl &	aAddfList,
												data_pack_t &	aPack ) {
	data_packfile_tl	packfilelist;
	data_packfile_tli	packfileloop;
	CMySqlWhere			w;

	w << "packfile_pack=" << aPack.pack_idnt;
	packfilelist = packfile.Select( db, w );
	for	( packfileloop = packfilelist.begin(); packfileloop != packfilelist.end(); packfileloop++ ) {
		w = "";
		w << "file_idnt=" << (*packfileloop).packfile_file;
		if	( file.Count( db, w ) == 1 ) {
			__combine_file( aAddfList, *( file.Select( db, w ).begin() ) );
		}
	}
}

// --------------------------------------------------------------------
// local:	Erase a package
// --------------------------------------------------------------------
static	void	__remove_pack	( dword_t aPack ) {
	CStorage			storage;
	CMySqlWhere			w;
	data_packfile_tl	packfilelist;
	data_packfile_tli	packfileloop;
	data_file_tl		list;

	w = "";
	w << "packfile_pack=" << aPack;
	packfilelist = packfile.Select( db, w );

	for	( packfileloop = packfilelist.begin(); packfileloop != packfilelist.end(); packfileloop++ ) {
		w = "";
		w << "packfile_file=" << (*packfileloop).packfile_file;
		dword_t	count = packfile.Count( db, w );
		w = "";
		w << "file_idnt=" << (*packfileloop).packfile_file;
		if		( count == 1 ) {
			list = file.Select( db, w );
			if	( list.size() > 0 ) {
				storage.Delete( (*(list.begin())).file_idnt );
			}
		}
		else if	( count > 1 ) {
			list = file.Select( db, w );
			if	( list.size() > 0 ) {
				w = "";
				w << "packfile_pack=" << aPack << " and ";
				w << "packfile_file=" << (*(list.begin())).file_idnt;
				packfile.Delete( db, w );
			}
		}
	}
	w = "";
	w << "pack_idnt='" << aPack << "'";
	pack.Delete( db, w );
}

// --------------------------------------------------------------------
// local:	Update the selected packages
// --------------------------------------------------------------------
static	void	__packupdate	( void ) {
	data_pack_t		olddata;
	data_pack_t		newdata;
	dword_t			rowid;
	bool			updated = false;

	for	( rowid = 0; rowid < 20; rowid++ ) {
		if	( __is_selected( rowid ) ) {
			olddata = __get_old_record( rowid );
			newdata = __get_new_record( rowid );

			// Was something changed ?
			if	( ( ::strcmp( newdata.pack_file, olddata.pack_file ) ) ||
				  ( ::strcmp( newdata.pack_name, olddata.pack_name ) ) ) {

				pack.Delete( db, &olddata );
				pack.Delete( db, &newdata );
				pack.Insert( db, &newdata );
				updated = true;
			}
		}
	}

	if	( updated )	message = "Selected rows were updated";
	else			message = "<b>Nothing was updated</b>";
	__packlist();
}

// --------------------------------------------------------------------
// local:	Combine the selected packages
// --------------------------------------------------------------------
static	void	__packcombine	( void ) {
	data_pack_tl	packlist;
	data_pack_tli	packloop;
	data_file_tl	filelist;
	data_file_tli	fileloop;
	dword_t			rowid;
	data_pack_t		newpack;
	data_packfile_t	newpackfile;


	// List all packages involved here
	for	( rowid=0; rowid < 20; rowid++ ) {
		if	( __is_selected( rowid ) ) {
			packlist.push_back( __get_old_record( rowid ) );
		}
	}

	// So, we have more than one and we can start combining these
	if	( packlist.size() > 1 ) {

		// Collect all files into our file lists - combine
		for	( packloop = packlist.begin(); packloop != packlist.end(); packloop++ ) {
			__combine_packfiles( filelist, *packloop );
		}

		// Create an entirely new package using the first pack as base
		newpack = *(packlist.begin());
		newpack.pack_idnt = pack.NextIdnt( db );
		pack.Insert( db, &newpack );

		// Add records to the packfile table
		for	( fileloop = filelist.begin(); fileloop != filelist.end(); fileloop++ ) {
			newpackfile.packfile_file = (*fileloop).file_idnt;
			newpackfile.packfile_pack = newpack.pack_idnt;			
			packfile.Insert( db, &newpackfile );
		}

		// Using the original list remove the packages
		for	( packloop = packlist.begin(); packloop != packlist.end(); packloop++ ) {
			__remove_pack( (*packloop).pack_idnt );
		}
		message = "The packs were combined into one";
	}
	else {
		message = "<b>Nothing combined - too few packs selected</b>";
	}

	__packlist();
}

// --------------------------------------------------------------------
// local:	Delete the selected packages
// --------------------------------------------------------------------
static	void	__packdelete	( void ) {
	dword_t			rowid;
	bool			updated = false;

	for	( rowid=0; rowid < 20; rowid++ ) {
		if	( __is_selected( rowid ) ) {
			data_pack_t	rempack = __get_old_record( rowid );
			__remove_pack( rempack.pack_idnt );
			updated = true;
		}
	}

	if	( updated ) {
		message = "The packs were removed";
	}
	else {
		message = "<b>Nothing was removed</b>";
	}
	__packlist();
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );
	try	{
		CSession	session(	cgi, 
								"tmpl-packadmin-logn",
								cgi.Arg("forw"),
								"./regsaves",
								saveargs );

		if	( session.Check() ) {

			// --------------------------------------------------------
			// First we make a copy of the logged in user record
			// --------------------------------------------------------
			logndata = session.UserData();

			// --------------------------------------------------------
			// Only superuser can log in here
			// --------------------------------------------------------
			if	( (logndata.user_flag & FLAG_SUPERUSER) == 0 ) {
				throw	CError( "You are not a superuser" );
			}

			// --------------------------------------------------------
			// Also, collect other useful information of the session
			// --------------------------------------------------------
			userid	= session.User();
			sessid	= session.SessId();

			switch	( ::atol( cgi.Arg( "task" ) ) ) {

				case	0:	// List
				::HTTP_text( "en" );
				__packlist();
				break;

				case	1:	// Combine
				::HTTP_text( "en" );
				__packcombine();
				break;

				case	2:	// Update
				::HTTP_text( "en" );
				__packupdate();
				break;

				case	3:	// Delete
				::HTTP_text( "en" );
				__packdelete();
				break;
			}
		}
    }

	catch	( CError e ) {
		::HTTP_text( "en" );
		::printf( "ERROR: %s", e.Error() );
	}

    catch   ( ... ) {
		::HTTP_text( "en" );
		::printf( "Failed to execute administering program" );
    }

    return	0;
}

// --------------------------------------------------------------------
// EOF: PackAdmin.cxx
// --------------------------------------------------------------------
