// --------------------------------------------------------------------
// PreviewAssBriefings.cxx
// Whatis:  CGI for previewing screen shots of a given file
// CGI arguments:
//	file_idnt	File identifier in database
//
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 14-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CPreviewFile.hxx"
#include    "CPreviewAssaultShots.hxx"
#include    "CPreviewTemplate.hxx"
#include    "CPreviewLeafMenu.hxx"
#include	"CCgiArgs.hxx"
#include	"CSpam.hxx"

// --------------------------------------------------------------------
// local:	The local data
// --------------------------------------------------------------------
static	CCgiArgs					cgi;
static	CPreviewFile				previewfile;
static	CPreviewAssaultShots		previewshots;
static	CPreviewTemplate			previewtemplate;
static	CPreviewLeafMenu			previewleafmenu;
static	dword_t						shotnow = 0;

// --------------------------------------------------------------------
// local:	Parser questions are sent here for answering
// --------------------------------------------------------------------
static	void	__answer	( const char * aQ ) {

	// ----------------------------------------------------------------
	// Parsing preview file
	// ----------------------------------------------------------------
	if		( previewfile.Answer( aQ ) )		;
	else if	( previewshots.Answer( aQ ) )		;
	else if	( previewleafmenu.Answer( aQ ) )	;
	else if	( ! ::strcmp( aQ, "linepair" ) )	::printf( "%d", shotnow & 1 );

	// ----------------------------------------------------------------
	// Parsing the CGI data
	// ----------------------------------------------------------------
	else if	( ::cgi_parser( cgi, aQ ) )	;

	// ----------------------------------------------------------------
	// Everything else goes to default parser
	// ----------------------------------------------------------------
	else	::my_default_answer( aQ );
}

// --------------------------------------------------------------------
// local:	Prevent spam
// --------------------------------------------------------------------
static	bool	__spam	( void ) {
	bool	is_spam	= false;

	try	{
		CSpam	myspam1( cgi.Arg( CGI_REMOTE_ADDR ), cgi.Arg( CGI_QUERY_STRING ), 1 );
	}

	catch	( CError e ) {
		is_spam = true;
	}

	return	is_spam;
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );
	::HTTP_text( "en" );
	bool	noassault = false;

	try	{
		if	( __spam() ) {
			previewtemplate.Execute( __answer, "tmpl-spam-warning" );
			::fflush( stdout );
			::fclose( stdout );
			return	-1;
		}

		// Load the file we are going to preview
		previewfile.Load( ::atol( cgi.Arg( "file_idnt" ) ) );

		// Load the screenshots
		try	{
			previewshots.Load(	previewfile.FilePath(), ::atol( cgi.Arg( "file_idnt" ) ), 0 );
		}
		catch ( ... ) {
			noassault = true;
		}

		// Set up the leaf menu
		previewleafmenu.Load( ::atol( cgi.Arg( "file_idnt" ) ), LEAFMENU_ASSBRIEFINGS );
		previewtemplate.Execute( __answer, "tmpl-prv-head" );		// Top of the form

		if	( ( noassault ) || ( previewshots.ShotCount() == 0 ) ) {
			previewtemplate.Execute( __answer, "tmpl-prv-ashot-nosh" );
		}
		else {
			previewtemplate.Execute( __answer, "tmpl-prv-ashot-head" );	// Top of the form
	
			for	( shotnow = 0; shotnow < previewshots.ShotCount(); shotnow++ ) {
				previewshots.ShotIdx( shotnow );
				previewtemplate.Execute( __answer, "tmpl-prv-ashot-body" );
			}
			previewtemplate.Execute( __answer, "tmpl-prv-ashot-tail" );	// End of images
		}

		previewtemplate.Execute( __answer, "tmpl-prv-tail" );		// End of story
	}

	catch 	( CError e ) {
		::printf( "PreviewAssBriefings : Error : " );
		::HTML_quote( e.Error() );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}

	catch	( ... ) {
		::printf( "PreviewAssBriefings : Error: Unknown error" );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}
	::fflush( stdout );
	::fclose( stdout );
    return	0;
}

// --------------------------------------------------------------------
// EOF: PreviewAssBriefings.cxx
// --------------------------------------------------------------------
