// --------------------------------------------------------------------
// PreviewImportList.cxx
// Whatis:  CGI for previewing upackage info of a given file
// CGI arguments:
//	file_idnt	File identifier in database
//
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 14-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CPreviewFile.hxx"
#include    "CPreviewTemplate.hxx"
#include    "CPreviewLeafMenu.hxx"
#include	"CCgiArgs.hxx"
#include    "CTableFile.hxx"
#include    "CTableXref.hxx"
#include	"CSpam.hxx"

// --------------------------------------------------------------------
// local:	The local data
// --------------------------------------------------------------------
static	CCgiArgs			cgi;
static	CPreviewFile		previewfile;
static	CPreviewTemplate	previewtemplate;
static	CPreviewLeafMenu	previewleafmenu;
static	CMySqlConnect		db			( "quest", "", "UTCMS" );

static	CTableFile			file;
static	CTableXref			xref;
static	data_xref_t			xrefdata	= { 0 };
static	bool				anydl		= false;
static	dword_t				xcolnumber	= 0;
static	dword_t				xrownumber	= 0;

// --------------------------------------------------------------------
// local:	Parser questions are sent here for answering
// --------------------------------------------------------------------
static	void	__answer	( const char * aQ ) {

	// ----------------------------------------------------------------
	// Parsing preview file
	// ----------------------------------------------------------------
	if		( previewfile.Answer( aQ ) )		;
	else if	( previewleafmenu.Answer( aQ ) )	;

	else if	( ::MySqlTableParser( xref.Layout(), "xref", (const char *)(&xrefdata), aQ ) )	;
	else if	( ! ::strcmp( aQ, "xrownumber" ) )		::printf( "%d", xrownumber );
	else if	( ! ::strcmp( aQ, "xcolnumber" ) )		::printf( "%d", xcolnumber );
	else if	( ! ::strcmp( aQ, "anydl_b" ) )			::printf( "%s", anydl ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "anydl_e" ) )			::printf( "%s", anydl ? "" : " -->" );
	else if	( ! ::strcmp( aQ, "anydl_xb" ) )		::printf( "%s", ! anydl ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "anydl_xe" ) )		::printf( "%s", ! anydl ? "" : " -->" );
	else if	( ! ::strcmp( aQ, "linepair" ) )		::printf( "%d", xrownumber & 0x01 );

	// ----------------------------------------------------------------
	// Parsing the CGI data
	// ----------------------------------------------------------------
	else if	( ::cgi_parser( cgi, aQ ) )	;

	// ----------------------------------------------------------------
	// Everything else goes to default parser
	// ----------------------------------------------------------------
	else	::my_default_answer( aQ );
}

// --------------------------------------------------------------------
// local:	Prevent spam
// --------------------------------------------------------------------
static	bool	__spam	( void ) {
	bool	is_spam	= false;

	try	{
		CSpam	myspam1( cgi.Arg( CGI_REMOTE_ADDR ), cgi.Arg( CGI_QUERY_STRING ), 1 );
	}

	catch	( CError e ) {
		is_spam = true;
	}

	return	is_spam;
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );
	::HTTP_text( "en" );

	try	{
		if	( __spam() ) {
			previewtemplate.Execute( __answer, "tmpl-spam-warning" );
			::fflush( stdout );
			::fclose( stdout );
			return	-1;
		}

		previewfile.Load( ::atol( cgi.Arg( "file_idnt" ) ) );
		previewleafmenu.Load( ::atol( cgi.Arg( "file_idnt" ) ), LEAFMENU_IMPORTLIST );

		previewtemplate.Execute( __answer, "tmpl-prv-head" );
		previewtemplate.Execute( __answer, "tmpl-prv-ilist-head" );

		data_xref_tl	xlist;
		data_xref_tli	xloop;
		data_file_tl	flist;
		data_file_tli	floop;
		CMySqlWhere		w;
		CMySqlQuote		q;

		w << "xref_file=" << (dword_t)::atol( cgi.Arg( "file_idnt" ) ) << " and xref_expo=0 order by xref_name";
		xlist = xref.Select( db, w );
		xrownumber = 0;

		for	( xloop = xlist.begin(); xloop != xlist.end(); xloop++ ) {
			xrefdata = *xloop;

			// Get candidates for this import
			w = "";
			w << "file_name='" << q.Quote( (*xloop).xref_name ) << "' and file_typ1='UNR' and ( ";
			w << "file_ctgr='picture' or ";
			w << "file_ctgr='sound' or ";
			w << "file_ctgr='music' or ";
			w << "file_ctgr='model' or ";
			w << "file_ctgr='class' )";

			flist = file.Select( db, w );

			if		( flist.size() == 0 ) {
				previewtemplate.Execute( __answer, "tmpl-prv-ilist-bodx" );
			}

			else if	( flist.size() == 1 ) {
				anydl = ( ((*(flist.begin())).file_flag & FLAG_NODOWNLOAD) == 0 );
				previewfile.Load( (*(flist.begin())).file_idnt, false );
				previewtemplate.Execute( __answer, "tmpl-prv-ilist-body" );
			}
			else if	( flist.size() > 1 ) {
				previewtemplate.Execute( __answer, "tmpl-prv-ilist-bodh" );

				xcolnumber = 0;

				// All packages downloadable ?
				anydl = true;
				for	( floop = flist.begin(); floop != flist.end(); floop++ ) {
					if	( ((*floop).file_flag & FLAG_NODOWNLOAD) != 0 ) {
						anydl = false;
						break;
					}
				}

				for	( floop = flist.begin(); floop != flist.end(); floop++ ) {
					previewfile.Load( (*floop).file_idnt, false );

					previewtemplate.Execute( __answer, "tmpl-prv-ilist-bodb" );
					xcolnumber++;
				}

				previewtemplate.Execute( __answer, "tmpl-prv-ilist-bodt" );
			}
			xrownumber++;
		}

		previewtemplate.Execute( __answer, "tmpl-prv-ilist-tail" );
		previewtemplate.Execute( __answer, "tmpl-prv-tail" );		// End of story
	}

	catch 	( CError e ) {
		::printf( "PreviewImportList : Error : " );
		::HTML_quote( e.Error() );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}

	catch	( ... ) {
		::printf( "PreviewImportList : Error: Unknown error" );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}
	::fflush( stdout );
	::fclose( stdout );
    return	0;
}

// --------------------------------------------------------------------
// EOF: PreviewImportList.cxx
// --------------------------------------------------------------------
