// --------------------------------------------------------------------
// PreviewSOund.cxx
// Whatis:  CGI for previewing textures in files
// CGI arguments:
//
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 14-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CStorage.hxx"
#include    "CTablePref.hxx"
#include	"CPreviewFile.hxx"
#include    "CPreviewTemplate.hxx"
#include    "CPreviewLeafMenu.hxx"
#include	"CCgiArgs.hxx"
#include	"CMySqlWhere.hxx"
#include	"CUnSound.hxx"
#include	"CSpam.hxx"

// --------------------------------------------------------------------
// local:	The local data
// --------------------------------------------------------------------
static	CCgiArgs			cgi;
static	CPreviewFile		previewfile;
static	CPreviewTemplate	previewtemplate;
static	CPreviewLeafMenu	previewleafmenu;

// --------------------------------------------------------------------
static	char				objectname	[128]	= { 0 };
static	char				objecttype	[128]	= { 0 };
static	dword_t				objectsize			= 0;
static	dword_t				objectoffs			= 0;
static	dword_t				objectnum			= 0;
static	dword_t				soundsize			= 0;
static	CUnObjectFlags_t	objectflag;
static	dword_t				rownumber			= 0;
static	char				channels	[128]	= { 0 };
static	char				samplerate	[128]	= { 0 };
static	char				samplebits	[128]	= { 0 };

// --------------------------------------------------------------------
// local:	Parser questions are sent here for answering
// --------------------------------------------------------------------
static	void	__answer	( const char * aQ ) {

	// ----------------------------------------------------------------
	// Local parsing
	// ----------------------------------------------------------------
	if		( ! ::strcmp( aQ, "objectname" ) )	::printf( "%s", objectname );
	else if	( ! ::strcmp( aQ, "objecttype" ) )	::printf( "%s", objecttype );
	else if	( ! ::strcmp( aQ, "objectsize" ) )	::printf( "%d", objectsize );
	else if	( ! ::strcmp( aQ, "objectoffs" ) )	::printf( "%d", objectoffs );
	else if	( ! ::strcmp( aQ, "objectnum" ) )	::printf( "%d", objectnum );
	else if	( ! ::strcmp( aQ, "soundsize" ) )	::printf( "%d", soundsize );
	else if	( ! ::strcmp( aQ, "linepair" ) )	::printf( "%d", rownumber & 0x01 );
	else if	( ! ::strcmp( aQ, "channels" ) )	::printf( "%s", channels );
	else if	( ! ::strcmp( aQ, "samplerate" ) )	::printf( "%s", samplerate );
	else if	( ! ::strcmp( aQ, "samplebits" ) )	::printf( "%s", samplebits );

	else if	( previewfile.Answer( aQ ) )		;
	else if	( previewleafmenu.Answer( aQ ) )	;
	else if	( ::cgi_parser( cgi, aQ ) )	;
	else	::my_default_answer( aQ );
}

// --------------------------------------------------------------------
// local:	Produce list of classes of type "Sound"
// --------------------------------------------------------------------
static	void	__produce_sound_list	( void ) {
	previewtemplate.Execute( __answer, "tmpl-previewsound-head" );

	try {
		CUnFile			f( previewfile.FilePath() );
		CUnNameTable	n( f );
		CUnImportTable	i( f );
		CUnExportTable	e( f );
	
		// Name index for the class we are searching for
		const char *	classname	= cgi.Arg( "class" );
		dword_t			classnmix	= n.Find( classname );
	
		// If the name does not exist - well....
		if	( ! n.Exist( classname ) ) {
			previewtemplate.Execute( __answer, "tmpl-previewsound-none" );
			return;
		}
	
		// Loop through all the entries in the export table
		dword_t		eidx;
	
		for	( eidx = rownumber = 0; eidx < e.Count(); eidx++ ) {
			CUnExport	exp = e.Export( eidx );
	
			// Skip over those who are not of the searched name
			if	( classnmix != i.Import( NAMEIMPORT( exp.Class() ) ).ObjectName() )	continue;
	
			// Some data before parsing starts
			::strcpy( objectname, n.Name( exp.ObjectName() ) );
			objectsize = exp.SerialSize();
			objectoffs = exp.SerialOffset();
			objectflag = exp.Flags();
			objectnum  = eidx;
	
			CUnSound	mysound( f, n, e, i, objectname, false );
			::strcpy( objecttype, mysound.Format() );
			soundsize  = mysound.Size();

			// If this is a WAV sound we fill in some aux info
			if	( ::my_stricmp( objecttype, "WAV" ) ) {
				*channels	= 0;
				*samplerate	= 0;
				*samplebits	= 0;
			}
			else {
				switch	( mysound.WavHead().channels ) {
					case	0x01:	::strcpy( channels, "Mono" );		break;
					case	0x02:	::strcpy( channels, "Stereo" );		break;
					default:		::strcpy( channels, "Unknown" );	break;
				}
				::sprintf( samplerate, "%d/second", mysound.WavHead().samplerate );
				if	( mysound.WavHead().channels > 0 ) {
					::sprintf( samplebits, "%d/channel", mysound.WavHead().samplebits / mysound.WavHead().channels );
				}
			}

	
			previewtemplate.Execute( __answer, "tmpl-previewsound-body" );
			rownumber++;
		}
	
		// Did we find any of those ?
		if	( rownumber == 0 ) {
			previewtemplate.Execute( __answer, "tmpl-previewsound-none" );
		}

	}
	catch ( CError e ) {
		::HTML_quote( e.Error() );
		previewtemplate.Execute( __answer, "tmpl-previewsound-none" );
	}
	catch ( ... ) {
		previewtemplate.Execute( __answer, "tmpl-previewsound-none" );
	}

	// Will embed sound as needed
	previewtemplate.Execute( __answer, "tmpl-previewsound-tail" );
}

// --------------------------------------------------------------------
// local:	Prevent spam
// --------------------------------------------------------------------
static	bool	__spam	( void ) {
	bool	is_spam	= false;

	try	{
		CSpam	myspam1( cgi.Arg( CGI_REMOTE_ADDR ), cgi.Arg( CGI_QUERY_STRING ), 1 );
	}

	catch	( CError e ) {
		is_spam = true;
	}

	return	is_spam;
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );
	::HTTP_text( "en" );

	try	{
		if	( __spam() ) {
			previewtemplate.Execute( __answer, "tmpl-spam-warning" );
			::fflush( stdout );
			::fclose( stdout );
			return	-1;
		}

		// Load the file we are going to preview
		previewfile.Load( ::atol( cgi.Arg( "file_idnt" ) ) );

		// Set up the leaf menu
		previewleafmenu.Load( ::atol( cgi.Arg( "file_idnt" ) ), LEAFMENU_EXPORTLIST );

		previewtemplate.Execute( __answer, "tmpl-prv-head" );

		if		( ! ::my_stricmp( cgi.Arg( "class" ), "sound" ) )	__produce_sound_list();

		previewtemplate.Execute( __answer, "tmpl-prv-tail" );
	}

	catch 	( CError e ) {
		::printf( "Error: " );
		::HTML_quote( e.Error() );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}

	catch	( ... ) {
		::printf( "Error: Unknown error" );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}
	::fflush( stdout );
	::fclose( stdout );
    return	0;
}

// --------------------------------------------------------------------
// EOF: PreviewSOund.cxx
// --------------------------------------------------------------------
