// --------------------------------------------------------------------
// PreviewUpack.cxx
// Whatis:  CGI for previewing an UT Assault level
// CGI arguments:
//
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 14-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CCache.hxx"
#include	"CCgiArgs.hxx"
#include    "CPreviewFile.hxx"
#include    "CPreviewTemplate.hxx"
#include    "CPreviewLeafMenu.hxx"
#include	"CPicture.hxx"
#include	"CPictureSourceT3D.hxx"
#include	"CPictureSourceJPG.hxx"
#include	"CPictureFilterScale.hxx"
#include	"CPictureFilterAlphaBlend.hxx"
#include	"CFurpileLogo.hxx"
#include	"CSpam.hxx"

// --------------------------------------------------------------------
// local:	The local data
// --------------------------------------------------------------------
static	CCgiArgs					cgi;
static	CCache						pvcache		( "preview" );
static	CPictureFilterAlphaBlend	alphablend	( 0x1b, 0x00, 0x3e, 0xff );
static	CPreviewFile				previewfile;
static	CPreviewTemplate			previewtemplate;
static	CPreviewLeafMenu			previewleafmenu;

// --------------------------------------------------------------------
// local:	Normal file stuff
// --------------------------------------------------------------------
static	char			xpolyshot	[256]					= { 0 };

// --------------------------------------------------------------------
// local:	Parser questions are sent here for answering
// --------------------------------------------------------------------
static	void	__answer	( const char * aQ ) {

	// ----------------------------------------------------------------
	// File details parsing
	// ----------------------------------------------------------------
	if		( previewfile.Answer( aQ ) )		;
	else if	( previewleafmenu.Answer( aQ ) )	;

	// ----------------------------------------------------------------
	// File caching
	// ----------------------------------------------------------------
	else if	( ! ::strcmp( aQ, "imageurl" ) )		::printf( "%s", pvcache.UrlBase() );
	else if	( ! ::strcmp( aQ, "xpolyshot" ) )		::printf( "%s", xpolyshot );

	// ----------------------------------------------------------------
	// Parsing the CGI data
	// ----------------------------------------------------------------
	else if	( ::cgi_parser( cgi, aQ ) )	;

	// ----------------------------------------------------------------
	// Everything else goes to default parser
	// ----------------------------------------------------------------
	else	::my_default_answer( aQ );
}

// --------------------------------------------------------------------
// local:	Create the preview image and output it
// --------------------------------------------------------------------
static	void	__output_T3DInfo	( void ) {

	char	xspath[1024];
	int		camera	= T3D_CAMERA_FRONT;

	::sprintf( xpolyshot, "%d-sx-%d.jpg", previewfile.File().file_idnt, camera );
	pvcache.MakeDirname( xspath, xpolyshot );

	// Create the file if it does not exist
	if	( ! pvcache.Exist( xspath ) ) {
		CPictureSourceT3D	myt3d( previewfile.FilePath() );
		CPictureSourceJPG	myjpg( xspath, 70 );
		CPicture			mypicture;
		CFurpileLogo		logo( "Furpile.utx" );

		myt3d.Camera( camera );

		while	( ( myt3d.W() < 512 ) && ( myt3d.H() < 512 ) ) {
			myt3d.Factor( myt3d.Factor() * 1.2 );
		}


		mypicture.Load( myt3d );

		if	( mypicture.W() > 640 ) {
			CPictureFilterScale	scale( 640, (mypicture.H() * 640) / mypicture.W() );
			mypicture.Filter( scale );
		}

		mypicture.Filter( alphablend );
		logo.Plant( mypicture.PixmapRef() );
		mypicture.Save( myjpg );
		pvcache.Cache( xspath );
	}
	previewtemplate.Execute( __answer, "tmpl-prv-render-t3df" );

}

// --------------------------------------------------------------------
// local:	Prevent spam
// --------------------------------------------------------------------
static	bool	__spam	( void ) {
	bool	is_spam	= false;

	try	{
		CSpam	myspam1( cgi.Arg( CGI_REMOTE_ADDR ), cgi.Arg( CGI_QUERY_STRING ), 1 );
	}

	catch	( CError e ) {
		is_spam = true;
	}

	return	is_spam;
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );
	::HTTP_text( "en" );

	try	{
		if	( __spam() ) {
			previewtemplate.Execute( __answer, "tmpl-spam-warning" );
			::fflush( stdout );
			::fclose( stdout );
			return	-1;
		}

		// Load the file we are going to preview
		previewfile.Load( ::atol( cgi.Arg( "file_idnt" ) ) );

		// Set up the leaf menu
		previewleafmenu.Load( ::atol( cgi.Arg( "file_idnt" ) ), LEAFMENU_RENDERCONTENT );

		previewtemplate.Execute( __answer, "tmpl-prv-head" );		// Top of the form

		__output_T3DInfo();

		previewtemplate.Execute( __answer, "tmpl-prv-tail" );		// End of story
	}

	catch 	( CError e ) {
		::printf( "Error : " );
		::HTML_quote( e.Error() );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}

	catch	( ... ) {
		::printf( "Error : Unknown error" );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}
	::fflush( stdout );
	::fclose( stdout );
    return	0;
}

// --------------------------------------------------------------------
// EOF: PreviewUpack.cxx
// --------------------------------------------------------------------
