// --------------------------------------------------------------------
// PreviewText.cxx
// Whatis:  CGI for previewing an UT Assault level
// CGI arguments:
//
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 14-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CStorage.hxx"
#include    "CCache.hxx"
#include    "CPreviewFile.hxx"
#include	"CPreviewText.hxx"
#include    "CPreviewTemplate.hxx"
#include    "CPreviewLeafMenu.hxx"
#include	"CCgiArgs.hxx"
#include	"CSpam.hxx"

// --------------------------------------------------------------------
// local:	The local data
// --------------------------------------------------------------------
static	CCgiArgs					cgi;
static	CPreviewFile				previewfile;
static	CPreviewText				previewtext;
static	CPreviewTemplate			previewtemplate;
static	CPreviewLeafMenu			previewleafmenu;

// --------------------------------------------------------------------
// local:	Parser questions are sent here for answering
// --------------------------------------------------------------------
static	void	__answer	( const char * aQ ) {

	// ----------------------------------------------------------------
	// File details parsing
	// ----------------------------------------------------------------
	if		( previewfile.Answer( aQ ) )		;
	else if	( previewleafmenu.Answer( aQ ) )	;
	else if	( ! ::strcmp( aQ, "textcontent" ) )		previewtext.OutputHttp( previewfile.File().file_idnt );

	// ----------------------------------------------------------------
	// Parsing the CGI data
	// ----------------------------------------------------------------
	else if	( ::cgi_parser( cgi, aQ ) )	;

	// ----------------------------------------------------------------
	// Everything else goes to default parser
	// ----------------------------------------------------------------
	else	::my_default_answer( aQ );
}

// --------------------------------------------------------------------
// local:	Preview the file intended (as a source file)
// --------------------------------------------------------------------
static	void	__preview_intended	( bool aIntend ) {
	// Set up the leaf menu
	previewleafmenu.Load( ::atol( cgi.Arg( "file_idnt" ) ), LEAFMENU_TEXTCONTENT );
	previewtemplate.Execute( __answer, "tmpl-prv-head" );
	if	( aIntend )	previewtemplate.Execute( __answer, "tmpl-prv-render-code" );
	else			previewtemplate.Execute( __answer, "tmpl-prv-render-text" );
	previewtemplate.Execute( __answer, "tmpl-prv-tail" );
}

// --------------------------------------------------------------------
// local:	Prevent spam
// --------------------------------------------------------------------
static	bool	__spam	( void ) {
	bool	is_spam	= false;

	try	{
		CSpam	myspam1( cgi.Arg( CGI_REMOTE_ADDR ), cgi.Arg( CGI_QUERY_STRING ), 1 );
	}

	catch	( CError e ) {
		is_spam = true;
	}

	return	is_spam;
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );
	::HTTP_text( "en" );

	try	{

		if	( __spam() ) {
			previewtemplate.Execute( __answer, "tmpl-spam-warning" );
			::fflush( stdout );
			::fclose( stdout );
			return	-1;
		}

		// Load the file we are going to preview
		previewfile.Load( ::atol( cgi.Arg( "file_idnt" ) ) );
		
		// Now, the file MUST be a text file ...
		if		( ! ::strcmp( previewfile.File().file_typ2, "TXT" ) )		__preview_intended( false );
		else if	( ! ::strcmp( previewfile.File().file_typ2, "TXT-INI" ) )	__preview_intended( true );
		else if	( ! ::strcmp( previewfile.File().file_typ2, "TXT-INT" ) )	__preview_intended( true );
		else if	( ! ::strcmp( previewfile.File().file_typ2, "UCC" ) )		__preview_intended( true );
		else if	( ! ::strcmp( previewfile.File().file_typ2, "HTM" ) )		__preview_intended( true );
		else if	( ! ::strcmp( previewfile.File().file_typ2, "UHT" ) )		__preview_intended( true );
		else if	( ! ::strcmp( previewfile.File().file_typ2, "UPL" ) )		__preview_intended( true );
		else if	( ! ::strcmp( previewfile.File().file_typ2, "INI" ) )		__preview_intended( true );
		else {
			throw	CError( previewfile.File().file_name, "Not a document" );
		}

	}

	catch 	( CError e ) {
		::printf( "Error : " );
		::HTML_quote( e.Error() );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}

	catch	( ... ) {
		::printf( "Error : Unknown error" );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}
	::fflush( stdout );
	::fclose( stdout );
    return	0;
}

// --------------------------------------------------------------------
// EOF: PreviewText.cxx
// --------------------------------------------------------------------
