// --------------------------------------------------------------------
// Soundshot.cxx
// Whatis:  CGI for extracting a screenshot from an UNR file
// CGI arguments:
//
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 14-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include	"CCgiArgs.hxx"
#include	"CUnSound.hxx"
#include	"CPreviewFile.hxx"

// --------------------------------------------------------------------
// local:	The local data
// --------------------------------------------------------------------
static	CCgiArgs		cgi;
static	CPreviewFile	previewfile;


// --------------------------------------------------------------------
// local:	Send the image data
// --------------------------------------------------------------------
static	void	__send_soundshot	( void ) {
	previewfile.Load( ::atol( cgi.Arg( "file_idnt" ) ) );

	CUnFile			f( previewfile.FilePath() );
	CUnNameTable	n( f );
	CUnImportTable	i( f );
	CUnExportTable	e( f );
	CUnExport		exp = e.Export( ::atol( cgi.Arg( "object" ) ) );

	if	( n.Find( "sound" ) != i.Import( NAMEIMPORT( exp.Class() ) ).ObjectName() ) {
		throw	CError( "No sound found" );
	}

	CUnSound	mysound( f, n, e, i, n.Name( exp.ObjectName() ), true );
	if		( ! ::my_stricmp( mysound.Format(), "WAV" ) ) {
		::HTTP_mime( "audio/wav", mysound.Size() );
		::fwrite( mysound.Data(), mysound.Size(), 1, stdout );
	}
	else if	( ! ::my_stricmp( mysound.Format(), "MP3" ) ) {
		::HTTP_mime( "audio/mpeg", mysound.Size() );
		::fwrite( mysound.Data(), mysound.Size(), 1, stdout );
	}
	else {
		throw	CError( "Unknown data type" );
	}
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );

	try	{
		__send_soundshot();

	}

	catch 	( CError e ) {
		::HTTP_text( "en" );
		::printf( "<p>Error: " );
		::HTML_quote( e.Error() );
		::printf( "</p>" );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}

	catch	( ... ) {
		::HTTP_text( "en" );
		::printf( "<p>Error: Unknown error</p>" );
		::fflush( stdout );
		::fclose( stdout );
		return	-1;
	}
	::fflush( stdout );
	::fclose( stdout );
    return	0;
}

// --------------------------------------------------------------------
// EOF: Screenshot.cxx
// --------------------------------------------------------------------
