// --------------------------------------------------------------------
// UnrImport.cxx
// Whatis:  Imports Unreal file(s) and package(s)
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 02-JUN-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CImportFile.hxx"
#include	"CTableFile.hxx"
#include	"CTablePackFile.hxx"
#include	"CFileScore.hxx"

// --------------------------------------------------------------------
// local:	Some database tables needed
// --------------------------------------------------------------------
static	CTableFile		file;
static	CTableType		type;
static	CTablePack		pack;
static	CTablePackFile	packfile;
static	dword_t			userid	= 0;


// --------------------------------------------------------------------
// local:	Set up author information on a package
// --------------------------------------------------------------------
static	void	__set_pack_author	( dword_t	aPackId ) {
	CMySqlConnect		db( "quest", "", "UTCMS" );
	CMySqlWhere			w;
	data_packfile_tl	pflist;
	data_packfile_tli	pfloop;
	data_file_tl		flist;
	data_file_tl		list;
	data_file_tli		loop;
	data_file_t			data;
	data_type_tl		tlist;
	data_type_t			tdata;
	dword_t				authorid	= 0;
	dword_t				authorprio	= 0;
	

	w << "packfile_pack=" << aPackId;
	pflist = packfile.Select( db, w );

	// Now, get all files in this package
	for	( pfloop = pflist.begin(); pfloop != pflist.end(); pfloop++ ) {
		w = "";
		w << "file_idnt=" << (*pfloop).packfile_file;
		flist = file.Select( db, w );
		if	( flist.size() > 0 ) {
			list.push_back( *(flist.begin()) );

			CFileScore	myscore( (*pfloop).packfile_file );
			myscore.Update();
		}
	}

	// Search a file entry that has an author and the file is used in this pack only
	// Also, check the file type priority
	for	( loop = list.begin(); loop != list.end(); loop++ ) {
		if	( (*loop).file_auth > 0 ) {
			w = "";
			w << "packfile_file=" << (*loop).file_idnt;
			if	( packfile.Count( db, w ) == 1 ) {
				w = "";
				w << "type_idnt=" << (*loop).file_type;
				tlist = type.Select( db, w );

				if	( tlist.size() > 0 ) {
					tdata = *(tlist.begin());
					if	( tdata.type_apri >= authorprio ) {
						authorid	= (*loop).file_auth;
						authorprio	= tdata.type_apri;
					}
				}
			}
		}
	}

	// Did we find any ?
	if	( authorid > 0 ) {
		for	( loop = list.begin(); loop != list.end(); loop++ ) {
			if	( (*loop).file_auth == 0 ) {
				data = *loop;
				data.file_auth = authorid;
				file.Update( db, &data );
			}
		}
		CFileScore	myscore( 0 );
		myscore.AuthorScore( authorid );
		myscore.Update();
	}
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	int			result	= 0;
	int			arg;

	try	{
		if	( aAc < 3 ) throw CError( "Usage UnrImport user file ..." );

		CImportFile	import( aAv[1] );

		userid = import.User().user_idnt;

		for	( arg = 2; arg < aAc; arg++ ) {
			import.Import( aAv[arg] );

			data_pack_tl	list = import.PackList();
			data_pack_tli	loop;

			// Set up author information on each package
			for	( loop = list.begin(); loop != list.end(); loop++ ) {
				__set_pack_author( (*loop).pack_idnt );
			}

		}
    }

    catch   ( CError e ) {
		::printf( "UnrImport: ERROR: %s\n", e.Error() );
        result = -1;
    }

    catch   ( ... ) {
		::printf( "UnrImport: ERROR: Abort\n" );
        result = -1;
    }

    return  result;
}

// --------------------------------------------------------------------
// EOF: UnrImport.cxx
// --------------------------------------------------------------------
