// --------------------------------------------------------------------
// UserAdmin.cxx
// Whatis:  CGI for administering teh users
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 15-SEP-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include    "CSession.hxx"
#include	"CCgiArgs.hxx"
#include	"CCache.hxx"
#include	"CStorage.hxx"
#include	"CIdentifyFile.hxx"
#include    "CPreviewTemplate.hxx"
#include    "CPreviewText.hxx"
#include	"CMySqlWhere.hxx"
#include	"CTableUser.hxx"
#include	"CTablePref.hxx"
#include	"CTableFile.hxx"
#include	"CTableAuth.hxx"
#include	"CTablePack.hxx"

// --------------------------------------------------------------------
// local:	Save argument name list
// --------------------------------------------------------------------
static	const char *	saveargs[] = {
	"edit", "forw", "page", "task",
	"user_name", "user_logn", "user_pass", "user_pass2",
	"flag_deny_read", "flag_deny_view", "flag_deny_suggest", "flag_use_cookies",
	"flag_deny_write", "flag_deny_mod", "flag_deny_ren", "flag_deny_del",
	"flag_fixflag", "flag_accepted", "flag_banned", "flag_superuser",
	"flag_newsadmin", "flag_reviadmin", "flag_commadmin", "poetry", "portrait",

	NULL
};

// --------------------------------------------------------------------
// local:	The CGI arguments
// --------------------------------------------------------------------
static	CCgiArgs		cgi;
static	CMySqlConnect	db( "quest", "", "UTCMS" );
static	dword_t			userid	= 0;
static	dword_t			editid	= 0;
static	dword_t			sessid	= 0;
static	dword_t			pagenow	= 0;
static	dword_t			lastpage= 0;
static	CCache			pvcache( "preview" );
static	CPreviewTemplate	previewtemplate;
static	CPreviewText		previewtext;

// --------------------------------------------------------------------
// local:	Some database tables needed
// --------------------------------------------------------------------
static	CTablePref		pref;
static	CTableUser		user;
static	CTableFile		file;
static	CTableAuth		auth;
static	CTablePack		pack;

// --------------------------------------------------------------------
// local:	Data associated with those tables
// --------------------------------------------------------------------
static	data_user_t		userdata		= { 0 };
static	data_user_t		logndata		= { 0 };
static	data_file_t		filedata		= { 0 };
static	dword_t			rownumber		= 0;

// --------------------------------------------------------------------
// local:	Portrait image filename and url name
// --------------------------------------------------------------------
static	char			imagename	[1024]	= { 0 };

// --------------------------------------------------------------------
// local:	Output first part for true, last part for false
//			The parts are separated by '\' character
// --------------------------------------------------------------------
static	void	__outpart	( 	const char *	aS,
								bool			aFirst ) {
	char *	cs	= ::my_private_strdup( aS );
	char *	s	= ::strchr( cs, '|' );

	if	( s ) {
		*s = 0;
		s++;
	}
	else {
		s = "";
	}

	::printf( "%s", aFirst ? cs : s );

	delete [] cs;
}

// --------------------------------------------------------------------
// local:	Output something depending on state of a flag
// --------------------------------------------------------------------
static	void	__onflag	( 	const data_user_t &	aU,
								const char * 		aS ) {

	if		( ! ::strncmp( aS, "DENY_READ?", 	10 ) )	__outpart( aS + 10, (aU.user_flag & FLAG_DENY_READ) != 0 );
	else if	( ! ::strncmp( aS, "DENY_WRITE?",	11 ) )	__outpart( aS + 11, (aU.user_flag & FLAG_DENY_WRITE) != 0 );
	else if	( ! ::strncmp( aS, "DENY_VIEW?",	10 ) )	__outpart( aS + 10, (aU.user_flag & FLAG_DENY_VIEW) != 0 );
	else if	( ! ::strncmp( aS, "DENY_MOD?",		9 ) )	__outpart( aS + 9,  (aU.user_flag & FLAG_DENY_MOD) != 0 );
	else if	( ! ::strncmp( aS, "DENY_REN?",		9 ) )	__outpart( aS + 9,  (aU.user_flag & FLAG_DENY_REN) != 0 );
	else if	( ! ::strncmp( aS, "DENY_DEL?",		9 ) )	__outpart( aS + 9,  (aU.user_flag & FLAG_DENY_DEL) != 0 );
	else if	( ! ::strncmp( aS, "FIX_FLAG?",		9 ) )	__outpart( aS + 9,  (aU.user_flag & FLAG_FIX_FLAG) != 0 );
	else if	( ! ::strncmp( aS, "ACCEPTED?",		9 ) )	__outpart( aS + 9,  (aU.user_flag & FLAG_ACCEPTED) != 0 );
	else if	( ! ::strncmp( aS, "BANNED?",		7 ) )	__outpart( aS + 7,  (aU.user_flag & FLAG_BANNED) != 0 );
	else if	( ! ::strncmp( aS, "NOSUGGEST?",	10 ) )	__outpart( aS + 10, (aU.user_flag & FLAG_NOSUGGEST) != 0 );
	else if	( ! ::strncmp( aS, "NODOWNLOAD?",	11 ) )	__outpart( aS + 11, (aU.user_flag & FLAG_NODOWNLOAD) != 0 );
	else if	( ! ::strncmp( aS, "SUPERUSER?",	10 ) )	__outpart( aS + 10, (aU.user_flag & FLAG_SUPERUSER) != 0 );
	else if	( ! ::strncmp( aS, "NEWSADMIN?",	10 ) )	__outpart( aS + 10, (aU.user_flag & FLAG_NEWSADMIN) != 0 );
	else if	( ! ::strncmp( aS, "REVIADMIN?",	10 ) )	__outpart( aS + 10, (aU.user_flag & FLAG_REVIADMIN) != 0 );
	else if	( ! ::strncmp( aS, "COMMADMIN?",	10 ) )	__outpart( aS + 10, (aU.user_flag & FLAG_COMMADMIN) != 0 );
	else if	( ! ::strncmp( aS, "USECOOKIES?",	11 ) )	__outpart( aS + 11, (aU.user_flag & FLAG_USECOOKIES) != 0 );
}

// --------------------------------------------------------------------
// local:	Extract a file
// --------------------------------------------------------------------
static	void	__extract			( const char * aFile ) {
	if	( ! pvcache.Exist( aFile ) ) {
		CStorage	storage;
		storage.Load( aFile, filedata.file_idnt );
		pvcache.Cache( aFile );
	}
}

// --------------------------------------------------------------------
// local:	Parser questions are sent here for answering
// --------------------------------------------------------------------
static	void	__answer	( const char * aQ ) {

	// ----------------------------------------------------------------
	// Local parsing
	// ----------------------------------------------------------------
	if		( ! ::strcmp( aQ, "sessid" ) )			::printf( "%d", sessid );
	else if	( ! ::strcmp( aQ, "userid" ) )			::printf( "%d", userid );
	else if	( ! ::strcmp( aQ, "pagenow" ) )			::printf( "%d", pagenow );
	else if	( ! ::strcmp( aQ, "nextpage" ) )		::printf( "%d", pagenow + 1 );
	else if	( ! ::strcmp( aQ, "prevpage" ) )		::printf( "%d", pagenow - 1 );
	else if	( ! ::strcmp( aQ, "lastpage" ) )		::printf( "%d", lastpage );
	else if	( ! ::strcmp( aQ, "linepair" ) )		::printf( "%d", rownumber & 0x01 );

	// ----------------------------------------------------------------
	// User entered text
	// ----------------------------------------------------------------
	else if	( ! ::strcmp( aQ, "poetry" ) ) {
		if	( userdata.user_text ) previewtext.OutputHttpBr( userdata.user_text );
	}
	else if	( ! ::strcmp( aQ, "imageurl" ) )		::printf( "%s", pvcache.UrlBase() );
	else if	( ! ::strcmp( aQ, "portrait" ) )		::printf( "%s", imagename );

	// ----------------------------------------------------------------
	// The onflag directive
	// ----------------------------------------------------------------
	else if	( ! ::strncmp( aQ, "onusrflag-", 10 ) )	__onflag( userdata, aQ + 10 );
	else if	( ! ::strncmp( aQ, "onlogflag-", 10 ) )	__onflag( logndata, aQ + 10 );

	// ----------------------------------------------------------------
	// Paging
	// ----------------------------------------------------------------
	else if	( ! ::strcmp( aQ, "pagenext_b" ) )		::printf( "%s", pagenow < lastpage ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pagenext_e" ) )		::printf( "%s", pagenow < lastpage ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "pagenext_bx" ) )		::printf( "%s", pagenow >= lastpage ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pagenext_ex" ) )		::printf( "%s", pagenow >= lastpage ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "pageprev_b" ) )		::printf( "%s", pagenow > 1 ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pageprev_e" ) )		::printf( "%s", pagenow > 1 ? "" : " -->" );

	else if	( ! ::strcmp( aQ, "pageprev_bx" ) )		::printf( "%s", pagenow <= 1 ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "pageprev_ex" ) )		::printf( "%s", pagenow <= 1 ? "" : " -->" );

	// ----------------------------------------------------------------
	// Parsing table data
	// ----------------------------------------------------------------
	else if	( ::MySqlTableParser( user.Layout(), "user", (const char *)(&userdata), aQ ) )	;

	// ----------------------------------------------------------------
	// Parsing the CGI data
	// ----------------------------------------------------------------
	else if	( ::cgi_parser( cgi, aQ ) )	;

	// ----------------------------------------------------------------
	// Everything else goes to default parser
	// ----------------------------------------------------------------
	else	::my_default_answer( aQ );
}

// --------------------------------------------------------------------
// local:	Get current user data
// --------------------------------------------------------------------
static	void	__current_user	( void ) {
	CMySqlWhere		w;
	data_user_tl	userlist;

	// Now, check if this is the superuser or the ordinary user
	if	( (logndata.user_flag & FLAG_SUPERUSER) != 0 ) {
		w << "user_idnt=" << (dword_t)::atol( cgi.Arg( "edit" ) );
	}

	// Ordinary users can only edit their own record
	else {
		w << "user_idnt=" << userid;
	}

	userlist = user.Select( db, w );

	if	( userlist.size() > 0 )	userdata = *(userlist.begin());
	else						::memset( &userdata, 0, sizeof( userdata ) );
}

// --------------------------------------------------------------------
// local:	Editing a user entry
// --------------------------------------------------------------------
static	void	__edituser	( void ) {
	CMySqlWhere		w;
	data_pref_tl	preflist;
	data_file_tl	filelist;

	// ---------------------------------------------------------------
	// Get current user data
	// ---------------------------------------------------------------
	__current_user();

	// ---------------------------------------------------------------
	// Get default portrait
	// ---------------------------------------------------------------
	preflist = pref.Select( db, " where pref_name='default-portrait'" );
	if	( preflist.size() < 1 ) {
		throw CError( "No such preference", w.Where() );
	}
	::strcpy( imagename, (*(preflist.begin())).pref_valu );

	// ---------------------------------------------------------------
	// Does the user have a portrait image submitted ?
	// ---------------------------------------------------------------
	if	( userdata.user_pict > 0 ) {
		w = "";
		w << "file_idnt=" << userdata.user_pict;
		filelist = file.Select( db, w );
		if	( filelist.size() > 0 ) {
			filedata = *(filelist.begin());

			::sprintf(	imagename, "portrait-%d.%s",
						userdata.user_idnt,
						filedata.file_suff );

			char	filepath[1024];
			pvcache.MakeDirname( filepath, imagename );
			__extract( filepath );
		}
	}

	previewtemplate.Execute( __answer, "tmpl-useradmin-edit" );
}

// --------------------------------------------------------------------
// local:	List some users - may have a wildcard or not
// --------------------------------------------------------------------
static	void	__userlist	( void ) {
	CMySqlWhere		w;
	CMySqlQuote		q;
	data_user_tl	list;
	data_user_tli	loop;

	w << "user_name like '%" << q.Quote( cgi.Arg( "name" ) ) << "%'";

	lastpage = user.Count( db, w ) / 20 + 1;

	w << " order by user_logn LIMIT "
	  << (dword_t)((pagenow-1) * 20)
	  << ",20";

	list = user.Select( db, w );

	previewtemplate.Execute( __answer, "tmpl-useradmin-list-head" );

	rownumber = 0;
	for	( loop = list.begin(); loop != list.end(); loop++ ) {
		userdata = *loop;
		previewtemplate.Execute( __answer, "tmpl-useradmin-list-body" );
		rownumber++;
	}
	previewtemplate.Execute( __answer, "tmpl-useradmin-list-tail" );
}

// --------------------------------------------------------------------
// local:	Extract the portrait image
// --------------------------------------------------------------------
static	dword_t		__extract_portrait ( void ) {
	data_file_t		portrait;
	CStorage		storage;
	const char *	filepath = cgi.Arg( "portrait" );
	char			myfile	[1024];

	::memset( &portrait, 0, sizeof( portrait ) );

	if	( *filepath != 0 ) {
		try	{
			CIdentifyFile	ident( filepath );
	
			// Is this not an image ?
			if	( ::strcmp( ident.Typ1(), "IMG" ) ) {
				throw	0;
			}
	
			// Now, add it to our storage
			::sprintf( myfile, "%s%s", ident.Name(), ident.Suff() );
			portrait = storage.Save( myfile, 0, filepath );
			::strcpy( portrait.file_typ1, ident.Typ1() );
			::strcpy( portrait.file_typ2, ident.Typ2() );
			::strcpy( portrait.file_ctgr, ident.Ctgr() );
			portrait.file_type = ident.Type().type_idnt;
			file.Update( db, &portrait );
		}
	
		catch	( ... ) {
			::memset( &portrait, 0, sizeof( portrait ) );
		}

		if	( ! ::strncmp( filepath, "./upload/", 9 ) ) {
			::unlink( filepath );
		}
	}
	return	portrait.file_idnt;
}

// --------------------------------------------------------------------
// local:	Build up the poetry text
// --------------------------------------------------------------------
static	dword_t		__extract_poetry ( void ) {
	data_file_t		poetry;
	CStorage		storage;
	const char *	phrases	= cgi.Arg( "poetry" );
	FILE *			stg		= NULL;

	::memset( &poetry, 0, sizeof( poetry ) );

	if	( *phrases != 0 ) {
		try	{
			FILE *	stg = ::fopen( "./upload/poetry.txt", "wb" );
			if	( ! stg )	throw 0;

			::fprintf( stg, "%s", phrases );
			::fclose( stg ); stg = NULL;

			CIdentifyFile	ident( "./upload/poetry.txt" );

			poetry = storage.Save( "poetry.txt", FLAG_NODOWNLOAD, "./upload/poetry.txt" );
			::strcpy( poetry.file_typ1, ident.Typ1() );
			::strcpy( poetry.file_typ2, ident.Typ2() );
			::strcpy( poetry.file_ctgr, ident.Ctgr() );
			poetry.file_type = ident.Type().type_idnt;

			file.Update( db, &poetry );
		}

		catch ( ... ) {
			::memset( &poetry, 0, sizeof( poetry ) );
		}
		if	( stg )	::fclose( stg );
		::unlink( "./upload/poetry.txt" );
	}

	return	poetry.file_idnt;
}

// --------------------------------------------------------------------
// local:	Set a flag
// --------------------------------------------------------------------
static	void	__set_flag ( dword_t & aFlag, dword_t aMask, bool aVal ) {

	if	( aVal ) {
		aFlag = aFlag | aMask;

	}
	else {
		aFlag = aFlag & (aMask ^ 0xffffffff);
	}
}

// --------------------------------------------------------------------
// local:	Fill in user record from a form
// --------------------------------------------------------------------
static	bool	__fill_from_form ( data_user_t & aUser ) {
	aUser = userdata;
	aUser.user_pict = 0;

	// The user name can only be changed by superuser
	if	( (logndata.user_flag & FLAG_SUPERUSER) != 0 ) {
		::my_strfit( aUser.user_name, sizeof( aUser.user_name ), cgi.Arg("user_name") );
	}

	// The user login name can only be changed by superuser
	if	( (logndata.user_flag & FLAG_SUPERUSER) != 0 ) {
		::my_strfit( aUser.user_logn, sizeof( aUser.user_logn ), cgi.Arg("user_logn") );

		// Check if the login name is already taken
		CMySqlWhere		w;
		CMySqlQuote		q;
		data_user_tl	list;

		w << "user_logn='" << q.Quote( aUser.user_logn ) << "'";
		list = user.Select( db, w );
		if	( list.size() > 0 ) {
			if	( (*(list.begin())).user_idnt != aUser.user_idnt ) {
				return	false;
			}
		}
	}

	// Password can be changed by anyone - it must not be empty though
	// Also, the passwords must match, too long one are truncated
	if	( ::strlen( cgi.Arg( "user_pass" ) ) < 5 )	return false;
	if	( ::strcmp( cgi.Arg( "user_pass" ), cgi.Arg( "user_pass2" ) ) )	return false;
	::my_strfit( aUser.user_pass, sizeof( aUser.user_pass ) / 2, cgi.Arg("user_pass") );

	// Extract poetry and portrait
	aUser.user_text = __extract_poetry();
	aUser.user_pict = __extract_portrait();


	// The flags
	dword_t	flags = aUser.user_flag;

	// Flags that anyone can change if they are not fixed
	if	( (flags & FLAG_FIX_FLAG) == 0 ) {
		__set_flag( flags, FLAG_DENY_READ,	cgi.Exist( "flag_deny_read" ) );
		__set_flag( flags, FLAG_DENY_VIEW,	cgi.Exist( "flag_deny_view" ) );
		__set_flag( flags, FLAG_NOSUGGEST,	cgi.Exist( "flag_deny_suggest" ) );
		__set_flag( flags, FLAG_USECOOKIES,	cgi.Exist( "flag_use_cookies" ) );
	}

	// Flags that only the superuser can change
	if	( (logndata.user_flag & FLAG_SUPERUSER) != 0 ) {
		__set_flag( flags, FLAG_DENY_WRITE,	! cgi.Exist( "flag_deny_write" ) );
		__set_flag( flags, FLAG_DENY_MOD,	! cgi.Exist( "flag_deny_mod" ) );
		__set_flag( flags, FLAG_DENY_REN,	! cgi.Exist( "flag_deny_ren" ) );
		__set_flag( flags, FLAG_DENY_DEL,	! cgi.Exist( "flag_deny_del" ) );
		__set_flag( flags, FLAG_FIX_FLAG,	cgi.Exist( "flag_fixflag" ) );
		__set_flag( flags, FLAG_ACCEPTED,	cgi.Exist( "flag_accepted" ) );
		__set_flag( flags, FLAG_BANNED,		cgi.Exist( "flag_banned" ) );
		__set_flag( flags, FLAG_SUPERUSER,	cgi.Exist( "flag_superuser" ) );
		__set_flag( flags, FLAG_NEWSADMIN,	cgi.Exist( "flag_newsadmin" ) );
		__set_flag( flags, FLAG_REVIADMIN,	cgi.Exist( "flag_reviadmin" ) );
		__set_flag( flags, FLAG_COMMADMIN,	cgi.Exist( "flag_commadmin" ) );
	}

	aUser.user_flag = flags;

	return	true;
}

// --------------------------------------------------------------------
// local:	Add a new user
// --------------------------------------------------------------------
static	void	__adduser	( void ) {

	// Only superuser can do this
	if	( (logndata.user_flag & FLAG_SUPERUSER) != 0 ) {

		// ---------------------------------------------------------------
		// Fill in using data from the form
		// ---------------------------------------------------------------
		data_user_t		formuser;
		::memset( &userdata, 0, sizeof( userdata ) );

		if	( __fill_from_form( formuser ) ) {

			userdata = formuser;
	
			userdata.user_idnt = user.NextIdnt( db );
			user.Insert( db, &userdata );
			editid = userdata.user_idnt;
		}

	}
}

// --------------------------------------------------------------------
// local:	Delete an user
// --------------------------------------------------------------------
static	void	__deluser	( void ) {

	// ---------------------------------------------------------------
	// Get current user data
	// ---------------------------------------------------------------
	__current_user();

	// Only superuser can do this
	if	( (logndata.user_flag & FLAG_SUPERUSER) != 0 ) {
		CStorage	storage;

		if	( userdata.user_text > 0 )	storage.Delete( userdata.user_text );
		if	( userdata.user_pict > 0 )	storage.Delete( userdata.user_pict );

		
		CMySqlWhere		w;
		data_auth_tl	alist;
		data_auth_tli	aloop;
		data_auth_t		adata;

		w << "auth_user=" << userdata.user_idnt;
		alist = auth.Select( db, w );

		for	( aloop = alist.begin(); aloop != alist.end(); aloop++ ) {
			adata = *aloop;
			adata.auth_user = 0;
			auth.Update( db, &adata );
		}

		data_pack_tl	plist;
		data_pack_tli	ploop;
		data_pack_t		pdata;

		w = "";
		w << "pack_user=" << userdata.user_idnt;
		plist = pack.Select( db, w );

		for	( ploop = plist.begin(); ploop != plist.end(); ploop++ ) {
			pdata = *ploop;
			pdata.pack_user = 0;
			pack.Update( db, &pdata );
		}

		user.Delete( db, &userdata );
	}
}

// --------------------------------------------------------------------
// local:	Update user data
// --------------------------------------------------------------------
static	void	__updateuser	( void ) {
	
	// ---------------------------------------------------------------
	// Get current user data
	// ---------------------------------------------------------------
	__current_user();

	// ---------------------------------------------------------------
	// Fill in using data from the form
	// ---------------------------------------------------------------
	data_user_t		formuser;
	if	( __fill_from_form( formuser ) ) {

		if	( userdata.user_text ) {
			if	( formuser.user_text != userdata.user_text ) {
				CStorage	storage;
				storage.Delete( userdata.user_text );
			}
		}

		if	( userdata.user_pict ) {
			if	( formuser.user_pict != userdata.user_pict ) {
				if	( formuser.user_pict > 0 ) {
					CStorage	storage;
					storage.Delete( userdata.user_pict );
				}
				else {
					formuser.user_pict = userdata.user_pict;
				}
			}
		}

		userdata = formuser;
		user.Update( db, &userdata );
	}
}

// --------------------------------------------------------------------
// local:	Remove portrait from user
// --------------------------------------------------------------------
static	void	__removeport	( void ) {

	// ---------------------------------------------------------------
	// Get current user data
	// ---------------------------------------------------------------
	__current_user();

	if	( userdata.user_pict > 0 ) {
		CStorage	storage;

		storage.Delete( userdata.user_pict );
		userdata.user_pict = 0;
		user.Update( db, &userdata );
	}
}

// --------------------------------------------------------------------
// local:	Clean up any mess, specifically the uploads
// --------------------------------------------------------------------
static	void	__cleanup ( void ) {
	if	( ! ::strncmp( cgi.Arg( "portrait" ), "./upload/", 9 ) ) {
		::unlink( cgi.Arg( "portrait" ) );
	}
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );
	try	{
		CSession	session(	cgi, 
								"tmpl-useradmin-logn",
								cgi.Arg("forw"),
								"./regsaves",
								saveargs );

		if	( session.Check() ) {

			::HTTP_text( "en" );

			// --------------------------------------------------------
			// First we make a copy of the logged in user record
			// --------------------------------------------------------
			logndata = session.UserData();

			// --------------------------------------------------------
			// Also, collect other useful information of the session
			// --------------------------------------------------------
			userid	= session.User();
			sessid	= session.SessId();
			editid	= ::atol( cgi.Arg( "edit" ) );

			// --------------------------------------------------------
			// More information from the cgi
			// --------------------------------------------------------
			pagenow	= ::atol( cgi.Arg( "page" ) );
			if	( pagenow < 1 )	pagenow = 1;

			switch	( ::atol( cgi.Arg( "task" ) ) ) {
				case	1:	// Editing a user account
				__edituser( );
				break;

				case	2:	// Adding a new user
				__adduser( );
				__edituser( );
				break;

				case	3:	// Deleting an user
				__deluser( );
				__userlist( );
				break;

				case	4:	// Updating user data
				__updateuser( );
				__edituser( );
				break;

				case	5:	// Remove portrait
				__removeport( );
				__edituser( );
				break;

				default:	// Defaults to listing users
				if	( (logndata.user_flag & FLAG_SUPERUSER) != 0 )	__userlist( );
				else												__edituser( );
				break;
			}
			__cleanup();
		}
    }

	catch	( CError e ) {
		::HTTP_text( "en" );
		::printf( "ERROR: %s", e.Error() );
		__cleanup();
	}

    catch   ( ... ) {
		::HTTP_text( "en" );
		::printf( "Failed to execute administering program" );
		__cleanup();
    }

	::fflush( stdout );
	::fclose( stdout );
    return	0;
}

// --------------------------------------------------------------------
// EOF: Storage.cxx
// --------------------------------------------------------------------
