// --------------------------------------------------------------------
// UserRegister.cxx
// Whatis:  CGI for letting teh users to register
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 15-SEP-2002     Created this source
// --------------------------------------------------------------------
#include    "CError.hxx"
#include	"CCgiArgs.hxx"
#include	"CMySqlWhere.hxx"
#include    "CPreviewTemplate.hxx"
#include	"CTableUser.hxx"
#include	"CTablePref.hxx"
#include	"CSession.hxx"

// --------------------------------------------------------------------
// local:	List of arguments to be saved/retrieved
// --------------------------------------------------------------------
static	const char * saveargs[] = {
	"message", "forw", "edit", "register",
	"firstname", "nickname", "lastname",
	"user_logn", "pass", "password2",
	NULL
};

// --------------------------------------------------------------------
// local:	The CGI arguments
// --------------------------------------------------------------------
static	CCgiArgs			cgi;
static	CMySqlConnect		db( "quest", "", "UTCMS" );
static	CPreviewTemplate	previewtemplate;

// --------------------------------------------------------------------
// local:	Some database tables needed
// --------------------------------------------------------------------
static	CTableUser		user;
static	CTablePref		pref;
static	data_user_t		userdata;

// --------------------------------------------------------------------
// local:	Parser questions are sent here for answering
// --------------------------------------------------------------------
static	void	__answer	( const char * aQ ) {

	// ----------------------------------------------------------------
	// local parsing
	// ----------------------------------------------------------------
	if		( ! ::strcmp( aQ, "message_b" ) )	::printf( "%s", cgi.Exist( "message" ) ? "" : "<!-- " );
	else if	( ! ::strcmp( aQ, "message_e" ) )	::printf( "%s", cgi.Exist( "message" ) ? "" : " -->" );


	// ----------------------------------------------------------------
	// Parsing the CGI data
	// ----------------------------------------------------------------
	else if	( ::cgi_parser( cgi, aQ ) )	;

	// ----------------------------------------------------------------
	// Everything else goes to default parser
	// ----------------------------------------------------------------
	else	::my_default_answer( aQ );
}

// --------------------------------------------------------------------
// local:	Check for appropriate character sets
// --------------------------------------------------------------------
static	bool	__is_lowercase	( const char * aN ) {
	const char *	str = "abcdefghijklmnopqrstuwvxyz";

	while	( *aN ) {
		if	( ! ::strchr( str, *(aN++) ) )	return false;
	}
	return	true;
}

// --------------------------------------------------------------------
static	bool	__is_lowercasemix	( const char * aN ) {
	const char *	str = "abcdefghijklmnopqrstuwvxyz0123456789";

	while	( *aN ) {
		if	( ! ::strchr( str, *(aN++) ) )	return false;
	}
	return	true;
}

// --------------------------------------------------------------------
static	bool	__is_uppercase	( const char * aN ) {
	const char *	str = "ABCDEFGHIJKLMNOPQRSTUWVXYZ";

	while	( *aN ) {
		if	( ! ::strchr( str, *(aN++) ) )	return false;
	}
	return	true;
}

// --------------------------------------------------------------------
static	bool	__is_number		( const char * aN ) {
	const char *	str = "0123456789";

	while	( *aN ) {
		if	( ! ::strchr( str, *(aN++) ) )	return false;
	}
	return	true;
}

// --------------------------------------------------------------------
// local:	Check for appropriate character sets
// --------------------------------------------------------------------
static	void	__must_be_lowercase	( const char * aN ) {
	if	( ! __is_lowercase( aN ) ) {
		throw	CError( aN, "Not lowercase" );
	}
}

// --------------------------------------------------------------------
static	void	__must_be_lowercasemix	( const char * aN ) {
	if	( ! __is_lowercasemix( aN ) ) {
		throw	CError( aN, "Not good login" );
	}
}

// --------------------------------------------------------------------
static	void	__must_be_uppercase	( const char * aN ) {
	if	( ! __is_uppercase( aN ) ) {
		throw	CError( aN, "Not uppercase" );
	}
}

// --------------------------------------------------------------------
static	void	__is_tooshort	( const char * aN, dword_t aMinLen ) {
	if	( ::strlen( aN ) < aMinLen ) {
		char	buf[64];
		::sprintf( buf, "Minimum length %d", aMinLen );
		throw	CError( "Too short", buf );
	}
}

// --------------------------------------------------------------------
static	void	__is_toolong	( const char * aN, dword_t aMaxLen ) {
	if	( ::strlen( aN ) > aMaxLen ) {
		char	nbf[64];
		::sprintf( nbf, "Maximum length %d", aMaxLen );
		throw	CError( "Too long", nbf );
	}
}

// --------------------------------------------------------------------
// local:	Check for a good first name
// --------------------------------------------------------------------
static	void	__is_good_firstname	( 	const char * 	aN ) {
	try	{
		__is_tooshort( aN, 3 );
		__is_toolong( aN, 24 );
	}
	catch	( CError e ) {
		throw	CError( "First name", e.Error() );
	}
}

// --------------------------------------------------------------------
// local:	Check for a good nick name
// --------------------------------------------------------------------
static	void	__is_good_nickname	( 	const char * 	aN ) {
	try	{
		__is_tooshort( aN, 3 );
		__is_toolong( aN, 32 );
	}
	catch	( CError e ) {
		throw	CError( "Nickname", e.Error() );
	}
}

// --------------------------------------------------------------------
// local:	Check for a good first name
// --------------------------------------------------------------------
static	void	__is_good_lastname	( 	const char * 	aN ) {
	try	{
		__is_tooshort( aN, 3 );
		__is_toolong( aN, 24 );
	}
	catch	( CError e ) {
		throw	CError( "Last name", e.Error() );
	}
}

// --------------------------------------------------------------------
// local:	Check for a good password
// --------------------------------------------------------------------
static	void	__is_good_password	( const char * aN, const char * aN2 ) {
	try	{
		__is_tooshort( aN, 5 );
		__is_toolong( aN, 16 );
		if	( ::strcmp( aN, aN2 ) ) {
			throw	CError( "mismatch" );
		}
	}
	catch	( CError e ) {
		throw	CError( "Password", e.Error() );
	}
}

// --------------------------------------------------------------------
// local:	Check for a good login name
// --------------------------------------------------------------------
static	void	__is_good_loginname	( const char * aN ) {
	try	{
		__is_tooshort( aN, 5 );
		__is_toolong( aN, 24 );
		__must_be_lowercasemix( aN );

		CMySqlWhere		w;

		w << "user_logn='" << aN << "'";
		if	( user.Count( db, w ) > 0 )	throw CError( aN, "already taken" );
	}
	catch	( CError e ) {
		throw	CError( "Login name", e.Error() );
	}
}

// --------------------------------------------------------------------
// local:	Do the registration
// --------------------------------------------------------------------
static	void	__register	( void ) {
	const char *	firstname 	= cgi.Arg( "firstname" );
	const char *	nickname	= cgi.Arg( "nickname" );
	const char *	lastname	= cgi.Arg( "lastname" );
	const char *	loginname	= cgi.Arg( "user_logn" );
	const char *	password	= cgi.Arg( "pass" );
	const char *	password2	= cgi.Arg( "password2" );

	try	{
		__is_good_firstname	( firstname );
		__is_good_nickname	( nickname );
		__is_good_lastname	( lastname );
		__is_good_loginname	( loginname );
		__is_good_password	( password, password2 );
		
		if	( ! ::my_stricmp( password, loginname ) )	throw CError( "Password is too easy to quess" );
		if	( ! ::my_stricmp( password, nickname ) )	throw CError( "Password is too easy to quess" );
		if	( ! ::my_stricmp( password, firstname ) )	throw CError( "Password is too easy to quess" );
		if	( ! ::my_stricmp( password, lastname ) )	throw CError( "Password is too easy to quess" );

		::memset( &userdata, 0, sizeof( userdata ) );

		::sprintf( 	userdata.user_name, "%s '%s' %s",
					firstname, nickname, lastname );

		::strcpy( 	userdata.user_logn, loginname );
		::strcpy( 	userdata.user_pass, password );
		userdata.user_atim = ::time( NULL );
		userdata.user_ltim = ::time( NULL );
		userdata.user_flag = FLAG_ACCEPTED | FLAG_REVIADMIN | FLAG_NEWSADMIN;
		userdata.user_idnt = user.NextIdnt( db );
		user.Insert( db, &userdata );

		// Next thing to happen is to log in into user admin
		::HTTP_html( "en" );
		::printf( "<html>\n" );
		::printf( "\t<head>\n" );
		::printf( "\t\t<title>Redirecting</title>\n" );
		::printf( "\t</head>\n" );
		::printf( 	"\t<body bgcolor=\"#1b003e\" onload=\"document.location.replace('%s?user_logn=%s&pass=",
					cgi.Arg("edit"),
					loginname );
		::CGI_quote( password );
		::printf( "');\">\n" );
		::printf( "\t\t<center><b><font color=\"Yellow\">Processing</font></b></center>\n" );
		::printf( "\t</body>\n" );
		::printf( "</html>\n" );
	}

	catch	( CError e ) {
		cgi.Arg( "message", e.Error() );
		::HTTP_text( "en" );
		previewtemplate.Execute( __answer, "tmpl-userregister-base" );
	}
}

// --------------------------------------------------------------------
// public:  Program entrypoint
// --------------------------------------------------------------------
extern  int     main( 	int aAc, char ** aAv ) {
	::srand( (unsigned int)::time( NULL ) );
	try	{
		CSession	session(	cgi, 
								NULL,
								cgi.Arg("forw"),
								"./regsaves",
								saveargs );

		// ------------------------------------------------------------
		// If succeeded in logging in with the name - we continue to editor
		// ------------------------------------------------------------
		if		( session.Check() ) {
			// Already seen the form ?
			if	( cgi.Exist( "register" ) ) {
				::HTTP_html( "en" );
				::printf( "<html>\n" );
				::printf( "\t<head>\n" );
				::printf( "\t\t<title>Redirecting</title>\n" );
				::printf( "\t</head>\n" );
				::printf( 	"\t<body bgcolor=\"#1b003e\" onload=\"document.location.replace('%s?user=%d&sess=%d');\">\n",
							cgi.Arg("edit"),
							session.User(),
							session.SessId() );
				::printf( "\t\t<center><b><font color=\"Yellow\">Processing</font></b></center>\n" );
				::printf( "\t</body>\n" );
				::printf( "</html>\n" );
			}
			else {
				session.Logout( cgi );
				::HTTP_text( "en" );
				previewtemplate.Execute( __answer, "tmpl-userregister-base" );
			}
		}
		else if	( ::strcmp( cgi.Arg( CGI_REQUEST_METHOD ), "POST" ) ) {
			if	( cgi.Exist( "register" ) ) {
				__register();
			}
			else {
				::HTTP_text( "en" );
				previewtemplate.Execute( __answer, "tmpl-userregister-base" );
			}
		}
	}

	catch	( CError e ) {
		::HTTP_text( "en" );
		::printf( "ERROR: %s", e.Error() );
	}

    catch   ( ... ) {
		::HTTP_text( "en" );
		::printf( "Failed to execute registering program" );
    }

	::fflush( stdout );
	::fclose( stdout );
    return	0;
}

// --------------------------------------------------------------------
// EOF: UserRegister.cxx
// --------------------------------------------------------------------
